/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.item;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.item.ConjurationAssembler;
import com.mike_caron.equivalentintegrations.network.ItemConfigMessage;
import com.mike_caron.mikesmodslib.block.ContainerBase;
import com.mike_caron.mikesmodslib.inventory.GhostSlot;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ConjurationAssemblerContainer
extends ContainerBase {
    private final InventoryPlayer playerInventory;
    private final ConjurationAssembler.Inventory containerInventory;
    private Slot filterSlot;
    private final int protectedSlot;
    private final int protectedIndex;
    public int currentColor;
    public static final int GUI_ID = 3;

    public ConjurationAssemblerContainer(IInventory playerInventory, ConjurationAssembler.Inventory containerInventory, int protectedIndex) {
        super(playerInventory);
        this.playerInventory = (InventoryPlayer)playerInventory;
        this.containerInventory = containerInventory;
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory);
        this.protectedIndex = protectedIndex;
        this.protectedSlot = this.findSlotForIndex(protectedIndex);
        this.currentColor = containerInventory.getCurrentColor();
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.currentColor != this.containerInventory.getCurrentColor()) {
            this.currentColor = this.containerInventory.getCurrentColor();
            this.changed = true;
        }
        if (this.changed) {
            this.triggerUpdate();
        }
    }

    protected void onReadNBT(NBTTagCompound tag) {
        super.onReadNBT(tag);
        this.changed = false;
        if (tag.func_74762_e("color") != this.currentColor) {
            this.currentColor = tag.func_74762_e("color");
            this.changed = true;
        }
    }

    protected void onWriteNBT(NBTTagCompound tag) {
        super.onWriteNBT(tag);
        tag.func_74768_a("color", this.currentColor);
    }

    public int getId() {
        return 3;
    }

    private int findSlotForIndex(int index) {
        for (Slot slot : this.field_75151_b) {
            if (slot.getSlotIndex() != this.protectedIndex || slot.field_75224_c != this.playerInventory) continue;
            return slot.field_75222_d;
        }
        return -1;
    }

    protected void addPlayerSlots(IInventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 11 + col * 18;
                int y = row * 18 + 71;
                this.func_75146_a(new Slot(playerInventory, (row + 1) * 9 + col, x, y));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = 11 + col * 18;
            int y = 129;
            this.func_75146_a(new Slot(playerInventory, col, x, y){

                public boolean func_82869_a(EntityPlayer playerIn) {
                    return this.field_75222_d != ConjurationAssemblerContainer.this.protectedSlot && super.func_82869_a(playerIn);
                }
            });
        }
    }

    protected void addOwnSlots() {
        this.filterSlot = this.func_75146_a((Slot)new GhostSlot((IInventory)this.containerInventory, 0, 83, 32){

            public boolean func_75214_a(ItemStack stack) {
                if (!super.func_75214_a(stack)) {
                    return false;
                }
                return ProjectEAPI.getEMCProxy().hasValue(stack);
            }
        });
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (index == this.protectedSlot) {
            return slot.func_75211_c();
        }
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 1) {
                slot.func_75215_d(ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            }
            if (index <= 27 ? !this.func_75135_a(itemstack1, 28, 36, false) : !this.func_75135_a(itemstack1, 1, 27, false)) {
                return ItemStack.field_190927_a;
            }
        }
        return itemstack;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickType, EntityPlayer player) {
        if (slotId == this.protectedSlot) {
            return ItemStack.field_190927_a;
        }
        if (clickType == ClickType.SWAP && dragType == this.protectedSlot) {
            return ItemStack.field_190927_a;
        }
        if (clickType == ClickType.PICKUP && slotId == 0) {
            ItemStack held = this.playerInventory.func_70445_o().func_77946_l();
            super.func_184996_a(slotId, dragType, clickType, player);
            this.playerInventory.func_70437_b(held);
            return held;
        }
        if (clickType == ClickType.QUICK_MOVE) {
            if (slotId == 0) {
                this.filterSlot.func_75215_d(ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            }
            ItemStack held = ((Slot)this.field_75151_b.get(slotId)).func_75211_c();
            if (this.filterSlot.func_75211_c().func_190926_b() && this.filterSlot.func_75214_a(held)) {
                this.filterSlot.func_75215_d(held);
                return held;
            }
        }
        return super.func_184996_a(slotId, dragType, clickType, player);
    }

    public void setCurrentColor(int color) {
        ItemConfigMessage msg = new ItemConfigMessage(1, color);
        EquivalentIntegrationsMod.networkWrapper.sendToServer((IMessage)msg);
        this.currentColor = color;
        this.notifyGuiUpdate();
    }
}

