/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.item;

import com.mike_caron.equivalentintegrations.item.ConjurationAssemblerContainer;
import com.mike_caron.mikesmodslib.block.ContainerBase;
import com.mike_caron.mikesmodslib.gui.GuiButton;
import com.mike_caron.mikesmodslib.gui.GuiContainerBase;
import com.mike_caron.mikesmodslib.gui.GuiControl;
import com.mike_caron.mikesmodslib.gui.GuiUtil;
import java.awt.Color;
import java.util.EventListener;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class ConjurationAssemblerContainerGui
extends GuiContainerBase
implements GuiButton.ClickedListener {
    public static final int WIDTH = 182;
    public static final int HEIGHT = 154;
    private static final ResourceLocation background = new ResourceLocation("equivalentintegrations", "textures/gui/conjuration_assembler_gui.png");
    private ColorButton[] colors;
    private final int[] colorRemap = new int[]{0, 1, 2, 3, 8, 9, 10, 11, 4, 5, 6, 7, 12, 13, 14, 15};
    private ConjurationAssemblerContainer container;

    public ConjurationAssemblerContainerGui(ConjurationAssemblerContainer container) {
        super((ContainerBase)container, 182, 154);
        this.container = container;
        this.initControls();
    }

    protected void addControls() {
        super.addControls();
        this.colors = new ColorButton[16];
        for (int i = 0; i < 16; ++i) {
            this.colors[i] = new ColorButton(i, this.colorRemap[i] % 4 * 12 + 9, this.colorRemap[i] / 4 * 12 + 20);
            if (this.container.currentColor == i) {
                this.colors[i].setStateTriggered(true);
            }
            this.addControl((GuiControl)this.colors[i]);
            this.colors[i].addListener((EventListener)((Object)this));
        }
    }

    public void clicked(GuiButton.ClickedEvent clickedEvent) {
        this.container.setCurrentColor(clickedEvent.id);
    }

    public void onContainerRefresh() {
        if (this.colors != null) {
            for (int i = 0; i < this.colors.length; ++i) {
                this.colors[i].setStateTriggered(i == this.container.currentColor);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected String getTitleKey() {
        return "container.conjuration_assembler.title";
    }

    private class ColorButton
    extends GuiButton {
        private final int sx;
        private final int sy;
        private boolean toggled;

        public ColorButton(int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, null);
            this.toggled = false;
            this.sx = id % 4 * width * 2;
            this.sy = id / 4 * (height * 2) + 156;
        }

        public boolean isStateTriggered() {
            return this.toggled;
        }

        public void setStateTriggered(boolean state) {
            this.toggled = state;
        }

        public ColorButton(int id, int x, int y) {
            this(id, x, y, 12, 12);
        }

        public void draw() {
            GuiButton.State state = this.state;
            if (this.toggled) {
                state = GuiButton.State.PRESSED;
            }
            int tx = this.sx;
            int ty = this.sy;
            if (state == GuiButton.State.PRESSED) {
                tx += this.width;
            }
            if (state == GuiButton.State.HOVERED) {
                ty += this.height;
            }
            GuiUtil.bindTexture((ResourceLocation)background);
            GuiUtil.setGLColor((Color)Color.WHITE);
            GuiUtil.drawTexturePart((float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)tx, (int)ty, (int)256, (int)256);
        }
    }
}

