/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.item;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.ModConfig;
import com.mike_caron.equivalentintegrations.item.AlchemicalAlgorithms;
import com.mike_caron.equivalentintegrations.item.ConjurationAssembler;
import com.mike_caron.equivalentintegrations.item.EfficiencyCatalyst;
import com.mike_caron.equivalentintegrations.item.SoulboundTalisman;
import com.mike_caron.equivalentintegrations.item.TestItem;
import com.mike_caron.mikesmodslib.item.ItemBase;
import com.mike_caron.mikesmodslib.util.MappedModelLoader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
@GameRegistry.ObjectHolder(value="equivalentintegrations")
public class ModItems {
    @GameRegistry.ObjectHolder(value="soulbound_talisman")
    public static SoulboundTalisman soulboundTalisman;
    @GameRegistry.ObjectHolder(value="alchemical_algorithms")
    public static AlchemicalAlgorithms alchemicalAlgorithms;
    @GameRegistry.ObjectHolder(value="efficiency_catalyst")
    public static EfficiencyCatalyst efficiencyCatalyst;
    @GameRegistry.ObjectHolder(value="conjuration_assembler")
    public static ConjurationAssembler conjurationAssembler;
    public static TestItem[] testItems;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new SoulboundTalisman());
        registry.register((IForgeRegistryEntry)new AlchemicalAlgorithms());
        registry.register((IForgeRegistryEntry)new EfficiencyCatalyst());
        registry.register((IForgeRegistryEntry)new ConjurationAssembler());
        ModItems.addDummyItems((IForgeRegistry<Item>)registry);
    }

    public static void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)conjurationAssembler);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initModels() {
        MappedModelLoader.Builder models = MappedModelLoader.builder();
        try {
            for (Field field : ModItems.class.getDeclaredFields()) {
                ItemBase[] items;
                if (Modifier.isStatic(field.getModifiers()) && ItemBase.class.isAssignableFrom(field.getType())) {
                    ItemBase item = (ItemBase)field.get(null);
                    item.initModel();
                }
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().isArray() || !ItemBase.class.isAssignableFrom(field.getType().getComponentType()) || (items = (ItemBase[])field.get(null)) == null) continue;
                for (ItemBase item : items) {
                    if (item == null) continue;
                    item.initModel();
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable to reflect upon myelf??");
        }
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)models.build("equivalentintegrations"));
    }

    private static void addDummyItems(IForgeRegistry<Item> registry) {
        if (ModConfig.exposeDummyTestItems) {
            testItems = new TestItem[500];
            for (int i = 0; i < testItems.length; ++i) {
                ModItems.testItems[i] = new TestItem("testitem");
                registry.register((IForgeRegistryEntry)ModItems.testItems[i]);
                NonNullList items = NonNullList.func_191196_a();
                testItems[i].func_150895_a(EquivalentIntegrationsMod.creativeTab, (NonNullList<ItemStack>)items);
                for (int m = 0; m < items.size(); ++m) {
                    ProjectEAPI.getEMCProxy().registerCustomEMC((ItemStack)items.get(m), (long)(i * items.size() + m + 1));
                }
            }
        }
    }
}

