/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.item;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.ModConfig;
import com.mike_caron.equivalentintegrations.item.ModItems;
import com.mike_caron.mikesmodslib.item.ItemBase;
import com.mike_caron.mikesmodslib.util.ItemUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SoulboundTalisman
extends ItemBase {
    public static final String id = "soulbound_talisman";
    public static final String OWNER_UUID = "OwnerUUID";
    public static final String OWNER_NAME = "OwnerName";

    public SoulboundTalisman() {
        super(id);
        this.func_77637_a(EquivalentIntegrationsMod.creativeTab);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            if (ModConfig.exposeInvalidTalisman) {
                items.add((Object)this.withOwner(UUID.randomUUID(), "A Stranger"));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack talisman = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K || SoulboundTalisman.isBound(talisman)) {
            return new ActionResult(EnumActionResult.PASS, (Object)talisman);
        }
        NBTTagCompound nbt = ItemUtils.getItemTag((ItemStack)talisman);
        SoulboundTalisman.addOwner(nbt, playerIn.func_110124_au(), playerIn.getDisplayNameString());
        talisman.func_77982_d(nbt);
        return new ActionResult(EnumActionResult.PASS, (Object)talisman);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = Objects.requireNonNull(stack.func_77978_p())).func_74764_b(OWNER_UUID)) {
            String uuid = nbt.func_74779_i(OWNER_UUID);
            String playerName = TextFormatting.OBFUSCATED + "unknown";
            if (nbt.func_74764_b(OWNER_NAME)) {
                playerName = nbt.func_74779_i(OWNER_NAME);
            }
            String tip = TextFormatting.BLUE + I18n.func_135052_a((String)"item.soulbound_talisman.bound", (Object[])new Object[]{playerName});
            tooltip.add(tip);
        }
        tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"item.soulbound_talisman.desc1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"item.soulbound_talisman.desc2", (Object[])new Object[0]));
    }

    public boolean func_77636_d(ItemStack stack) {
        return SoulboundTalisman.isBound(stack);
    }

    public static boolean isBound(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        if (stack.func_77973_b() != ModItems.soulboundTalisman) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return false;
        }
        return nbt.func_74764_b(OWNER_UUID);
    }

    @Nullable
    public static UUID getOwnerFromStack(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = Objects.requireNonNull(stack.func_77978_p())).func_74764_b(OWNER_UUID)) {
            String uuid = nbt.func_74779_i(OWNER_UUID);
            return UUID.fromString(uuid);
        }
        return null;
    }

    @Nullable
    public static String getOwnerNameFromStack(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = Objects.requireNonNull(stack.func_77978_p())).func_74764_b(OWNER_NAME)) {
            return nbt.func_74779_i(OWNER_NAME);
        }
        return null;
    }

    public static void addOwner(NBTTagCompound nbt, UUID uuid, String name) {
        nbt.func_74778_a(OWNER_UUID, uuid.toString());
        nbt.func_74778_a(OWNER_NAME, name);
    }

    public ItemStack withOwner(UUID uuid, String name) {
        ItemStack ret = new ItemStack((Item)this);
        SoulboundTalisman.addOwner(ItemUtils.getItemTag((ItemStack)ret), uuid, name);
        return ret;
    }
}

