/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CtoSMessage
implements IMessage {
    private int dim;
    private BlockPos pos;
    private KindEnum kind;
    private int powerDelta;
    private boolean onOff;

    public CtoSMessage() {
    }

    public CtoSMessage(int dim, BlockPos pos, int powerDelta) {
        this.dim = dim;
        this.pos = pos;
        this.kind = KindEnum.PowerDelta;
        this.powerDelta = powerDelta;
    }

    public CtoSMessage(int dim, BlockPos pos, KindEnum type, boolean onOff) {
        this.dim = dim;
        this.pos = pos;
        this.kind = type;
        this.onOff = onOff;
    }

    public void fromBytes(ByteBuf buf) {
        int o = buf.readInt();
        this.kind = KindEnum.values()[o];
        this.dim = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        switch (this.kind) {
            case OnOff: 
            case ToggleForbidNbt: 
            case ToggleForbidDamage: {
                this.onOff = buf.readBoolean();
                break;
            }
            case PowerDelta: {
                this.powerDelta = buf.readInt();
                break;
            }
            default: {
                throw new RuntimeException("What the? What kind of kind is " + (Object)((Object)this.kind));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.kind.ordinal());
        buf.writeInt(this.dim);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        switch (this.kind) {
            case OnOff: {
                buf.writeBoolean(this.onOff);
                break;
            }
            case PowerDelta: {
                buf.writeInt(this.powerDelta);
                break;
            }
            case ToggleForbidNbt: {
                buf.writeBoolean(this.onOff);
                break;
            }
            case ToggleForbidDamage: {
                buf.writeBoolean(this.onOff);
                break;
            }
            default: {
                throw new RuntimeException("What the? What kind of kind is " + (Object)((Object)this.kind));
            }
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getPowerDelta() {
        return this.powerDelta;
    }

    public boolean getOnOff() {
        return this.onOff;
    }

    public KindEnum getKind() {
        return this.kind;
    }

    public static enum KindEnum {
        OnOff,
        PowerDelta,
        ToggleForbidNbt,
        ToggleForbidDamage;

    }
}

