/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.network;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.item.IItemConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ItemConfigMessage
implements IMessage {
    private int discriminator;
    private int payload;

    public ItemConfigMessage() {
    }

    public ItemConfigMessage(int discriminator, int payload) {
        this.discriminator = discriminator;
        this.payload = payload;
    }

    public void fromBytes(ByteBuf buf) {
        this.discriminator = buf.readInt();
        this.payload = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.discriminator);
        buf.writeInt(this.payload);
    }

    public int getDiscriminator() {
        return this.discriminator;
    }

    public int getPayload() {
        return this.payload;
    }

    public static class Handler
    implements IMessageHandler<ItemConfigMessage, IMessage> {
        public IMessage onMessage(ItemConfigMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            WorldServer mainThread = (WorldServer)world;
            mainThread.func_152344_a(() -> {
                try {
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    Item item = stack.func_77973_b();
                    if (item instanceof IItemConfig) {
                        ((IItemConfig)item).onConfig(stack, message.discriminator, message.payload);
                    }
                }
                catch (Exception e) {
                    EquivalentIntegrationsMod.logger.error("Error while handling message", (Throwable)e);
                }
            });
            return null;
        }
    }
}

