/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.storage;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.ModConfig;
import com.mike_caron.equivalentintegrations.api.events.EMCChangedEvent;
import com.mike_caron.equivalentintegrations.impl.ManagedEMCManager;
import com.mike_caron.equivalentintegrations.integrations.projecte.ProjectEWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.event.EMCRemapEvent;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import scala.Tuple2;

public class EMCInventory {
    private final UUID owner;
    private final ManagedEMCManager emcManager;
    private final World world;
    @Nullable
    private ItemStack filter = null;
    private boolean needsRefresh = false;
    private List<ItemStack> cachedInventory = null;
    private List<ItemStack> cachedKnowledge = null;
    private Map<Tuple2<Item, Integer>, List<ItemStack>> itemIndex = null;

    public EMCInventory(@Nonnull World world, UUID owner, ManagedEMCManager manager) {
        this(world, owner, manager, null);
    }

    private EMCInventory(@Nonnull World world, UUID owner, ManagedEMCManager manager, @Nullable ItemStack filter) {
        this.owner = owner;
        this.emcManager = manager;
        this.filter = filter;
        this.world = world;
        this.refresh();
    }

    public int getSlots() {
        return this.cachedInventory.size() + 64;
    }

    public ItemStack getStackInSlot(int slot) {
        int size = this.cachedInventory.size();
        if (slot < 0 || slot >= size) {
            return ItemStack.field_190927_a;
        }
        return this.cachedInventory.get(slot);
    }

    public int getSlotLimit(int slot) {
        int size = this.cachedInventory.size();
        if (slot < 0 || slot >= size) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public List<ItemStack> inventory() {
        return this.cachedInventory;
    }

    public int realSize() {
        return this.cachedInventory.size();
    }

    public boolean refresh() {
        boolean ret;
        block2: {
            try {
                List<ItemStack> newKnowledge = ProjectEWrapper.instance.getKnowledge(this.world, this.owner);
                this.cachedKnowledge = this.filter != null ? newKnowledge.stream().filter(is -> is.func_185136_b(this.filter)).collect(Collectors.toList()) : newKnowledge;
                this.calculateInventory(this.world);
                ret = true;
            }
            catch (IllegalStateException ex) {
                EquivalentIntegrationsMod.logger.warn("Unable to refresh knowledge, due to something");
                ret = false;
                if (this.cachedKnowledge != null) break block2;
                this.cachedKnowledge = new ArrayList<ItemStack>();
            }
        }
        this.needsRefresh = !ret;
        return ret;
    }

    @SubscribeEvent
    public void onPlayerKnowledgeChange(PlayerKnowledgeChangeEvent event) {
        if (event.getPlayerUUID().equals(this.owner)) {
            EquivalentIntegrationsMod.logger.info("Refreshing cached knowledge due to knowledge change");
            this.refresh();
        }
    }

    @SubscribeEvent
    public void onEMCRemap(EMCRemapEvent event) {
        EquivalentIntegrationsMod.logger.info("Refreshing cached knowledge due to global remap");
        this.refresh();
    }

    @SubscribeEvent
    public void onEmcChanged(EMCChangedEvent event) {
        if (event.player.equals(this.owner)) {
            this.needsRefresh = true;
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        this.tick();
    }

    private void tick() {
        if (this.needsRefresh) {
            this.refresh();
            this.needsRefresh = false;
        }
    }

    private void calculateInventory(@Nonnull World world) {
        if (this.cachedInventory == null) {
            this.cachedInventory = new ArrayList<ItemStack>();
        }
        if (this.itemIndex == null) {
            this.itemIndex = new HashMap<Tuple2<Item, Integer>, List<ItemStack>>();
        } else {
            this.itemIndex.clear();
        }
        double cachedEmc = this.emcManager.getEMC(world, this.owner);
        int ix = 0;
        int addedNew = 0;
        int overwrote = 0;
        int updated = 0;
        for (int jx = 0; jx < this.cachedKnowledge.size(); ++jx) {
            int num;
            ItemStack is = this.cachedKnowledge.get(jx);
            long value = this.emcManager.getEmcValue(is);
            if (value == 0L || (num = EMCInventory.howManyCanWeMake(cachedEmc, value)) <= 0) continue;
            if (ix < this.cachedInventory.size()) {
                ItemStack cached = this.cachedInventory.get(ix);
                if (cached.func_185136_b(is)) {
                    cached.func_190920_e(num);
                    ++updated;
                } else {
                    this.cachedInventory.set(ix, new ItemStack(is.func_77973_b(), num, is.func_77960_j(), is.func_77978_p()));
                    ++overwrote;
                }
            } else {
                this.cachedInventory.add(new ItemStack(is.func_77973_b(), num, is.func_77960_j(), is.func_77978_p()));
                ++addedNew;
            }
            Tuple2 t = new Tuple2((Object)is.func_77973_b(), (Object)is.func_77960_j());
            if (!this.itemIndex.containsKey(t)) {
                this.itemIndex.put((Tuple2<Item, Integer>)t, new ArrayList());
            }
            ItemStack single = is.func_77946_l();
            single.func_190920_e(1);
            boolean found = false;
            for (ItemStack i : this.itemIndex.get(t)) {
                if (!i.func_77969_a(single)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.itemIndex.get(t).add(single);
            }
            ++ix;
        }
        while (this.cachedInventory.size() > ix) {
            this.cachedInventory.remove(ix);
        }
    }

    public boolean itemKnown(@Nonnull ItemStack single) {
        Tuple2 t = new Tuple2((Object)single.func_77973_b(), (Object)single.func_77960_j());
        if (!this.itemIndex.containsKey(t)) {
            return false;
        }
        for (ItemStack is : this.itemIndex.get(t)) {
            if (!is.func_77969_a(single)) continue;
            return true;
        }
        return false;
    }

    private static int howManyCanWeMake(double emc, long cost) {
        int cap = ModConfig.maximumExposedStackSize;
        if (cost == 0L) {
            return 0;
        }
        double raw = emc / (double)cost;
        long tmp = (long)Math.floor(raw);
        if (tmp > (long)cap) {
            return cap;
        }
        return (int)tmp;
    }

    public Collection<ItemStack> getCachedInventory() {
        return this.cachedInventory;
    }

    public EMCInventory withFilter(ItemStack filter) {
        return new EMCInventory(this.world, this.owner, this.emcManager, filter);
    }
}

