/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.storage;

import com.mike_caron.equivalentintegrations.EquivalentIntegrationsMod;
import com.mike_caron.equivalentintegrations.impl.ManagedEMCManager;
import com.mike_caron.equivalentintegrations.integrations.projecte.ProjectEWrapper;
import com.mike_caron.equivalentintegrations.storage.EMCInventory;
import com.mike_caron.equivalentintegrations.storage.IEMCInventory;
import com.mike_caron.mikesmodslib.util.LastResortUtils;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public final class EMCItemHandler
implements IItemHandlerModifiable,
IEMCInventory {
    @Nonnull
    private final UUID owner;
    @Nonnull
    private final World world;
    private int efficiencyThreshold = 10;
    private EnumLearning canLearn = EnumLearning.CANNOT;
    private boolean forbidNbt = false;
    private boolean forbidDamaged = false;
    private boolean canImport;
    private boolean canExport;
    private IEMCProxy emcProxy;
    private ManagedEMCManager emcManager;
    private final EMCInventory emcInventory;

    public EMCItemHandler(@Nonnull UUID owner, @Nonnull World world, boolean canImport, boolean canExport) {
        this(owner, world, canImport, canExport, null);
    }

    public EMCItemHandler(@Nonnull UUID owner, @Nonnull World world, boolean canImport, boolean canExport, @Nullable ItemStack filter) {
        this.owner = owner;
        this.world = world;
        this.canImport = canImport;
        this.canExport = canExport;
        this.emcProxy = ProjectEAPI.getEMCProxy();
        this.emcManager = EquivalentIntegrationsMod.getEmcManager(world);
        EMCInventory inv = this.emcManager.getEMCInventory(world, owner);
        if (filter != null) {
            inv = inv.withFilter(filter);
        }
        this.emcInventory = inv;
    }

    @Nonnull
    public UUID getOwner() {
        return this.owner;
    }

    public void setEfficiencyThreshold(int efficiencyThreshold) {
        this.efficiencyThreshold = efficiencyThreshold;
    }

    public int getEfficiencyThreshold() {
        return this.efficiencyThreshold;
    }

    public void setCanLearn(EnumLearning canLearn) {
        this.canLearn = canLearn;
    }

    public EnumLearning getCanLearn() {
        return this.canLearn;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
    }

    public int getSlots() {
        return this.emcInventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (!this.canExport) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = this.emcInventory.getStackInSlot(slot);
        return ret;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.canImport) {
            return stack;
        }
        long startTime = System.nanoTime();
        if (slot < 0 || slot >= this.emcInventory.getSlots()) {
            return stack;
        }
        if (this.emcProxy.hasValue(stack)) {
            if (this.forbidNbt && stack.func_77942_o() && stack.func_77978_p().func_186856_d() != 0) {
                return stack;
            }
            if (this.forbidDamaged && stack.func_77951_h()) {
                return stack;
            }
            if (this.canLearn != EnumLearning.CANNOT || ProjectEWrapper.instance.hasKnowledge(this.world, this.owner, stack)) {
                long singleValue = this.emcManager.getEmcSellValue(stack);
                long emcValue = singleValue * (long)stack.func_190916_E();
                emcValue -= (long)this.getEfficiencyCost(stack, emcValue);
                if (this.canLearn == EnumLearning.CAN && !this.emcManager.hasKnowledge(this.world, this.owner, stack) && !this.emcManager.tryLearn(this.world, this.owner, stack, simulate)) {
                    return stack;
                }
                if (!simulate) {
                    this.emcManager.depositEMC(this.world, this.owner, emcValue);
                }
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    public ItemStack extractItem(ItemStack desired, boolean simulate) {
        ItemStack ret;
        if (!this.canExport) {
            return ItemStack.field_190927_a;
        }
        double emc = this.emcManager.getEMC(this.world, this.owner);
        long emcCost = this.emcManager.getEmcValue(desired);
        if (emcCost == 0L) {
            return ItemStack.field_190927_a;
        }
        int actualAmount = desired.func_190916_E();
        long desiredEMC = (long)actualAmount * emcCost;
        if ((double)desiredEMC > emc) {
            actualAmount = EMCItemHandler.howManyCanWeMake(emc, emcCost);
            desiredEMC = (long)actualAmount * emcCost;
        }
        if ((double)(desiredEMC += (long)this.getEfficiencyCost(ret = new ItemStack(desired.func_77973_b(), actualAmount, desired.func_77960_j(), desired.func_77978_p()), desiredEMC)) > emc) {
            desiredEMC = (long)emc;
        }
        if (!simulate && desiredEMC > 0L) {
            this.emcManager.withdrawEMC(this.world, this.owner, desiredEMC);
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExport) {
            return ItemStack.field_190927_a;
        }
        if (slot < 0 || slot >= this.emcInventory.realSize()) {
            return ItemStack.field_190927_a;
        }
        ItemStack desired = this.emcInventory.getStackInSlot(slot);
        if (desired.func_190916_E() != amount) {
            desired = ItemHandlerHelper.copyStackWithSize((ItemStack)desired, (int)amount);
        }
        return this.extractItem(desired, simulate);
    }

    private int getEfficiencyCost(ItemStack stack, long emcCost) {
        if (emcCost < (long)this.efficiencyThreshold) {
            return 0;
        }
        return stack.func_190916_E();
    }

    public int getSlotLimit(int slot) {
        return this.emcInventory.getSlotLimit(slot);
    }

    private static int howManyCanWeMake(double emc, long cost) {
        if (cost == 0L) {
            return 0;
        }
        long tmp = Math.floorDiv((long)emc, cost);
        if (tmp > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmp;
    }

    public static void cleanupKnowledge(EntityPlayer player) {
        ProjectEWrapper.instance.cleanupKnowledge((EntityPlayerMP)player);
    }

    @Override
    public Collection<ItemStack> getCachedInventory() {
        return this.emcInventory.getCachedInventory();
    }

    public boolean getForbidNbt() {
        return this.forbidNbt;
    }

    public void setForbidNbt(boolean forbidNbt) {
        this.forbidNbt = forbidNbt;
    }

    public boolean getForbidDamaged() {
        return this.forbidDamaged;
    }

    public void setForbidDamaged(boolean forbidDamaged) {
        this.forbidDamaged = forbidDamaged;
    }

    private static boolean isPlayerOnline(UUID player) {
        return LastResortUtils.getPlayer((UUID)player) != null;
    }

    public static enum EnumLearning {
        CAN,
        CANNOT,
        SKIP;

    }
}

