/*
 * Decompiled with CFR 0.152.
 */
package com.mike_caron.equivalentintegrations.storage;

import com.mike_caron.equivalentintegrations.block.transmutation_chamber.TransmutationChamberTileEntity;
import com.mike_caron.equivalentintegrations.storage.EMCItemHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ItemMatch;

public class SlotlessEMCItemHandler
implements ISlotlessItemHandler {
    private TransmutationChamberTileEntity parent;
    private static final Collection<ItemStack> empty = new HashSet<ItemStack>();

    public SlotlessEMCItemHandler(TransmutationChamberTileEntity parent) {
        this.parent = parent;
    }

    public Iterator<ItemStack> getItems() {
        EMCItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return empty.iterator();
        }
        return handler.getCachedInventory().iterator();
    }

    public Iterator<ItemStack> findItems(@Nonnull ItemStack itemStack, int matchFlags) {
        EMCItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return empty.iterator();
        }
        return handler.getCachedInventory().stream().filter(is -> ItemMatch.areItemStacksEqual((ItemStack)itemStack, (ItemStack)is, (int)matchFlags)).iterator();
    }

    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack itemStack, boolean simulate) {
        EMCItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return itemStack;
        }
        return handler.insertItem(0, itemStack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int amount, boolean simulate) {
        EMCItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        return handler.extractItem(0, amount, simulate);
    }

    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack itemStack, int matchFlags, boolean simulate) {
        EMCItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        if (15 == (matchFlags & 0xF)) {
            return handler.extractItem(itemStack, simulate);
        }
        ItemStack found = handler.getCachedInventory().stream().filter(is -> ItemMatch.areItemStacksEqual((ItemStack)itemStack, (ItemStack)is, (int)matchFlags)).findFirst().orElse(null);
        if (found == null) {
            return ItemStack.field_190927_a;
        }
        return handler.extractItem(found, simulate);
    }

    public int getLimit() {
        EMCItemHandler handler = this.getItemHandler();
        if (handler == null) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    private EMCItemHandler getItemHandler() {
        return this.parent.getEmcItemHandler();
    }
}

