/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import java.util.Iterator;
import java.util.List;
import mekanism.common.entity.EntityRobit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RobitAIPickup
extends EntityAIBase {
    private EntityRobit theRobit;
    private World world;
    private float moveSpeed;
    private PathNavigate thePathfinder;
    private int ticker;
    private float oldWaterCost;
    private EntityItem closest;

    public RobitAIPickup(EntityRobit entityRobit, float speed) {
        this.theRobit = entityRobit;
        this.world = entityRobit.field_70170_p;
        this.moveSpeed = speed;
        this.thePathfinder = entityRobit.getNavigator();
    }

    public boolean func_75250_a() {
        if (!this.theRobit.getDropPickup()) {
            return false;
        }
        if (this.closest != null && this.closest.func_70068_e((Entity)this.closest) > 100.0 && this.thePathfinder.func_75488_a(this.closest.field_70165_t, this.closest.field_70163_u, this.closest.field_70161_v) != null) {
            return true;
        }
        List items = this.theRobit.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(this.theRobit.field_70165_t - 10.0, this.theRobit.field_70163_u - 10.0, this.theRobit.field_70161_v - 10.0, this.theRobit.field_70165_t + 10.0, this.theRobit.field_70163_u + 10.0, this.theRobit.field_70161_v + 10.0));
        Iterator iter = items.iterator();
        double closestDistance = -1.0;
        while (iter.hasNext()) {
            EntityItem entity = (EntityItem)iter.next();
            double distance = this.theRobit.func_70032_d((Entity)entity);
            if (!(distance <= 10.0) || closestDistance != -1.0 && !(distance < closestDistance) || this.thePathfinder.func_75488_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) == null) continue;
            this.closest = entity;
            closestDistance = distance;
        }
        return this.closest != null && !this.closest.field_70128_L;
    }

    public boolean func_75253_b() {
        return !this.closest.field_70128_L && !this.thePathfinder.func_75500_f() && this.theRobit.func_70068_e((Entity)this.closest) > 100.0 && this.theRobit.getDropPickup() && this.theRobit.getEnergy() > 0.0 && this.closest.field_70170_p.field_73011_w.getDimension() == this.theRobit.field_70170_p.field_73011_w.getDimension();
    }

    public void func_75249_e() {
        this.ticker = 0;
        this.oldWaterCost = this.theRobit.func_184643_a(PathNodeType.WATER);
        this.theRobit.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.thePathfinder.func_75499_g();
        this.theRobit.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        if (!this.theRobit.getDropPickup()) {
            return;
        }
        this.theRobit.func_70671_ap().func_75651_a((Entity)this.closest, 6.0f, (float)(this.theRobit.func_70646_bf() / 10));
        if (--this.ticker <= 0) {
            this.ticker = 10;
            if (!this.thePathfinder.func_75497_a((Entity)this.closest, (double)this.moveSpeed) && this.theRobit.func_70068_e((Entity)this.closest) >= 144.0) {
                int x = MathHelper.func_76128_c((double)this.closest.field_70165_t) - 2;
                int y = MathHelper.func_76128_c((double)this.closest.func_174813_aQ().field_72338_b);
                int z = MathHelper.func_76128_c((double)this.closest.field_70161_v) - 2;
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        BlockPos pos = new BlockPos(x + l, y, z + i1);
                        BlockPos under = new BlockPos(x + l, y - 1, z + i1);
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.world.func_180495_p(under).isSideSolid((IBlockAccess)this.world, under, EnumFacing.UP) || !this.isEmptyBlock(pos) || !this.isEmptyBlock(new BlockPos(x + l, y + 1, z + i1))) continue;
                        this.theRobit.func_70012_b((float)(x + l) + 0.5f, y, (float)(z + i1) + 0.5f, this.theRobit.field_70177_z, this.theRobit.field_70125_A);
                        this.thePathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    private boolean isEmptyBlock(BlockPos pos) {
        IBlockState iblockstate = this.world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        return block == Blocks.field_150350_a ? true : !iblockstate.func_185917_h();
    }
}

