/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block;

import com.raoulvdberge.refinedstorage.block.BlockCable;
import com.raoulvdberge.refinedstorage.block.info.BlockDirection;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.collision.CollisionGroup;
import com.raoulvdberge.refinedstorage.render.constants.ConstantsExporter;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockExporter
extends BlockCable {
    public BlockExporter() {
        super(BlockExporter.createBuilder("exporter").tileEntity(TileExporter::new).create());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "direction=north,down=false,east=true,north=false,south=false,up=false,west=true"));
        this.registerCover(modelRegistration);
    }

    @Override
    @Nullable
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    public List<CollisionGroup> getCollisions(TileEntity tile, IBlockState state) {
        List<CollisionGroup> groups = super.getCollisions(tile, state);
        switch ((EnumFacing)state.func_177229_b((IProperty)this.getDirection().getProperty())) {
            case NORTH: {
                groups.add(ConstantsExporter.LINE_NORTH);
                break;
            }
            case EAST: {
                groups.add(ConstantsExporter.LINE_EAST);
                break;
            }
            case SOUTH: {
                groups.add(ConstantsExporter.LINE_SOUTH);
                break;
            }
            case WEST: {
                groups.add(ConstantsExporter.LINE_WEST);
                break;
            }
            case UP: {
                groups.add(ConstantsExporter.LINE_UP);
                break;
            }
            case DOWN: {
                groups.add(ConstantsExporter.LINE_DOWN);
            }
        }
        return groups;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.canAccessGui(state, world, pos, hitX, hitY, hitZ)) {
            return false;
        }
        return this.openNetworkGui(4, player, world, pos, side);
    }
}

