/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.color.ItemColorPattern;
import com.raoulvdberge.refinedstorage.render.model.baked.BakedModelPattern;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPattern
extends ItemBase
implements ICraftingPatternProvider {
    private static Map<ItemStack, CraftingPattern> PATTERN_CACHE = new HashMap<ItemStack, CraftingPattern>();
    private static final String NBT_VERSION = "Version";
    public static final String NBT_INPUT_SLOT = "Input_%d";
    public static final String NBT_OUTPUT_SLOT = "Output_%d";
    private static final String NBT_FLUID_INPUT_SLOT = "FluidInput_%d";
    private static final String NBT_FLUID_OUTPUT_SLOT = "FluidOutput_%d";
    private static final String NBT_OREDICT = "Oredict";
    public static final String NBT_PROCESSING = "Processing";

    public ItemPattern() {
        super(new ItemInfo("refinedstorage", "pattern"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
        modelRegistration.addBakedModelOverride(this.info.getId(), BakedModelPattern::new);
        modelRegistration.addItemColor(this, new ItemColorPattern());
    }

    public static CraftingPattern getPatternFromCache(World world, ItemStack stack) {
        if (!PATTERN_CACHE.containsKey(stack)) {
            PATTERN_CACHE.put(stack, new CraftingPattern(world, null, stack));
        }
        return PATTERN_CACHE.get(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (!stack.func_77942_o()) {
            return;
        }
        CraftingPattern pattern = ItemPattern.getPatternFromCache(world, stack);
        if (pattern.isValid()) {
            if (GuiScreen.func_146272_n() || ItemPattern.isProcessing(stack)) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.inputs", (Object[])new Object[0]) + TextFormatting.RESET);
                RenderUtils.addCombinedItemsToTooltip(tooltip, true, pattern.getInputs().stream().map(i -> i.size() > 0 ? (ItemStack)i.get(0) : ItemStack.field_190927_a).collect(Collectors.toList()));
                RenderUtils.addCombinedFluidsToTooltip(tooltip, true, pattern.getFluidInputs());
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.outputs", (Object[])new Object[0]) + TextFormatting.RESET);
            }
            RenderUtils.addCombinedItemsToTooltip(tooltip, true, pattern.getOutputs());
            RenderUtils.addCombinedFluidsToTooltip(tooltip, true, pattern.getFluidOutputs());
            if (ItemPattern.isOredict(stack)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"misc.refinedstorage:pattern.oredict", (Object[])new Object[0]) + TextFormatting.RESET);
            }
            if (ItemPattern.isProcessing(stack)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"misc.refinedstorage:processing", (Object[])new Object[0]) + TextFormatting.RESET);
            }
        } else {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"misc.refinedstorage:pattern.invalid", (Object[])new Object[0]) + TextFormatting.RESET);
        }
    }

    public static void setInputSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74782_a(String.format(NBT_INPUT_SLOT, slot), (NBTBase)stack.serializeNBT());
    }

    @Nullable
    public static ItemStack getInputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_INPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return null;
        }
        ItemStack stack = new ItemStack(pattern.func_77978_p().func_74775_l(id));
        if (stack.func_190926_b()) {
            return null;
        }
        return stack;
    }

    public static void setOutputSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74782_a(String.format(NBT_OUTPUT_SLOT, slot), (NBTBase)stack.serializeNBT());
    }

    @Nullable
    public static ItemStack getOutputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_OUTPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return null;
        }
        ItemStack stack = new ItemStack(pattern.func_77978_p().func_74775_l(id));
        if (stack.func_190926_b()) {
            return null;
        }
        return stack;
    }

    public static void setFluidInputSlot(ItemStack pattern, int slot, FluidStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74782_a(String.format(NBT_FLUID_INPUT_SLOT, slot), (NBTBase)stack.writeToNBT(new NBTTagCompound()));
    }

    @Nullable
    public static FluidStack getFluidInputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_FLUID_INPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)pattern.func_77978_p().func_74775_l(id));
    }

    public static void setFluidOutputSlot(ItemStack pattern, int slot, FluidStack stack) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74782_a(String.format(NBT_FLUID_OUTPUT_SLOT, slot), (NBTBase)stack.writeToNBT(new NBTTagCompound()));
    }

    @Nullable
    public static FluidStack getFluidOutputSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_FLUID_OUTPUT_SLOT, slot);
        if (!pattern.func_77942_o() || !pattern.func_77978_p().func_74764_b(id)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)pattern.func_77978_p().func_74775_l(id));
    }

    public static boolean isProcessing(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_PROCESSING) && pattern.func_77978_p().func_74767_n(NBT_PROCESSING);
    }

    public static void setProcessing(ItemStack pattern, boolean processing) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74757_a(NBT_PROCESSING, processing);
    }

    public static boolean isOredict(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_OREDICT) && pattern.func_77978_p().func_74767_n(NBT_OREDICT);
    }

    public static void setOredict(ItemStack pattern, boolean oredict) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74757_a(NBT_OREDICT, oredict);
    }

    public static void setVersion(ItemStack pattern) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74778_a(NBT_VERSION, "1.6.12");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RSItems.PATTERN, player.func_184586_b(hand).func_190916_E()));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    @Nonnull
    public ICraftingPattern create(World world, ItemStack stack, ICraftingPatternContainer container) {
        return new CraftingPattern(world, container, stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, slot, isSelected);
        if (!world.field_72995_K) {
            API.instance().getOneSixMigrationHelper().migratePattern(stack);
        }
    }
}

