/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui.elements;

import aroma1997.core.client.gui.GuiBase;
import aroma1997.core.client.gui.IRenderable;
import aroma1997.core.client.gui.StaticTexture;
import aroma1997.core.client.gui.elements.GuiElement;
import aroma1997.core.client.util.RenderHelper;
import aroma1997.core.util.LocalizationHelper;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementTank
extends GuiElement
implements IRenderable {
    private static final int INNER_X_OFFSET = 4;
    private static final int INNER_Y_OFFSET = 4;
    protected final IFluidTank fluidTank;

    public GuiElementTank(GuiBase<?> gui, int x, int y, IFluidTank tank) {
        super(gui, x, y, 20, 55);
        this.fluidTank = tank;
        this.setTexture(this);
        this.addHoverTooltip(this::getFluidName);
        this.addHoverTooltip(() -> LocalizationHelper.localizeFormatted("aroma1997core:gui.element.tank.fillDescr", this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity()));
    }

    private String getFluidName() {
        FluidStack stack = this.fluidTank.getFluid();
        if (stack == null || stack.amount <= 0) {
            return LocalizationHelper.localize("aroma1997core:gui.element.tank.empty");
        }
        return LocalizationHelper.localizeFormatted("aroma1997core:gui.element.tank.fluidDescr", stack.getLocalizedName());
    }

    @Override
    public void render(int x, int y, Gui gui, TextureManager textureManager) {
        FluidStack stack = this.fluidTank.getFluid();
        if (stack != null) {
            StaticTexture.TANK_BACKGROUND.render(x, y, gui, textureManager);
            textureManager.func_110577_a(TextureMap.field_110575_b);
            this.renderFluid(x, y, stack, this.fluidTank.getCapacity());
        } else {
            StaticTexture.TANK_BACKGROUND_GREY.render(x, y, gui, textureManager);
        }
        StaticTexture.TANK_OVERLAY.render(x, y, gui, textureManager);
    }

    private void renderFluid(int x, int y, FluidStack stack, int max) {
        TextureAtlasSprite sprite = RenderHelper.getAtlasSprite(stack.getFluid().getStill(stack));
        int height = this.location.getHeight() - 8;
        int width = this.location.getWidth() - 8;
        float heightToDraw = (float)height * (float)stack.amount / (float)max;
        float heightDrawn = 0.0f;
        x += 4;
        y += 4;
        while (heightToDraw > 0.0f) {
            float toDraw = Math.min(heightToDraw, (float)width);
            RenderHelper.draw(x, (float)(y + height) - heightDrawn - (float)width, width, width, sprite, 0.0f, 1.0f - toDraw / (float)width, 1.0f, 1.0f);
            heightToDraw -= toDraw;
            heightDrawn += toDraw;
        }
    }

    @Override
    public Object getContainedObject() {
        return this.fluidTank.getFluid();
    }
}

