/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.api;

import csokicraft.forge.modernmods.moderncraft.api.ModernMachineRegistry;
import csokicraft.forge.modernmods.moderncraft.api.capability.IModernEnergyCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ModernEnergyNet {
    protected List<IModernEnergyCapability> l = new ArrayList<IModernEnergyCapability>();
    protected double[] cap = new double[0];
    protected int netID = -1;

    public ModernEnergyNet() {
    }

    public ModernEnergyNet(IModernEnergyCapability tile) {
        this();
        this.add(tile);
    }

    public int getNetID() {
        return this.netID;
    }

    public void add(IModernEnergyCapability tile) {
        tile.setParent(this);
        this.l.add(tile);
        this.updateCap();
    }

    public void removeTile(IModernEnergyCapability tile) {
        this.l.remove(tile);
        tile.setParent(null);
        if (this.l.isEmpty()) {
            this.removeNet();
        } else {
            this.updateCap();
        }
    }

    public void removeNet() {
        this.l.clear();
        this.l = null;
        this.cap = null;
        ModernMachineRegistry.inst.unregisterNet(this.netID);
        this.netID = -1;
    }

    private void updateCap() {
        this.cap = new double[this.l.size()];
        for (int i = 0; i < this.cap.length; ++i) {
            IModernEnergyCapability enCap = this.l.get(i);
            if (!enCap.canProvideEnergy()) continue;
            this.cap[i] = enCap.addEnergy(enCap.getEnergyCapacity(), false);
        }
    }

    public void mergeWith(ModernEnergyNet net) {
        if (net == null || net == this) {
            return;
        }
        for (IModernEnergyCapability enCap : net.l) {
            enCap.setParent(this);
            this.l.add(enCap);
        }
        this.updateCap();
        net.removeNet();
    }

    public void announceSurplus(double val, IModernEnergyCapability enCap) {
        double rm;
        val = enCap.removeEnergy(val, false);
        for (int id = 0; id < this.cap.length; ++id) {
            if (this.cap[id] <= 0.0) continue;
            IModernEnergyCapability dest = this.l.get(id);
            rm = dest.addEnergy(val, true);
            enCap.removeEnergy(rm, true);
            int n = id;
            this.cap[n] = this.cap[n] - rm;
            if ((val -= rm) != 0.0) continue;
            return;
        }
        for (IModernEnergyCapability dest : this.l) {
            if (!dest.canReceiveEnergy()) continue;
            rm = dest.addEnergy(val, true);
            enCap.removeEnergy(rm, true);
            if ((val -= rm) != 0.0) continue;
            return;
        }
    }

    public void announceCapacity(double val, IModernEnergyCapability enCap) {
        this.cap[this.l.lastIndexOf((Object)enCap)] = val = enCap.addEnergy(val, false);
    }

    public static ModernEnergyNet readFromNBT(NBTTagCompound nbt) {
        ModernEnergyNet net = new ModernEnergyNet();
        net.netID = nbt.func_74762_e("id");
        NBTTagList tes = nbt.func_150295_c("tiles", 0);
        for (int i = 0; i < tes.func_74745_c(); ++i) {
            net.add(ModernEnergyNet.fromNBT(tes.func_150305_b(i)));
        }
        return net;
    }

    public static NBTTagCompound writeToNBT(ModernEnergyNet net) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("id", net.netID);
        NBTTagList tes = new NBTTagList();
        for (IModernEnergyCapability tile : net.l) {
            tes.func_74742_a((NBTBase)ModernEnergyNet.toNBT(tile));
        }
        nbt.func_74782_a("tiles", (NBTBase)tes);
        return nbt;
    }

    private static IModernEnergyCapability fromNBT(NBTTagCompound nbt) {
        return null;
    }

    private static NBTTagCompound toNBT(IModernEnergyCapability tile) {
        NBTTagCompound tag = new NBTTagCompound();
        return tag;
    }
}

