/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.api;

import csokicraft.forge.modernmods.moderncraft.api.IModernMachineElectric;
import csokicraft.forge.modernmods.moderncraft.api.ModernEnergyNet;
import csokicraft.forge.modernmods.moderncraft.api.capability.IModernEnergyCapability;
import csokicraft.forge.modernmods.moderncraft.core.ModernCraftCore;
import csokicraft.util.IndexableTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;

public class ModernMachineRegistry {
    public static ModernMachineRegistry inst = new ModernMachineRegistry();
    public int lastID = -1;
    private IndexableTable<Class<? extends IModernMachineElectric>> classes = new IndexableTable();
    private IndexableTable<String> names = new IndexableTable();
    private IndexableTable<Integer> tiers = new IndexableTable();
    private IndexableTable<ModernEnergyNet> nets = new IndexableTable();
    private boolean init = false;
    private boolean finished = false;

    private ModernMachineRegistry() {
    }

    public void registerMachine(int id, Class<? extends IModernMachineElectric> c, String name, int tier) throws IllegalAccessError {
        if (this.finished) {
            throw new IllegalStateException("The machine registry has already finished loading, couldn't add " + c + " to slot " + id);
        }
        if (this.classes.get((Object)id) != null) {
            throw new IllegalAccessError("ModernMachine tile slot already in use: " + id + ", had " + ((Class)this.classes.get((Object)id)).getName() + ", new " + c.getName());
        }
        if (this.lastID < id) {
            this.lastID = id;
        }
        this.classes.put(Integer.valueOf(id), c);
        this.names.put(Integer.valueOf(id), (Object)name);
        if (tier > 0) {
            this.tiers.put(Integer.valueOf(id), (Object)tier);
        }
    }

    public void unregisterMachine(int id) {
        if (this.finished) {
            throw new IllegalStateException("The machine registry has already finished loading, couldn't remove " + this.classes.get((Object)id) + " from slot " + id);
        }
        if (this.classes.get((Object)id) == null) {
            throw new IllegalAccessError("The machine id " + id + " was not registered!");
        }
        this.classes.remove((Object)id);
        this.names.remove((Object)id);
        this.tiers.remove((Object)id);
    }

    public Class<? extends IModernMachineElectric> getMachine(int id) {
        if (!this.classes.containsKey((Object)id)) {
            ModernCraftCore.dbgLog.severe("No machine exists with id " + id);
            return null;
        }
        return (Class)this.classes.get((Object)id);
    }

    public int idOf(Class<? extends IModernMachineElectric> c) {
        if (!this.classes.containsValue(c)) {
            throw new IllegalAccessError("The machine class " + c.getName() + " was not registered!");
        }
        return this.classes.lastIndexOf(c);
    }

    public int idOf(String name) {
        if (!this.names.containsValue((Object)name)) {
            throw new IllegalAccessError("The machine name " + name + " was not registered!");
        }
        return this.names.lastIndexOf((Object)name);
    }

    public Collection<Integer> getRegisteredIds() {
        return this.classes.keySet();
    }

    public int getRegistrySize() {
        return this.classes.size();
    }

    public String getMachineName(int id) {
        return (String)this.names.get((Object)id);
    }

    public int getMachineTier(int id) {
        if (!this.tiers.containsKey((Object)id)) {
            return -1;
        }
        return (Integer)this.tiers.get((Object)id);
    }

    public void onMachineRegisterFinish() {
        if (this.finished) {
            throw new IllegalStateException("The machine registry has already finished loading!");
        }
        this.finished = true;
    }

    public File getSaveDir() {
        File f = new File(DimensionManager.getCurrentSaveRootDirectory(), "ModernCraft");
        if (!f.exists()) {
            f.mkdir();
        }
        return f;
    }

    public void onStop() throws IOException {
        this.saveNets();
        this.nets = null;
    }

    protected void saveNets() throws IOException {
        NBTTagList lst = new NBTTagList();
        for (ModernEnergyNet net : this.nets.values()) {
            lst.func_74742_a((NBTBase)ModernEnergyNet.writeToNBT(net));
        }
        NBTTagCompound wrapper = new NBTTagCompound();
        wrapper.func_74782_a("nets", (NBTBase)lst);
        File f = new File(this.getSaveDir(), "registry.dat");
        if (!f.exists()) {
            f.createNewFile();
        }
        CompressedStreamTools.func_74799_a((NBTTagCompound)wrapper, (OutputStream)new FileOutputStream(f));
    }

    public void onStart() throws IOException {
        this.loadNets();
    }

    protected void loadNets() throws IOException {
        this.nets = new IndexableTable();
        File f = new File(this.getSaveDir(), "registry.dat");
        if (!f.exists()) {
            f.createNewFile();
        }
        if (f.length() == 0L) {
            return;
        }
        NBTTagCompound wrapper = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(f));
        NBTTagList lst = (NBTTagList)wrapper.func_74781_a("nets");
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound nbt = lst.func_150305_b(i);
            ModernEnergyNet net = ModernEnergyNet.readFromNBT(nbt);
            this.registerNet(net, net.getNetID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerNet(ModernEnergyNet net) throws IllegalAccessError {
        int lastId;
        if (net.netID != -1) {
            this.registerNet(net, net.netID);
            return net.netID;
        }
        IndexableTable<ModernEnergyNet> indexableTable = this.nets;
        synchronized (indexableTable) {
            lastId = this.nets.lastIndexOf(null);
            if (lastId == -1) {
                lastId = this.nets.size();
            }
            this.registerNet(net, lastId);
        }
        return lastId;
    }

    private void registerNet(ModernEnergyNet net, int id) throws IllegalAccessError {
        if (this.nets.get((Object)id) != null) {
            throw new IllegalAccessError("There was an EnergyNet at " + id + ", " + this.nets.get((Object)id) + ", while adding" + net);
        }
        this.nets.put(Integer.valueOf(id), (Object)net);
        net.netID = id;
    }

    public void unregisterNet(int id) {
        this.nets.remove((Object)id);
    }

    public ModernEnergyNet getNet(int id) {
        return (ModernEnergyNet)this.nets.get((Object)id);
    }

    public ModernEnergyNet getNetFor(IModernEnergyCapability enCap) {
        if (enCap.getParent() == null) {
            ModernEnergyNet net = new ModernEnergyNet(enCap);
            this.registerNet(net);
        }
        return enCap.getParent();
    }
}

