/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.api.capability;

import csokicraft.forge.modernmods.moderncraft.api.ModernEnergyNet;
import csokicraft.forge.modernmods.moderncraft.api.capability.IModernEnergyCapability;

public class ModernEnergyCapabilityImpl
implements IModernEnergyCapability {
    protected ModernEnergyNet net;
    protected double stored = 0.0;
    protected double capacity;

    public ModernEnergyCapabilityImpl(int cap) {
        this.capacity = cap;
    }

    @Override
    public ModernEnergyNet getParent() {
        return this.net;
    }

    @Override
    public void setParent(ModernEnergyNet to) {
        this.net = to;
    }

    @Override
    public double addEnergy(double val, boolean doAdd) {
        if (!doAdd) {
            return Math.min(this.capacity - this.stored, val);
        }
        if (this.stored + val <= this.capacity) {
            this.stored += val;
            return val;
        }
        double i = this.capacity - this.stored;
        this.stored = this.capacity;
        return i;
    }

    @Override
    public double removeEnergy(double val, boolean doRemove) {
        if (!doRemove) {
            return Math.min(this.stored, val);
        }
        if (this.stored - val >= 0.0) {
            this.stored -= val;
            return val;
        }
        double i = this.stored;
        this.stored = 0.0;
        return i;
    }

    @Override
    public double getEnergy() {
        return this.stored;
    }

    @Override
    public double getEnergyCapacity() {
        return this.capacity;
    }

    @Override
    public void setEnergy(double energy) {
        this.stored = energy;
    }

    @Override
    public boolean canReceiveEnergy() {
        return this.stored < this.capacity;
    }

    @Override
    public boolean canProvideEnergy() {
        return this.stored > 0.0;
    }

    @Override
    public boolean canConnect(IModernEnergyCapability to) {
        return true;
    }
}

