/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.core;

import csokicraft.forge.modernmods.moderncraft.api.IModernGuiProvider;
import csokicraft.forge.modernmods.moderncraft.api.IModernWrenchable;
import csokicraft.forge.modernmods.moderncraft.api.capability.ModernCapabilities;
import csokicraft.forge.modernmods.moderncraft.core.ModernCraftCore;
import csokicraft.forge.modernmods.moderncraft.core.item.ItemDebugger;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.cyclops.commoncapabilities.api.capability.wrench.IWrench;
import org.cyclops.commoncapabilities.api.capability.wrench.WrenchTarget;
import org.cyclops.commoncapabilities.capability.wrench.WrenchConfig;

public abstract class BlockAbstractModernMachine
extends Block {
    public BlockAbstractModernMachine(Material materialIn) {
        super(materialIn);
    }

    public boolean hasTileEntity(IBlockState s) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World w, BlockPos pos, IBlockState state, EntityPlayer p, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = w.func_175625_s(pos);
        ItemStack heldItem = p.func_184586_b(hand);
        if (te == null) {
            ModernCraftCore.dbgLog.log(Level.WARNING, (w.field_72995_K ? "Client>" : "Server>") + "Tile at " + pos + " was null!");
            return false;
        }
        if (w.field_72995_K) {
            return true;
        }
        if (heldItem != null) {
            if (heldItem.func_77973_b() == ModernCraftCore.debugger) {
                ItemDebugger.onDebug(p, side, te);
                return true;
            }
            IModernWrenchable imw = (IModernWrenchable)te.getCapability(ModernCapabilities.WRENCHABLE, side);
            if (imw != null) {
                if (Loader.isModLoaded((String)"CommonCapabilities") && heldItem.hasCapability(WrenchConfig.CAPABILITY, null)) {
                    WrenchTarget tgt;
                    IWrench iwr = (IWrench)heldItem.getCapability(WrenchConfig.CAPABILITY, null);
                    if (iwr.canUse(p, tgt = WrenchTarget.forBlock((World)w, (BlockPos)pos, (EnumFacing)side))) {
                        iwr.beforeUse(p, tgt);
                        if (imw.onWrenchClicked(p, heldItem, IModernWrenchable.MouseButton.RIGHT_CLICK, p.func_70093_af(), hand)) {
                            iwr.afterUse(p, tgt);
                            return true;
                        }
                    }
                } else if (heldItem.func_77973_b() == ModernCraftCore.wrench && imw.onWrenchClicked(p, heldItem, IModernWrenchable.MouseButton.RIGHT_CLICK, p.func_70093_af(), hand)) {
                    return true;
                }
            }
        }
        if (te instanceof IModernGuiProvider) {
            IModernGuiProvider guiprov = (IModernGuiProvider)te;
            int guiID = guiprov.getGuiID();
            p.openGui((Object)ModernCraftCore.inst, guiID, w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return true;
    }
}

