/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.core;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class CommonProxy
implements IGuiHandler {
    protected static Map<Integer, Class<? extends Container>> containerIDs = new HashMap<Integer, Class<? extends Container>>();
    protected static Map<Integer, Class<? extends Gui>> guiIDs = new HashMap<Integer, Class<? extends Gui>>();

    public static void registerGuiProvider(int provID, Class<? extends Container> container, Class<? extends Gui> gui) {
        if (containerIDs.containsKey(provID) || guiIDs.containsKey(provID)) {
            throw new IllegalAccessError("There was already a GUI registered with " + provID + "!");
        }
        containerIDs.put(provID, container);
        guiIDs.put(provID, gui);
    }

    public static Class<? extends Container> getContainerClass(int id) {
        return containerIDs.get(id);
    }

    public static Class<? extends Gui> getGuiClass(int id) {
        return guiIDs.get(id);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        Class<? extends Container> containerClass = CommonProxy.getContainerClass(ID);
        if (containerClass == null) {
            return null;
        }
        try {
            return containerClass.getConstructor(TileEntity.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get Container at ID " + ID + ", because:" + e.getMessage(), e);
        }
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        Class<? extends Gui> guiClass = CommonProxy.getGuiClass(ID);
        if (guiClass == null) {
            return null;
        }
        try {
            return guiClass.getConstructor(TileEntity.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get Gui at ID " + ID + ", because:" + e.getMessage(), e);
        }
    }

    public void registerModels() {
    }

    public void postInit() {
    }
}

