/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.core;

import csokicraft.forge.modernmods.moderncraft.api.ModernMachineRegisterEvent;
import csokicraft.forge.modernmods.moderncraft.api.ModernMachineRegistry;
import csokicraft.forge.modernmods.moderncraft.api.capability.ModernCapabilities;
import csokicraft.forge.modernmods.moderncraft.core.BlockModernElectric;
import csokicraft.forge.modernmods.moderncraft.core.CommonProxy;
import csokicraft.forge.modernmods.moderncraft.core.item.ItemBlockMachine;
import csokicraft.forge.modernmods.moderncraft.core.item.ItemDebugger;
import csokicraft.forge.modernmods.moderncraft.core.item.ItemModernMaterial;
import csokicraft.forge.modernmods.moderncraft.core.item.ItemWrench;
import csokicraft.forge.modernmods.moderncraft.core.item.ModernItems;
import csokicraft.forge.modernmods.moderncraft.core.machine.MachineWire;
import csokicraft.forge.modernmods.moderncraft.core.network.HandlerUpdateMachine;
import csokicraft.forge.modernmods.moderncraft.core.network.HandlerUpdateMachineDummy;
import csokicraft.forge.modernmods.moderncraft.core.network.PacketTileUpdateMachine;
import csokicraft.forge.modernmods.moderncraft.core.render.MachineRendererRegistry;
import csokicraft.forge.modernmods.moderncraft.core.tile.TileEntityModernElectric;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="moderncraftcore", version="2.0.2", dependencies="required-after:csokicraftutil;after:commoncapabilities", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ModernCraftCore {
    protected static List<IForgeRegistryEntry<?>> toRegister = new ArrayList();
    public static final String MODID = "moderncraftcore";
    public static final String VERSION = "2.0.2";
    @Mod.Instance
    public static ModernCraftCore inst;
    public static Logger dbgLog;
    public static SimpleNetworkWrapper netHndl;
    @SidedProxy(serverSide="csokicraft.forge.modernmods.moderncraft.core.CommonProxy", clientSide="csokicraft.forge.modernmods.moderncraft.core.ClientProxy")
    public static CommonProxy proxy;
    public static MachineRendererRegistry renderer;
    public static CreativeTabs tabMachines;
    public static Block blockMachine;
    public static Item itemMachine;
    public static Item wrench;
    public static Item debugger;
    public static Item itemIngot;
    public static Item itemDust;
    public static Item itemNugget;
    public static Item itemComponent;

    protected static Item nameItem(Item i, String name) {
        String fullName = "modern" + name;
        toRegister.add((IForgeRegistryEntry<?>)((Item)i.func_77655_b(fullName).setRegistryName(fullName)).func_77637_a(tabMachines));
        return i;
    }

    protected static Block nameBlock(Block b, String name) {
        String fullName = "modern" + name;
        toRegister.add((IForgeRegistryEntry<?>)((Block)b.func_149663_c(fullName).setRegistryName(fullName)).func_149647_a(tabMachines));
        return b;
    }

    protected static ItemBlock nameItemBlock(ItemBlock i, String name) {
        String fullName = "modern" + name;
        toRegister.add(i.setRegistryName(fullName));
        return i;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) throws IllegalAccessError, IOException {
        netHndl = new SimpleNetworkWrapper("moderncraftcore:enet");
        if (evt.getSide().isClient()) {
            netHndl.registerMessage(HandlerUpdateMachine.class, PacketTileUpdateMachine.class, 10, Side.CLIENT);
        } else {
            netHndl.registerMessage(HandlerUpdateMachineDummy.class, PacketTileUpdateMachine.class, 10, Side.CLIENT);
        }
        ModernCapabilities.init();
        GameRegistry.registerTileEntity(TileEntityModernElectric.class, (String)"moderncraftcore:tile");
        ModernItems.initItems();
        MinecraftForge.EVENT_BUS.post((Event)new ModernMachineRegisterEvent());
        ModernMachineRegistry.inst.onMachineRegisterFinish();
        BlockModernElectric.propMachine = PropertyInteger.func_177719_a((String)"machine", (int)0, (int)ModernMachineRegistry.inst.lastID);
        blockMachine = ModernCraftCore.nameBlock(new BlockModernElectric(Material.field_151573_f), "machine");
        itemMachine = ModernCraftCore.nameItemBlock(new ItemBlockMachine(), "machine");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)inst, (IGuiHandler)proxy);
        proxy.registerModels();
    }

    @SubscribeEvent
    public static void addRecipes(RegistryEvent.Register<IRecipe> e) {
        IForgeRegistry reg = e.getRegistry();
        GameRegistry.addSmelting((Block)Blocks.field_150467_bQ, (ItemStack)ModernCraftCore.copyWithCount(ModernItems.ingotSteel, 2), (float)1.0f);
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 4), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotCopper", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "copper_wire")));
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 6), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotIron", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "iron_wire")));
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 8), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotAluminum", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "alu_wire")));
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 8), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotAluminium", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "al_wire")));
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 10), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotSilver", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "silver_wire")));
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 12), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotGold", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "gold_wire")));
        reg.register(new ShapedOreRecipe(new ResourceLocation(MODID, "modern_wire"), ItemBlockMachine.forMachine("wire", 14), new Object[]{"www", "iii", "www", Character.valueOf('i'), "ingotElectrum", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation(MODID, "ag-au_wire")));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void start(FMLServerAboutToStartEvent e) throws IOException {
        ModernMachineRegistry.inst.onStart();
    }

    @Mod.EventHandler
    public void stop(FMLServerStoppingEvent e) throws IOException {
        ModernMachineRegistry.inst.onStop();
    }

    private static ItemStack copyWithCount(ItemStack stack, int count) {
        ItemStack is = stack.func_77946_l();
        is.func_190920_e(count);
        return is;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        LinkedList processed = new LinkedList();
        for (IForgeRegistryEntry<?> e : toRegister) {
            if (!(e instanceof Item)) continue;
            reg.register((IForgeRegistryEntry)((Item)e));
            processed.offer(e);
        }
        toRegister.removeAll(processed);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry reg = event.getRegistry();
        LinkedList processed = new LinkedList();
        for (IForgeRegistryEntry<?> e : toRegister) {
            if (!(e instanceof Block)) continue;
            reg.register((IForgeRegistryEntry)((Block)e));
            processed.offer(e);
        }
        toRegister.removeAll(processed);
    }

    @SubscribeEvent
    public static void registerMachines(ModernMachineRegisterEvent evt) {
        ModernMachineRegistry.inst.registerMachine(31, MachineWire.class, "wire", -1);
    }

    @SubscribeEvent
    public static void registerModel(ModelRegistryEvent evt) {
        ModelResourceLocation mdlLoc = new ModelResourceLocation("moderncraftcore:modernwire");
        ModelLoader.setCustomModelResourceLocation((Item)itemMachine, (int)31, (ModelResourceLocation)mdlLoc);
    }

    static {
        dbgLog = Logger.getLogger("[ModernCraft|Core/Debug]");
        renderer = new MachineRendererRegistry();
        tabMachines = new CreativeTabs("ModernCraft-Machines"){

            public ItemStack func_78016_d() {
                return new ItemStack(wrench);
            }
        };
        wrench = ModernCraftCore.nameItem(new ItemWrench().func_77625_d(1), "wrench");
        debugger = ModernCraftCore.nameItem(new ItemDebugger().func_77625_d(1), "debugger");
        itemIngot = ModernCraftCore.nameItem(new ItemModernMaterial(12), "ingot");
        itemDust = ModernCraftCore.nameItem(new ItemModernMaterial(15), "dust");
        itemNugget = ModernCraftCore.nameItem(new ItemModernMaterial(13), "nugget");
        itemComponent = ModernCraftCore.nameItem(new ItemModernMaterial(10), "component");
    }
}

