/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.core.item;

import csokicraft.forge.modernmods.moderncraft.api.IModernMachineElectric;
import csokicraft.forge.modernmods.moderncraft.api.ModernMachineRegistry;
import csokicraft.forge.modernmods.moderncraft.core.BlockModernElectric;
import csokicraft.forge.modernmods.moderncraft.core.ModernCraftCore;
import csokicraft.forge.modernmods.moderncraft.core.machine.MachineModernElectric;
import csokicraft.forge.modernmods.moderncraft.core.tile.TileEntityModernElectric;
import csokicraft.util.CollectionUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBlockMachine
extends ItemBlock {
    public ItemBlockMachine() {
        super(ModernCraftCore.blockMachine);
    }

    public static ItemStack forMachine(String name, int qty) {
        return new ItemStack(ModernCraftCore.itemMachine, qty, ModernMachineRegistry.inst.idOf(name));
    }

    public static ItemStack forMachine(String name) {
        return ItemBlockMachine.forMachine(name, 1);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World w, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int dmg = playerIn.func_184586_b(hand).func_77952_i();
        BlockPos newPos = pos.func_177972_a(facing);
        MachineModernElectric machine = (MachineModernElectric)ItemBlockMachine.createMachine(dmg);
        if (!w.func_180495_p(newPos).func_177230_c().func_176200_f((IBlockAccess)w, newPos) || machine == null) {
            return EnumActionResult.FAIL;
        }
        if (!w.func_175656_a(newPos, ModernCraftCore.blockMachine.func_176223_P().func_177226_a((IProperty)BlockModernElectric.propMachine, (Comparable)Integer.valueOf(dmg)))) {
            return EnumActionResult.FAIL;
        }
        TileEntityModernElectric te = (TileEntityModernElectric)w.func_175625_s(newPos);
        te.setMachine(machine);
        return EnumActionResult.SUCCESS;
    }

    public String func_77667_c(ItemStack is) {
        return ItemBlockMachine.getMachineName(is.func_77952_i());
    }

    public static String getMachineName(int id) {
        int tier = ModernMachineRegistry.inst.getMachineTier(id);
        return "machine_" + ModernMachineRegistry.inst.getMachineName(id) + (tier > 0 ? ".tier" + tier : "");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> l) {
        if (CollectionUtils.contains((Object[])this.getCreativeTabs(), (Object)tab)) {
            for (int x : ModernMachineRegistry.inst.getRegisteredIds()) {
                l.add((Object)new ItemStack((Item)this, 1, x));
            }
        }
    }

    public static <T extends IModernMachineElectric> T createMachine(int id) {
        Class<? extends IModernMachineElectric> cls = ModernMachineRegistry.inst.getMachine(id);
        if (cls == null) {
            return null;
        }
        try {
            return (T)cls.newInstance();
        }
        catch (Exception e) {
            ModernCraftCore.dbgLog.severe("Couldn't instantiate machine ID " + id + " (" + cls.getName() + "), because: " + e.getClass() + " : " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

