/*
 * Decompiled with CFR 0.152.
 */
package csokicraft.forge.modernmods.moderncraft.core.machine;

import csokicraft.forge.modernmods.moderncraft.api.IModernMachineElectric;
import csokicraft.forge.modernmods.moderncraft.api.ModernEnergyNet;
import csokicraft.forge.modernmods.moderncraft.api.ModernMachineRegistry;
import csokicraft.forge.modernmods.moderncraft.api.capability.IModernEnergyCapability;
import csokicraft.forge.modernmods.moderncraft.api.capability.ModernCapabilities;
import csokicraft.forge.modernmods.moderncraft.core.ModernCraftCore;
import csokicraft.forge.modernmods.moderncraft.core.network.PacketTileUpdateMachine;
import csokicraft.forge.modernmods.moderncraft.core.tile.TileEntityModernElectric;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector4d;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class MachineModernElectric
implements IModernMachineElectric {
    protected IModernEnergyCapability energy;
    protected Map<Object, EnumFacing> neighbors = new HashMap<Object, EnumFacing>();
    protected boolean schedUpdConn;
    protected TileEntityModernElectric container;

    public MachineModernElectric(IModernEnergyCapability cap) {
        this.energy = cap;
        ModernMachineRegistry.inst.getNetFor(this.energy);
    }

    public MachineModernElectric setContainer(TileEntityModernElectric te) {
        this.container = te;
        return this;
    }

    @Override
    public void scheduleUpdateConnections() {
        this.schedUpdConn = true;
    }

    protected abstract boolean isActiveProvider();

    public void func_73660_a() {
        if (this.container.func_145831_w().field_72995_K) {
            this.updateClient();
        } else {
            this.updateServer();
        }
    }

    protected void updateServer() {
        if (this.schedUpdConn) {
            this.updateConnections();
        }
        if (this.isActiveProvider()) {
            this.energy.getParent().announceSurplus(this.energy.getEnergy(), this.energy);
        } else {
            this.energy.getParent().announceCapacity(this.energy.getEnergyCapacity() - this.energy.getEnergy(), this.energy);
        }
        ModernCraftCore.netHndl.sendToDimension((IMessage)new PacketTileUpdateMachine(this.container), this.container.func_145831_w().field_73011_w.getDimension());
    }

    protected void updateClient() {
    }

    @Override
    public ModernEnergyNet getParent() {
        return this.energy.getParent();
    }

    @Override
    public IModernMachineElectric setParent(ModernEnergyNet parent) {
        this.energy.setParent(parent);
        this.scheduleUpdateConnections();
        return this;
    }

    @Override
    public void invalidate() {
        this.energy.getParent().removeTile(this.energy);
    }

    @Override
    public void onLoad() {
        this.scheduleUpdateConnections();
    }

    @Override
    public Vector4d getTilePos() {
        return new Vector4d((double)this.container.func_174877_v().func_177958_n(), (double)this.container.func_174877_v().func_177956_o(), (double)this.container.func_174877_v().func_177952_p(), (double)this.container.func_145831_w().field_73011_w.getDimension());
    }

    @Override
    public double addEnergy(EnumFacing from, double val, boolean doAdd) {
        return this.energy.addEnergy(val, doAdd);
    }

    @Override
    public double removeEnergy(EnumFacing from, double val, boolean doRemove) {
        return this.energy.removeEnergy(val, doRemove);
    }

    @Override
    public double getEnergy(EnumFacing from) {
        return this.energy.getEnergy();
    }

    @Override
    public double getEnergyCapacity(EnumFacing from) {
        return this.energy.getEnergyCapacity();
    }

    @Override
    public Map<Object, EnumFacing> getConnections() {
        return this.neighbors;
    }

    @Override
    public boolean canConnect(EnumFacing dir, Object obj) {
        ICapabilityProvider prov;
        if (obj instanceof ICapabilityProvider && (prov = (ICapabilityProvider)obj).hasCapability(ModernCapabilities.ENERGY, dir)) {
            return ((IModernEnergyCapability)prov.getCapability(ModernCapabilities.ENERGY, dir)).canConnect(this.energy);
        }
        return false;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing dir) {
        return !this.isActiveProvider();
    }

    @Override
    public boolean canProvideEnergy(EnumFacing dir) {
        return this.isActiveProvider();
    }

    @Override
    public void updateConnections() {
        if (!this.container.func_145831_w().field_72995_K) {
            for (int n = 0; n < 6; ++n) {
                EnumFacing dir = EnumFacing.func_82600_a((int)n);
                BlockPos adj = this.container.func_174877_v().func_177972_a(dir);
                TileEntity te = this.container.func_145831_w().func_175625_s(adj);
                if (this.isValidTE(te) && this.canConnect(dir, te)) {
                    this.addConnection(te, dir);
                    continue;
                }
                if (!this.neighbors.containsValue(dir)) continue;
                this.neighbors.remove(this.getNeighbor(dir));
            }
        }
        this.schedUpdConn = false;
    }

    private boolean isValidTE(TileEntity te) {
        return te != null && !te.func_145837_r();
    }

    private void addConnection(TileEntity te, EnumFacing dir) {
        IModernEnergyCapability enCap = (IModernEnergyCapability)te.getCapability(ModernCapabilities.ENERGY, dir.func_176734_d());
        if (!enCap.canConnect(this.energy)) {
            return;
        }
        this.neighbors.put(te, dir);
        if (this.energy.getParent() != null) {
            this.energy.getParent().mergeWith(enCap.getParent());
        } else {
            System.err.println("Fatal: ticking machine with null parent @ " + this.container.func_174877_v());
            this.energy.setParent(enCap.getParent());
        }
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    @Override
    public Object getNeighbor(EnumFacing arg0) {
        if (!this.neighbors.containsValue(arg0)) {
            return null;
        }
        for (Map.Entry<Object, EnumFacing> e : this.neighbors.entrySet()) {
            if (!e.getValue().equals((Object)arg0)) continue;
            return e.getKey();
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == ModernCapabilities.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == ModernCapabilities.ENERGY) {
            return (T)this.energy;
        }
        return null;
    }

    @Override
    public void onChunkUnload() {
    }
}

