/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import com.google.common.base.Predicate;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.BlockMisc;
import de.ellpeck.actuallyadditions.mod.blocks.BlockWildPlant;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheWildPlants;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntListValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.gen.WorldGenLushCaves;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.ArrayUtils;

public class OreGen
implements IWorldGenerator {
    public static final int QUARTZ_MIN = 0;
    public static final int QUARTZ_MAX = 45;
    private final WorldGenLushCaves caveGen = new WorldGenLushCaves();

    public OreGen() {
        ActuallyAdditions.LOGGER.info("Registering World Generator...");
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)10000);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimension = world.field_73011_w.getDimension();
        if (dimension != -1 && dimension != 1 && world.func_175624_G() != WorldType.field_77138_c && this.canGen(world.field_73011_w.getDimension())) {
            this.generateDefault(world, random, chunkX, chunkZ);
        }
    }

    private boolean canGen(int dimension) {
        boolean inList = ArrayUtils.contains((int[])ConfigIntListValues.ORE_GEN_DIMENSION_BLACKLIST.getValue(), (int)dimension);
        return inList && ConfigBoolValues.ORE_GEN_DIM_WHITELIST.isEnabled() || !inList && !ConfigBoolValues.ORE_GEN_DIM_WHITELIST.isEnabled();
    }

    private void generateDefault(World world, Random random, int x, int z) {
        if (ConfigBoolValues.GENERATE_QUARTZ.isEnabled()) {
            this.addOreSpawn(InitBlocks.blockMisc.func_176223_P().func_177226_a(BlockMisc.TYPE, (Comparable)((Object)TheMiscBlocks.ORE_QUARTZ)), Blocks.field_150348_b, world, random, x * 16, z * 16, MathHelper.func_76136_a((Random)random, (int)5, (int)8), 10, 0, 45);
        }
        if (ConfigBoolValues.GEN_LUSH_CAVES.isEnabled()) {
            int randConst = -1768102243;
            Random chunkRand = new Random((long)randConst ^ world.func_72905_C() ^ (long)(x * 29 + z * 31));
            StructureBoundingBox box = new StructureBoundingBox(x * 16 + 8, 0, z * 16 + 8, x * 16 + 8 + 15, 255, z * 16 + 8 + 15);
            if (chunkRand.nextInt(ConfigIntValues.LUSH_CAVE_CHANCE.getValue()) <= 0) {
                BlockPos randPos = world.func_175672_r(new BlockPos(x * 16 + chunkRand.nextInt(16) + 8, 0, z * 16 + chunkRand.nextInt(16) + 8));
                BlockPos pos = randPos.func_177979_c(MathHelper.func_76136_a((Random)chunkRand, (int)15, (int)(randPos.func_177956_o() - 15)));
                this.caveGen.generate(world, chunkRand, pos, box);
            }
        }
    }

    public void addOreSpawn(IBlockState state, Block blockIn, World world, Random random, int blockXPos, int blockZPos, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            new WorldGenMinable(state, maxVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)blockIn)).func_180709_b(world, random, new BlockPos(posX, posY, posZ));
        }
    }

    @SubscribeEvent
    public void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DEFAULT) {
            if (event.getType() == DecorateBiomeEvent.Decorate.EventType.FLOWERS && !ArrayUtils.contains((int[])ConfigIntListValues.PLANT_DIMENSION_BLACKLIST.getValue(), (int)event.getWorld().field_73011_w.getDimension())) {
                this.generateRice((DecorateBiomeEvent)event);
                IBlockState plantDefault = InitBlocks.blockWildPlant.func_176223_P();
                this.genPlantNormally(plantDefault.func_177226_a(BlockWildPlant.TYPE, (Comparable)((Object)TheWildPlants.CANOLA)), ConfigIntValues.CANOLA_AMOUNT.getValue(), ConfigBoolValues.DO_CANOLA_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(plantDefault.func_177226_a(BlockWildPlant.TYPE, (Comparable)((Object)TheWildPlants.FLAX)), ConfigIntValues.FLAX_AMOUNT.getValue(), ConfigBoolValues.DO_FLAX_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(plantDefault.func_177226_a(BlockWildPlant.TYPE, (Comparable)((Object)TheWildPlants.COFFEE)), ConfigIntValues.COFFEE_AMOUNT.getValue(), ConfigBoolValues.DO_COFFEE_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
                this.genPlantNormally(InitBlocks.blockBlackLotus.func_176223_P(), ConfigIntValues.BLACK_LOTUS_AMOUNT.getValue(), ConfigBoolValues.DO_LOTUS_GEN.isEnabled(), Material.field_151577_b, (DecorateBiomeEvent)event);
            }
            if (event.getType() == DecorateBiomeEvent.Decorate.EventType.LILYPAD && ConfigBoolValues.DO_TREASURE_CHEST_GEN.isEnabled() && event.getRand().nextInt(40) == 0) {
                BlockPos randomPos = event.getChunkPos().func_180331_a(event.getRand().nextInt(16) + 8, 0, event.getRand().nextInt(16) + 8);
                randomPos = event.getWorld().func_175672_r(randomPos);
                if (event.getWorld().func_180494_b(randomPos) instanceof BiomeOcean && randomPos.func_177956_o() >= 25 && randomPos.func_177956_o() <= 45 && event.getWorld().func_180495_p(randomPos).func_185904_a() == Material.field_151586_h && event.getWorld().func_180495_p(randomPos.func_177977_b()).func_185904_a().func_76220_a()) {
                    event.getWorld().func_180501_a(randomPos, InitBlocks.blockTreasureChest.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)event.getRand().nextInt(4))), 2);
                }
            }
        }
    }

    private void generateRice(DecorateBiomeEvent event) {
        if (ConfigBoolValues.DO_RICE_GEN.isEnabled()) {
            for (int i = 0; i < ConfigIntValues.RICE_AMOUNT.getValue(); ++i) {
                if (event.getRand().nextInt(3) != 0) continue;
                BlockPos randomPos = event.getChunkPos().func_180331_a(event.getRand().nextInt(16) + 8, 0, event.getRand().nextInt(16) + 8);
                randomPos = event.getWorld().func_175672_r(randomPos);
                if (event.getWorld().func_180495_p(randomPos).func_185904_a() != Material.field_151586_h) continue;
                ArrayList<Material> blocksAroundBottom = WorldUtil.getMaterialsAround(event.getWorld(), randomPos);
                BlockPos posToGenAt = randomPos.func_177984_a();
                ArrayList<Material> blocksAroundTop = WorldUtil.getMaterialsAround(event.getWorld(), posToGenAt);
                if (!blocksAroundBottom.contains(Material.field_151577_b) && !blocksAroundBottom.contains(Material.field_151578_c) && !blocksAroundBottom.contains(Material.field_151576_e) && !blocksAroundBottom.contains(Material.field_151595_p) || blocksAroundTop.contains(Material.field_151586_h) || event.getWorld().func_180495_p(posToGenAt).func_185904_a() != Material.field_151579_a) continue;
                event.getWorld().func_180501_a(posToGenAt, InitBlocks.blockWildPlant.func_176223_P().func_177226_a(BlockWildPlant.TYPE, (Comparable)((Object)TheWildPlants.RICE)), 2);
            }
        }
    }

    private void genPlantNormally(IBlockState plant, int amount, boolean doIt, Material blockBelow, DecorateBiomeEvent event) {
        if (doIt) {
            for (int i = 0; i < amount; ++i) {
                if (event.getRand().nextInt(100) != 0) continue;
                BlockPos randomPos = event.getChunkPos().func_180331_a(event.getRand().nextInt(16) + 8, 0, event.getRand().nextInt(16) + 8);
                randomPos = event.getWorld().func_175672_r(randomPos);
                if (event.getWorld().func_180495_p(randomPos.func_177977_b()).func_185904_a() != blockBelow || !plant.func_177230_c().func_176196_c(event.getWorld(), randomPos) || !event.getWorld().func_175623_d(randomPos)) continue;
                event.getWorld().func_180501_a(randomPos, plant, 2);
            }
        }
    }
}

