/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.blocks.BlockMobSafe;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGrinder;
import com.brandon3055.draconicevolution.client.DEParticles;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class Grinder
extends BlockMobSafe
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public Grinder() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileGrinder tileGrinder = worldIn.func_175625_s(pos) instanceof TileGrinder ? (TileGrinder)worldIn.func_175625_s(pos) : null;
        return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(tileGrinder != null && tileGrinder.active.value));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return super.func_185496_a(state, source, pos);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        boolean b = super.rotateBlock(world, pos, axis);
        TileEntity tile = world.func_175625_s(pos);
        if (b && tile instanceof TileGrinder) {
            ((TileGrinder)tile).updateKillBox();
        }
        return b;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileGrinder();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileGrinder && world.field_72995_K) {
                AxisAlignedBB bb = ((TileGrinder)tile).getKillBoxForRender();
                for (double i = 0.0; i <= 7.0; i += 0.01) {
                    Vec3D minX = new Vec3D(bb.field_72340_a + i, bb.field_72338_b, bb.field_72339_c);
                    Vec3D minY = new Vec3D(bb.field_72340_a, bb.field_72338_b + i, bb.field_72339_c);
                    Vec3D minZ = new Vec3D(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c + i);
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)minX, (Vec3D)new Vec3D(), (int[])new int[]{0, 255, 255, 130});
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)minY, (Vec3D)new Vec3D(), (int[])new int[]{0, 255, 255, 130});
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)minZ, (Vec3D)new Vec3D(), (int[])new int[]{0, 255, 255, 130});
                    Vec3D maxX = new Vec3D(bb.field_72336_d - i, bb.field_72337_e, bb.field_72334_f);
                    Vec3D maxY = new Vec3D(bb.field_72336_d, bb.field_72337_e - i, bb.field_72334_f);
                    Vec3D maxZ = new Vec3D(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f - i);
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)maxX, (Vec3D)new Vec3D(), (int[])new int[]{0, 255, 255, 130});
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)maxY, (Vec3D)new Vec3D(), (int[])new int[]{0, 255, 255, 130});
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)maxZ, (Vec3D)new Vec3D(), (int[])new int[]{0, 255, 255, 130});
                }
            }
        } else if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)2, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileGrinder) {
            ((TileGrinder)tileEntity).updateKillBox();
            ((TileGrinder)tileEntity).powered = world.func_175640_z(pos);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileGrinder) {
            ((TileGrinder)tileEntity).updateKillBox();
        }
    }
}

