/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.armor;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IFOVModifierItem;
import com.brandon3055.brandonscore.lib.EnergyContainerWrapper;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.ModelWyvernArmor;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.items.armor.ICustomArmor;
import com.brandon3055.draconicevolution.items.tools.ToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WyvernArmor
extends ItemArmor
implements IConfigurableItem,
IUpgradableItem,
ICustomArmor,
IFOVModifierItem {
    private static ItemArmor.ArmorMaterial wyvernMaterial = EnumHelper.addArmorMaterial((String)"wyvernArmor", (String)"draconicevolution:wyvern_armor", (int)-1, (int[])new int[]{3, 6, 8, 3}, (int)15, (SoundEvent)SoundEvents.field_187716_o, (float)2.0f);
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model;

    public WyvernArmor(int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(wyvernMaterial, renderIndexIn, equipmentSlotIn);
        this.func_77656_e(-1);
    }

    public WyvernArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77656_e(-1);
    }

    public boolean func_77645_m() {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            this.modifyEnergy(stack, this.getCapacity(stack));
            subItems.add((Object)stack);
            ItemStack uberStack = new ItemStack((Item)this);
            for (String upgrade : this.getValidUpgrades(uberStack)) {
                UpgradeHelper.setUpgradeLevel(uberStack, upgrade, this.getMaxUpgradeLevel(uberStack, upgrade));
            }
            this.modifyEnergy(uberStack, this.getCapacity(uberStack));
            subItems.add((Object)uberStack);
        }
    }

    protected float getProtectionShare() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 0.15f;
            }
            case CHEST: {
                return 0.4f;
            }
            case LEGS: {
                return 0.3f;
            }
            case FEET: {
                return 0.15f;
            }
        }
        return 0.0f;
    }

    @Override
    public int getProfileCount(ItemStack stack) {
        return 3;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        int i;
        int u;
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            u = UpgradeHelper.getUpgradeLevel(stack, "moveSpeed");
            i = 100 + 100 * u + Math.max(u - 1, 0) * 50;
            registry.register(stack, new IntegerConfigField("armorSpeedModifier", 0, 0, i, "config.field.armorSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
            registry.register(stack, new BooleanConfigField("armorSpeedFOVWarp", false, "config.field.armorSpeedFOVWarp.description"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            u = UpgradeHelper.getUpgradeLevel(stack, "jumpBoost");
            i = 100 + 100 * u + Math.max(u - 1, 0) * 50;
            registry.register(stack, new IntegerConfigField("armorJumpModifier", 0, 0, i, "config.field.armorSpeedModifier.description", IItemConfigField.EnumControlType.SLIDER).setPrefix("+").setExtension("%"));
        }
        if (this.field_77881_a == EntityEquipmentSlot.FEET || this.field_77881_a == EntityEquipmentSlot.LEGS) {
            registry.register(stack, new BooleanConfigField("sprintBoost", false, "config.field.sprintBoost.description"));
        }
        return registry;
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("rfCap");
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            list.add("jumpBoost");
        }
        if (this.field_77881_a == EntityEquipmentSlot.LEGS) {
            list.add("moveSpeed");
        }
        list.add("shieldCap");
        list.add("shieldRec");
        return list;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        ToolBase.holdCTRLForUpgrades(tooltip, stack);
        InfoHelper.addEnergyInfo((ItemStack)stack, tooltip);
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (DEConfig.disable3DModels) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
        }
        if (this.model == null) {
            this.model = this.field_77881_a == EntityEquipmentSlot.HEAD ? new ModelWyvernArmor(0.5f, true, false, false, false) : (this.field_77881_a == EntityEquipmentSlot.CHEST ? new ModelWyvernArmor(1.5f, false, true, false, false) : (this.field_77881_a == EntityEquipmentSlot.LEGS ? new ModelWyvernArmor(1.5f, false, false, true, false) : new ModelWyvernArmor(1.0f, false, false, false, true)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
            this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
            this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
            boolean bl = this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_184218_aH();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_178720_f.field_78806_j = this.field_77881_a == EntityEquipmentSlot.HEAD;
        this.model.field_78115_e.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST || this.field_77881_a == EntityEquipmentSlot.LEGS;
        this.model.field_178724_i.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178723_h.field_78806_j = this.field_77881_a == EntityEquipmentSlot.CHEST;
        this.model.field_178722_k.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        this.model.field_178721_j.field_78806_j = this.field_77881_a == EntityEquipmentSlot.LEGS || this.field_77881_a == EntityEquipmentSlot.FEET;
        return this.model;
    }

    @Override
    public float getProtectionPoints(ItemStack stack) {
        int upgradeLevel = UpgradeHelper.getUpgradeLevel(stack, "shieldCap");
        float points = (float)ToolStats.WYVERN_BASE_SHIELD_CAPACITY * this.getProtectionShare() * (float)(upgradeLevel + 1);
        return points;
    }

    @Override
    public float getRecoveryRate(ItemStack stack) {
        return (float)ToolStats.WYVERN_SHIELD_RECOVERY * (1.0f + (float)UpgradeHelper.getUpgradeLevel(stack, "shieldRec"));
    }

    @Override
    public float getSpeedModifier(ItemStack stack, EntityPlayer player) {
        float modifier = (float)ToolConfigHelper.getIntegerField("armorSpeedModifier", stack) / 100.0f;
        if (ToolConfigHelper.getBooleanField("sprintBoost", stack) && !player.func_70051_ag()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Override
    public float getJumpModifier(ItemStack stack, EntityPlayer player) {
        float modifier = (float)ToolConfigHelper.getIntegerField("armorJumpModifier", stack) / 100.0f;
        if (ToolConfigHelper.getBooleanField("sprintBoost", stack) && !BrandonsCore.proxy.isSprintKeyDown()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    @Override
    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        return false;
    }

    @Override
    public float getFireResistance(ItemStack stack) {
        switch (this.field_77881_a) {
            case HEAD: {
                return 0.15f;
            }
            case CHEST: {
                return 0.4f;
            }
            case LEGS: {
                return 0.3f;
            }
            case FEET: {
                return 0.15f;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{false, false, false};
    }

    @Override
    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Override
    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        return 0.0f;
    }

    @Override
    public int getEnergyPerProtectionPoint() {
        return ToolStats.WYVERN_SHIELD_RECHARGE_COST;
    }

    protected int getCapacity(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        if (level == 0) {
            return ToolStats.WYVERN_BASE_CAPACITY;
        }
        return ToolStats.WYVERN_BASE_CAPACITY * (int)Math.pow(2.0, level + 1);
    }

    protected int getMaxReceive(ItemStack stack) {
        return ToolStats.WYVERN_MAX_RECIEVE;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int energyReceived = Math.min(this.getCapacity(container) - energy, Math.min(this.getMaxReceive(container), maxReceive));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(energy += energyReceived));
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    @Override
    public void modifyEnergy(ItemStack container, int modify) {
        int energy = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        if ((energy += modify) > this.getCapacity(container)) {
            energy = this.getCapacity(container);
        } else if (energy < 0) {
            energy = 0;
        }
        ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)energy);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerWrapper(stack);
    }

    public float getNewFOV(EntityPlayer player, ItemStack stack, float currentFOV, float originalFOV, EntityEquipmentSlot slot) {
        AttributeModifier modifier = player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(CustomArmorHandler.WALK_SPEED_UUID);
        if (slot == EntityEquipmentSlot.LEGS && modifier != null) {
            boolean fly = player.field_71075_bZ.field_75100_b;
            float speedModifier = (float)modifier.func_111164_d() / (player.func_70051_ag() ? (fly ? 1.35f : 1.5f) : (fly ? 1.8181818f : 2.0f));
            float newFov = currentFOV - speedModifier;
            if (!ToolConfigHelper.getBooleanField("armorSpeedFOVWarp", stack)) {
                newFov += speedModifier * 0.25f;
            }
            if (newFov < 1.0f && player.func_70660_b(MobEffects.field_76421_d) == null) {
                newFov = 1.0f;
            }
            return newFov;
        }
        return currentFOV;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }
}

