/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.crafttweaker;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import com.google.common.collect.ImmutableSet;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.buildcraft.AssemblyTable")
@ModOnly(value="buildcraftsilicon")
public class AssemblyTable {
    private static int ids;

    @ZenMethod
    public static void addRecipe(IItemStack output, int power, IIngredient[] ingredients) {
        AssemblyTable.addRecipe0("auto_" + ids++, output, power, ingredients);
    }

    @ZenMethod
    public static void addRecipe(String name, IItemStack output, int power, IIngredient[] ingredients) {
        AssemblyTable.addRecipe0("custom/" + name, output, power, ingredients);
    }

    private static void addRecipe0(String name, IItemStack output, int power, IIngredient[] ingredients) {
        CraftTweakerAPI.apply((IAction)new AddRecipeAction(name, output, power, ingredients));
    }

    @ZenMethod
    public static void removeByName(String name) {
        CraftTweakerAPI.apply((IAction)new RemoveRecipeByNameAction(new ResourceLocation(name)));
    }

    private static class RemoveRecipeByNameAction
    implements IAction {
        private final ResourceLocation name;

        RemoveRecipeByNameAction(ResourceLocation name) {
            this.name = name;
        }

        public void apply() {
            AssemblyRecipeRegistry.REGISTRY.remove(this.name);
        }

        public String describe() {
            return "Removing assembly table recipe " + this.name;
        }
    }

    private static class AddRecipeAction
    implements IAction {
        private final ItemStack output;
        private final ResourceLocation name;
        private final long requiredMj;
        private final ImmutableSet<IngredientStack> requiredStacks;

        public AddRecipeAction(String name, IItemStack output, int power, IIngredient[] ingredients) {
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            ImmutableSet.Builder stacks = ImmutableSet.builder();
            for (int i = 0; i < ingredients.length; ++i) {
                stacks.add((Object)new IngredientStack(CraftTweakerMC.getIngredient((IIngredient)ingredients[i])));
            }
            this.requiredStacks = stacks.build();
            this.requiredMj = (long)power * MjAPI.MJ;
            this.name = new ResourceLocation("crafttweaker", name);
        }

        public void apply() {
            AssemblyRecipeRegistry.REGISTRY.put(this.name, new AssemblyRecipeBasic(this.name, this.requiredMj, this.requiredStacks, this.output));
        }

        public String describe() {
            return "Adding assembly table recipe for " + this.output;
        }
    }
}

