/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.registry.EventBuildCraftReload;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuidePageRegistry;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.entry.IEntryLinkConsumer;
import buildcraft.lib.client.guide.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.entry.PageEntry;
import buildcraft.lib.client.guide.entry.PageValueType;
import buildcraft.lib.client.guide.loader.IPageLoader;
import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePageStandInRecipes;
import buildcraft.lib.client.guide.parts.contents.ContentsNode;
import buildcraft.lib.client.guide.parts.contents.ContentsNodeGui;
import buildcraft.lib.client.guide.parts.contents.GuidePageContents;
import buildcraft.lib.client.guide.parts.contents.IContentsNode;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.client.guide.parts.contents.PageLinkNormal;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingRecipes;
import buildcraft.lib.client.guide.ref.GuideGroupManager;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.guide.GuideBook;
import buildcraft.lib.guide.GuideBookRegistry;
import buildcraft.lib.guide.GuideContentsData;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.ProfilerUtil;
import buildcraft.lib.misc.search.ISuffixArray;
import buildcraft.lib.misc.search.SimpleSuffixArray;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Language;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;

public final class GuideManager
extends Enum<GuideManager>
implements IResourceManagerReloadListener {
    public static final /* enum */ GuideManager INSTANCE = new GuideManager();
    public static final String DEFAULT_LANG = "en_us";
    public static final Map<String, IPageLoader> PAGE_LOADERS;
    public static final GuideContentsData BOOK_ALL_DATA;
    public static final boolean DEBUG;
    private final List<PageEntry<?>> entries = new ArrayList();
    private final Map<ResourceLocation, GuidePageFactory> pages = new HashMap<ResourceLocation, GuidePageFactory>();
    private final Map<ItemStack, GuidePageFactory> generatedPages = new HashMap<ItemStack, GuidePageFactory>();
    public ISuffixArray<PageLink> quickSearcher;
    private final Set<PageLink> pageLinksAdded = new HashSet<PageLink>();
    private final Map<GuideBook, Map<TypeOrder, ContentsNode>> contents = new HashMap<GuideBook, Map<TypeOrder, ContentsNode>>();
    public final Set<Object> objectsAdded = new HashSet<Object>();
    private boolean isInReload = false;
    private static final /* synthetic */ GuideManager[] $VALUES;

    public static GuideManager[] values() {
        return (GuideManager[])$VALUES.clone();
    }

    public static GuideManager valueOf(String name) {
        return Enum.valueOf(GuideManager.class, name);
    }

    public void onRegistryReload(EventBuildCraftReload.FinishLoad event) {
        if (this.isInReload) {
            return;
        }
        if (event.manager.isLoadingAll()) {
            return;
        }
        if (event.reloadingRegistries.contains(GuideBookRegistry.INSTANCE)) {
            this.reload();
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.reload(resourceManager);
    }

    public void reload() {
        this.reload(Minecraft.func_71410_x().func_110442_L());
    }

    private void reload(IResourceManager resourceManager) {
        if (this.isInReload) {
            throw new IllegalStateException("Cannot reload while we are reloading!");
        }
        try {
            this.isInReload = true;
            this.reload0(resourceManager);
        }
        finally {
            this.isInReload = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reload0(IResourceManager resourceManager) {
        void var7_14;
        Profiler prof = new Profiler();
        prof.field_76327_a = true;
        prof.func_76320_a("root");
        prof.func_76320_a("reload");
        Stopwatch watch = Stopwatch.createStarted();
        GuideGroupManager.get("lols", "hi");
        prof.func_76320_a("book_registry");
        GuideBookRegistry.INSTANCE.reload();
        prof.func_76318_c("page_registry");
        GuidePageRegistry.INSTANCE.reload();
        prof.func_76318_c("setup");
        this.entries.clear();
        GuidePageRegistry manager = GuidePageRegistry.INSTANCE;
        HashMap domains = new HashMap();
        domains.put(null, new HashSet());
        for (GuideBook guideBook : GuideBookRegistry.INSTANCE.getAllEntries()) {
            domains.put(guideBook, new HashSet());
        }
        prof.func_76318_c("index_crafting");
        GuideCraftingRecipes.INSTANCE.generateIndices();
        prof.func_76318_c("add_pages");
        for (PageEntry pageEntry : manager.getAllEntries()) {
            ((Set)domains.get(null)).add(pageEntry.typeTags.domain);
            GuideBook book = GuideBookRegistry.INSTANCE.getBook(pageEntry.book.toString());
            Set domainSet = (Set)domains.get(book);
            if (domainSet != null && book != null) {
                domainSet.add(pageEntry.typeTags.domain);
            }
            this.entries.add(pageEntry);
        }
        prof.func_76318_c("generate_books");
        BOOK_ALL_DATA.generate((Set)domains.get(null));
        for (Map.Entry entry : domains.entrySet()) {
            if (entry.getKey() == null) continue;
            ((GuideBook)entry.getKey()).data.generate((Set)entry.getValue());
        }
        this.pages.clear();
        prof.func_76318_c("load_lang");
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (currentLanguage == null) {
            BCLog.logger.warn("Current language was null!");
            String string = DEFAULT_LANG;
        } else {
            String string = currentLanguage.func_135034_a();
        }
        this.loadLangInternal(resourceManager, DEFAULT_LANG, prof);
        if (!DEFAULT_LANG.equals(var7_14)) {
            this.loadLangInternal(resourceManager, (String)var7_14, prof);
        }
        prof.func_76318_c("contents_page");
        this.generateContentsPage(prof);
        prof.func_76319_b();
        watch.stop();
        long time = watch.elapsed(TimeUnit.MICROSECONDS);
        int p = this.entries.size();
        int a = this.pages.size();
        int e = p - a;
        prof.func_76319_b();
        prof.func_76319_b();
        BCLog.logger.info("[lib.guide] " + this.pageLinksAdded.size() + " search terms");
        BCLog.logger.info("[lib.guide] Loaded " + p + " possible and " + a + " actual guide pages (" + e + " not found) in " + time / 1000L + "ms.");
        BCLog.logger.info("[lib.guide] Performance information for guide loading:");
        ProfilerUtil.logProfilerResults(prof, "root", time * 1000L);
        BCLog.logger.info("[lib.guide] End of guide loading performance information. (" + time / 1000L + "ms)");
    }

    /*
     * Exception decompiling
     */
    private void loadLangInternal(IResourceManager resourceManager, String lang, Profiler prof) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateContentsPage(Profiler prof) {
        prof.func_76320_a("clear");
        this.objectsAdded.clear();
        this.contents.clear();
        prof.func_76318_c("setup");
        this.genTypeMap(null);
        for (GuideBook guideBook : GuideBookRegistry.INSTANCE.getAllEntries()) {
            this.genTypeMap(guideBook);
        }
        this.quickSearcher = new SimpleSuffixArray<PageLink>();
        this.pageLinksAdded.clear();
        prof.func_76318_c("add_pages");
        for (Map.Entry entry : GuidePageRegistry.INSTANCE.getReloadableEntryMap().entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            GuidePageFactory guidePageFactory = INSTANCE.getFactoryFor(resourceLocation);
            PageEntry entry2 = (PageEntry)entry.getValue();
            String translatedTitle = entry2.title;
            ISimpleDrawable icon = entry2.createDrawable();
            PageLine line = new PageLine(icon, icon, 2, translatedTitle, true);
            if (guidePageFactory == null) continue;
            this.objectsAdded.add(entry2.getBasicValue());
            PageLinkNormal pageLink = new PageLinkNormal(line, true, entry2.getTooltip(), guidePageFactory);
            prof.func_76320_a("add_child");
            this.addChild(entry2.book, entry2.typeTags, pageLink);
            prof.func_76319_b();
        }
        prof.func_76318_c("add_default");
        ContentsNode othersRoot = new ContentsNode(LocaleUtil.localize("buildcraft.guide.contents.all_group"), 0);
        for (Map.Entry<GuideBook, Map<TypeOrder, ContentsNode>> entry : this.contents.entrySet()) {
            GuideBook guideBook = entry.getKey();
            if (guideBook != null && !guideBook.appendAllEntries) continue;
            for (ContentsNode root : entry.getValue().values()) {
                root.addChild(othersRoot);
            }
        }
        IEntryLinkConsumer iEntryLinkConsumer = (tags, page) -> {
            String title;
            IContentsNode subNode;
            assert (tags.domain == null);
            assert (tags.subType == null);
            prof.func_76320_a("add_child");
            if (this.pageLinksAdded.add(page)) {
                this.quickSearcher.add(page, page.getSearchName());
            }
            if ((subNode = othersRoot.getChild(title = LocaleUtil.localize(tags.type))) instanceof ContentsNode) {
                subNode.addChild(page);
            } else if (subNode == null) {
                ContentsNode subContents = new ContentsNode(title, 1);
                othersRoot.addChild(subContents);
                subContents.addChild(page);
            } else {
                throw new IllegalStateException("Unknown node type " + subNode.getClass());
            }
            prof.func_76319_b();
        };
        for (PageValueType<?> pageValueType : GuidePageRegistry.INSTANCE.types) {
            prof.func_76320_a(pageValueType.getClass().getName().replace('.', '/'));
            pageValueType.iterateAllDefault(iEntryLinkConsumer, prof);
            prof.func_76319_b();
        }
        prof.func_76318_c("generate_quick_search");
        this.quickSearcher.generate(prof);
        prof.func_76318_c("sort");
        for (Map<TypeOrder, ContentsNode> map : this.contents.values()) {
            for (ContentsNode node : map.values()) {
                node.sort();
            }
        }
        prof.func_76319_b();
    }

    private void genTypeMap(GuideBook book) {
        HashMap<TypeOrder, ContentsNode> map = new HashMap<TypeOrder, ContentsNode>();
        this.contents.put(book, map);
        for (TypeOrder order : GuiGuide.SORTING_TYPES) {
            map.put(order, new ContentsNode("root", -1));
        }
    }

    private void addChild(ResourceLocation bookType, JsonTypeTags tags, PageLink page) {
        if (this.pageLinksAdded.add(page)) {
            this.quickSearcher.add(page, page.getSearchName());
        }
        for (Map.Entry<GuideBook, Map<TypeOrder, ContentsNode>> bookEntry : this.contents.entrySet()) {
            GuideBook book = bookEntry.getKey();
            if (book != null && !book.name.equals((Object)bookType)) continue;
            Map<TypeOrder, ContentsNode> map = bookEntry.getValue();
            for (Map.Entry<TypeOrder, ContentsNode> entry : map.entrySet()) {
                TypeOrder order = entry.getKey();
                String[] ordered = tags.getOrdered(order);
                ContentsNode[] nodePath = new ContentsNode[ordered.length];
                ContentsNode node = entry.getValue();
                for (int i = 0; i < ordered.length; ++i) {
                    String title = LocaleUtil.localize(ordered[i]);
                    IContentsNode subNode = node.getChild(title);
                    if (subNode instanceof ContentsNode) {
                        nodePath[i] = node = (ContentsNode)subNode;
                        continue;
                    }
                    if (subNode == null) {
                        ContentsNode subContents = new ContentsNode(title, i);
                        node.addChild(subContents);
                        nodePath[i] = node = subContents;
                        continue;
                    }
                    throw new IllegalStateException("Unknown node type " + subNode.getClass());
                }
                if (nodePath.length == 0) {
                    node.addChild(page);
                    continue;
                }
                nodePath[nodePath.length - 1].addChild(page);
            }
        }
    }

    @Nullable
    public GuidePageFactory getFactoryFor(ResourceLocation partialLocation) {
        return this.pages.get(partialLocation);
    }

    @Nullable
    public GuidePageFactory getFactoryFor(Object value) {
        if (value instanceof ItemStackValueFilter) {
            value = ((ItemStackValueFilter)value).stack.baseStack;
        } else if (value instanceof ItemStackKey) {
            value = ((ItemStackKey)value).baseStack;
        }
        if (value instanceof ItemStack) {
            return this.getPageFor((ItemStack)value);
        }
        return this.getFactoryFor(GuideManager.getEntryFor(value));
    }

    public static ResourceLocation getEntryFor(Object obj) {
        for (Map.Entry entry : GuidePageRegistry.INSTANCE.getReloadableEntryMap().entrySet()) {
            if (!((PageEntry)entry.getValue()).matches(obj)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nonnull
    public GuidePageFactory getPageFor(@Nonnull ItemStack stack) {
        GuidePageFactory factory;
        ResourceLocation entry = GuideManager.getEntryFor(stack);
        if (entry != null && (factory = this.getFactoryFor(entry)) != null) {
            return factory;
        }
        return this.generatedPages.computeIfAbsent(stack, GuidePageStandInRecipes::createFactory);
    }

    public ContentsNodeGui getGuiContents(GuiGuide gui, GuidePageContents guidePageContents, TypeOrder sortingOrder) {
        Map<TypeOrder, ContentsNode> map = this.contents.get(gui.book);
        if (map == null) {
            throw new IllegalStateException("Unknown book " + gui.book);
        }
        ContentsNode node = map.get(sortingOrder);
        if (node == null) {
            throw new IllegalStateException("Unknown sorting order " + sortingOrder);
        }
        node.resetVisibility();
        return new ContentsNodeGui(gui, node);
    }

    static {
        $VALUES = new GuideManager[]{INSTANCE};
        PAGE_LOADERS = new HashMap<String, IPageLoader>();
        BOOK_ALL_DATA = new GuideContentsData(null);
        DEBUG = BCDebugging.shouldDebugLog("lib.guide.loader");
        PAGE_LOADERS.put("md", MarkdownPageLoader.INSTANCE);
    }
}

