/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.api.core.IBox;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AxisOrder;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BoxIterator
implements Iterator<BlockPos> {
    @Nonnull
    private final BlockPos min;
    @Nonnull
    private final BlockPos max;
    private final boolean invert;
    private final boolean repeat;
    private AxisOrder order;
    private BlockPos current;

    public BoxIterator(IBox box, AxisOrder order, boolean invert) {
        this(box.min(), box.max(), order, invert);
    }

    public BoxIterator(BlockPos min, BlockPos max, AxisOrder order, boolean invert) {
        this(min, max, invert, false, order, null);
    }

    private BoxIterator(BlockPos min, BlockPos max, boolean invert, boolean repeat, AxisOrder order, BlockPos current) {
        if (min == null) {
            throw new NullPointerException("min");
        }
        if (max == null) {
            throw new NullPointerException("max");
        }
        if (order == null) {
            throw new NullPointerException("order");
        }
        this.min = min;
        this.max = max;
        this.invert = invert;
        this.repeat = repeat;
        this.order = order;
        this.current = current == null ? this.getStart() : current;
    }

    public static BoxIterator readFromNbt(NBTTagCompound nbt) {
        BlockPos min = NBTUtilBC.readBlockPos(nbt.func_74781_a("min"));
        BlockPos max = NBTUtilBC.readBlockPos(nbt.func_74781_a("max"));
        boolean invert = nbt.func_74767_n("invert");
        boolean repeat = false;
        AxisOrder order = AxisOrder.readNbt(nbt.func_74775_l("order"));
        BlockPos current = NBTUtilBC.readBlockPos(nbt.func_74781_a("current"));
        if (min == null || max == null || order == null) {
            return null;
        }
        return new BoxIterator(min, max, invert, repeat, order, current);
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("min", (NBTBase)NBTUtilBC.writeBlockPos(this.min));
        nbt.func_74782_a("max", (NBTBase)NBTUtilBC.writeBlockPos(this.max));
        nbt.func_74757_a("invert", this.invert);
        nbt.func_74782_a("order", (NBTBase)this.order.writeNBT());
        if (this.current != null) {
            nbt.func_74782_a("current", (NBTBase)NBTUtilBC.writeBlockPos(this.current));
        }
        return nbt;
    }

    private BlockPos getStart() {
        BlockPos pos = BlockPos.field_177992_a;
        pos = this.replace(pos, this.order.first);
        pos = this.replace(pos, this.order.second);
        return this.replace(pos, this.order.third);
    }

    private BlockPos replace(BlockPos toReplace, EnumFacing facing) {
        BlockPos with = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.min : this.max;
        return VecUtil.replaceValue((Vec3i)toReplace, facing.func_176740_k(), VecUtil.getValue((Vec3i)with, facing.func_176740_k()));
    }

    public BlockPos getCurrent() {
        return this.current;
    }

    @Nonnull
    public BlockPos getMin() {
        return this.min;
    }

    @Nonnull
    public BlockPos getMax() {
        return this.max;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public AxisOrder getOrder() {
        return this.order;
    }

    public BlockPos advance() {
        if (this.current == null) {
            this.current = this.getStart();
            return this.getCurrent();
        }
        this.current = BoxIterator.increment(this.current, this.order.first);
        if (this.shouldReset(this.current, this.order.first)) {
            if (this.invert) {
                this.order = this.order.invertFirst();
            }
            this.current = this.replace(this.current, this.order.first);
            this.current = BoxIterator.increment(this.current, this.order.second);
            if (this.shouldReset(this.current, this.order.second)) {
                if (this.invert) {
                    this.order = this.order.invertSecond();
                }
                this.current = this.replace(this.current, this.order.second);
                this.current = BoxIterator.increment(this.current, this.order.third);
                if (this.shouldReset(this.current, this.order.third)) {
                    if (this.repeat) {
                        if (this.invert) {
                            this.order = this.order.invertThird();
                        }
                        this.current = this.replace(this.current, this.order.third);
                    } else {
                        this.current = null;
                    }
                }
            }
        }
        return this.getCurrent();
    }

    private static BlockPos increment(BlockPos pos, EnumFacing facing) {
        int diff = facing.func_176743_c().func_179524_a();
        int value = VecUtil.getValue((Vec3i)pos, facing.func_176740_k()) + diff;
        return VecUtil.replaceValue((Vec3i)pos, facing.func_176740_k(), value);
    }

    private boolean shouldReset(BlockPos current, EnumFacing facing) {
        int lstReturned = VecUtil.getValue((Vec3i)current, facing.func_176740_k());
        BlockPos goingTo = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.max : this.min;
        int to = VecUtil.getValue((Vec3i)goingTo, facing.func_176740_k());
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return lstReturned > to;
        }
        return lstReturned < to;
    }

    public boolean hasFinished() {
        return this.current == null;
    }

    @Override
    public boolean hasNext() {
        return !this.hasFinished();
    }

    @Override
    public BlockPos next() {
        BlockPos c = this.current;
        this.advance();
        return c;
    }
}

