/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.render.shader.impl;

import com.zeitheron.hammercore.client.render.shader.HCShaderPipeline;
import com.zeitheron.hammercore.client.render.shader.IShaderOperation;
import com.zeitheron.hammercore.client.render.shader.ShaderProgram;
import com.zeitheron.hammercore.client.utils.RenderUtil;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import com.zeitheron.hammercore.client.utils.texture.TextureAtlasSpriteFull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.ARBShaderObjects;

public class ShaderEnderField {
    public static ShaderProgram endShader;
    public static EnderFieldOperation operation;

    public static void reloadShader() {
        try {
            if (endShader != null) {
                endShader.cleanup();
            }
            endShader = new ShaderProgram();
            endShader.attachFrag("/assets/hammercore/shaders/ender.fsh");
            endShader.attachVert("/assets/hammercore/shaders/ender.vsh");
            operation = new EnderFieldOperation(HCShaderPipeline.registerOperation());
            endShader.attachShaderOperation(operation);
            endShader.validate();
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public static void renderIntoGui(double xCoord, double yCoord, double widthIn, double heightIn) {
        if (ShaderEnderField.useShaders() && endShader == null) {
            ShaderEnderField.reloadShader();
        }
        if (ShaderEnderField.useShaders() && endShader != null) {
            endShader.freeBindShader();
        }
        UtilsFX.bindTexture("minecraft", "textures/entity/end_portal.png");
        RenderUtil.drawTexturedModalRect(xCoord, yCoord, TextureAtlasSpriteFull.sprite, widthIn, heightIn);
        if (ShaderEnderField.useShaders()) {
            ShaderProgram.unbindShader();
        }
    }

    public static void finishDrawWithShaders(Tessellator tess) {
        if (ShaderEnderField.useShaders() && endShader == null) {
            ShaderEnderField.reloadShader();
        }
        if (ShaderEnderField.useShaders() && endShader != null) {
            endShader.freeBindShader();
        }
        UtilsFX.bindTexture("minecraft", "textures/entity/end_portal.png");
        tess.func_78381_a();
        if (ShaderEnderField.useShaders()) {
            ShaderProgram.unbindShader();
        }
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static class EnderFieldOperation
    implements IShaderOperation {
        public final int op;

        public EnderFieldOperation(int op) {
            this.op = op;
        }

        @Override
        public boolean load(ShaderProgram program) {
            return true;
        }

        @Override
        public void operate(ShaderProgram program) {
            ARBShaderObjects.glUniform1fARB((int)program.getUniformLoc("time"), (float)((float)(Minecraft.func_71410_x().field_71441_e != null ? (double)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 10600.0 : (double)Minecraft.func_71386_F() / 530000.0)));
            ARBShaderObjects.glUniform1fARB((int)program.getUniformLoc("yaw"), (float)0.0f);
            ARBShaderObjects.glUniform1fARB((int)program.getUniformLoc("pitch"), (float)0.0f);
            ARBShaderObjects.glUniform4fARB((int)program.getUniformLoc("color"), (float)0.044f, (float)0.036f, (float)0.063f, (float)1.0f);
        }

        @Override
        public int operationID() {
            return this.op;
        }
    }
}

