/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.event.vanilla;

import com.zeitheron.hammercore.annotations.MCFBus;
import com.zeitheron.hammercore.event.WrenchEvent;
import com.zeitheron.hammercore.internal.blocks.IWitherProofBlock;
import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncable;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.wrench.IWrenchItem;
import com.zeitheron.hammercore.utils.wrench.IWrenchable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MCFBus
public class TileHandler {
    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent evt) {
        TileEntity te;
        IBlockState state = evt.getState();
        if (state.func_177230_c() instanceof ITileDroppable) {
            ((ITileDroppable)state.func_177230_c()).createDrop(evt.getPlayer(), evt.getWorld(), evt.getPos());
        }
        if ((te = evt.getWorld().func_175625_s(evt.getPos())) instanceof ITileDroppable) {
            ((ITileDroppable)te).createDrop(evt.getPlayer(), evt.getWorld(), evt.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerInteract(PlayerInteractEvent.RightClickBlock evt) {
        IWrenchItem item;
        EntityPlayer player = evt.getEntityPlayer();
        if (player != null && !player.func_184586_b(evt.getHand()).func_190926_b() && (item = WorldUtil.cast(player.func_184586_b(evt.getHand()).func_77973_b(), IWrenchItem.class)) != null && item.canWrench(player.func_184586_b(evt.getHand()))) {
            MinecraftForge.EVENT_BUS.post((Event)new WrenchEvent(player, evt.getPos(), evt.getHand(), evt.getFace()));
            item.onWrenchUsed(player, evt.getPos(), evt.getHand());
            WorldLocation wl = new WorldLocation(evt.getWorld(), evt.getPos());
            boolean swing = false;
            if (wl.getBlock() instanceof IWrenchable && ((IWrenchable)wl.getBlock()).onWrenchUsed(wl, player, evt.getHand())) {
                swing = true;
            }
            if (wl.getTile() instanceof IWrenchable && ((IWrenchable)wl.getTile()).onWrenchUsed(wl, player, evt.getHand())) {
                swing = true;
            }
            if (swing) {
                HCNet.swingArm(player, evt.getHand());
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void placeBlock(BlockEvent.PlaceEvent evt) {
        Block block;
        TileEntity te = evt.getWorld().func_175625_s(evt.getPos());
        if (te == null && (block = evt.getPlacedBlock().func_177230_c()) instanceof ITileEntityProvider) {
            te = block.createTileEntity(evt.getWorld(), evt.getPlacedBlock());
            evt.getWorld().func_175690_a(evt.getPos(), te);
        }
        if (te instanceof TileSyncable) {
            TileSyncable tile = (TileSyncable)te;
            tile.onPlacedBy(evt.getPlayer(), evt.getHand());
        }
    }

    @SubscribeEvent
    public void handleWitherBlocks(LivingDestroyBlockEvent e) {
        IBlockState state;
        if (e.getEntityLiving() instanceof EntityWither && (state = e.getState()).func_177230_c() instanceof IWitherProofBlock && ((IWitherProofBlock)state.func_177230_c()).isWitherproof(state)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void handleWitherBlocks(ExplosionEvent.Detonate w) {
        Explosion expl = w.getExplosion();
        if (expl != null && expl.func_94613_c() instanceof EntityWither) {
            List b = w.getAffectedBlocks();
            for (int i = 0; i < b.size(); ++i) {
                BlockPos p = (BlockPos)b.get(i);
                IBlockState state = w.getWorld().func_180495_p(p);
                if (!(state.func_177230_c() instanceof IWitherProofBlock) || !((IWitherProofBlock)state.func_177230_c()).isWitherproof(state)) continue;
                b.remove(i);
                --i;
            }
        }
    }
}

