/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.lib.zlib.io.pipelib;

import com.zeitheron.hammercore.lib.zlib.error.JSONException;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.lib.zlib.io.pipelib.FlowSide;
import com.zeitheron.hammercore.lib.zlib.io.pipelib.IFlowListener;
import com.zeitheron.hammercore.lib.zlib.io.pipelib.PipeFlow;
import com.zeitheron.hammercore.lib.zlib.json.JSONObject;
import com.zeitheron.hammercore.lib.zlib.json.JSONTokener;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class PipeClient
implements AutoCloseable,
Closeable {
    public final String MAC_ADDR;
    private JSONObject server;
    public List<IFlowListener> listeners = new ArrayList<IFlowListener>();
    private String ip;
    private int port;
    public String channel;

    public PipeClient(String server, String channel) {
        if (PipeFlow.ACCEPTOR.get() != null) {
            throw new RuntimeException("This thread already flows to " + PipeFlow.ACCEPTOR.get().name().toLowerCase() + "!");
        }
        PipeFlow.ACCEPTOR.set(FlowSide.CLIENT);
        String mac = "";
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] ha = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ha.length; ++i) {
                sb.append(String.format("%02X%s", ha[i], i < ha.length - 1 ? "-" : ""));
            }
            mac = sb.toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        this.MAC_ADDR = mac;
        this.channel = channel;
        try {
            this.server = (JSONObject)(server.startsWith("{") ? new JSONTokener(server.trim()).nextValue() : IOUtils.downloadjson(server));
            this.port = this.server.getInt("port");
            this.ip = this.server.getString("ip");
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to parse server info", e);
        }
    }

    public List<IFlowListener> getListeners() {
        return this.listeners;
    }

    public void addListener(IFlowListener l) {
        this.listeners.add(l);
    }

    public String getChannel() {
        return this.channel;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public JSONObject getServer() {
        return this.server;
    }

    public void flow(PipeFlow ... flows) {
        try (Socket s = new Socket(this.ip, this.port);){
            this.process(s, flows);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void process(Socket s, PipeFlow ... flows) throws IOException {
        DataInputStream i = new DataInputStream(s.getInputStream());
        DataOutputStream o = new DataOutputStream(s.getOutputStream());
        PipeFlow flow = new PipeFlow();
        flow.event = "Channel";
        flow.data = this.channel.getBytes();
        byte[] data = flow.serialize();
        o.writeInt(data.length);
        o.write(data);
        o.flush();
        if (!i.readBoolean()) {
            throw new IOException("Channel mismatch!");
        }
        o.writeShort(flows.length);
        for (int f = 0; f < flows.length; f = (int)((short)(f + 1))) {
            PipeFlow p = flows[f];
            byte[] data2 = p.serialize();
            o.writeInt(data2.length);
            o.write(data2);
        }
        ArrayList<PipeFlow> ps = new ArrayList<PipeFlow>();
        short packets = i.readShort();
        for (short f = 0; f < packets; f = (short)(f + 1)) {
            byte[] data3 = new byte[i.readInt()];
            i.read(data3);
            ps.addAll(new PipeFlow().deserialize(data3).perform(this.getListeners()));
        }
        o.close();
        i.close();
        s.close();
        if (!ps.isEmpty()) {
            this.flow(ps.toArray(new PipeFlow[ps.size()]));
        }
    }

    @Override
    public void close() {
        PipeFlow.ACCEPTOR.set(null);
    }
}

