/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketHolder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PacketContext {
    @Nonnull
    public final IContextSender sender;
    @Nonnull
    public final PacketHolder holder;
    @Nullable
    public final MinecraftServer server;
    @Nonnull
    public final Side side;
    private IPacket reply;

    public PacketContext(IContextSender sender, PacketHolder holder, MinecraftServer server) {
        this.sender = sender;
        this.holder = holder;
        this.server = server;
        this.side = FMLCommonHandler.instance().getEffectiveSide();
    }

    public PacketContext withReply(IPacket reply) {
        this.reply = reply;
        return this;
    }

    public IPacket getReply() {
        return this.reply;
    }

    @Nullable
    public EntityPlayerMP getSender() {
        if (this.sender instanceof ContextSenderPlayerMP) {
            return ((ContextSenderPlayerMP)this.sender).asPlayer();
        }
        if (this.server != null && this.holder != null && this.holder.containsPlayer()) {
            return this.holder.getPlayer(this.server);
        }
        return null;
    }

    public static class ContextSenderPlayerMP
    implements IContextSender {
        public EntityPlayerMP player;

        public ContextSenderPlayerMP(EntityPlayerMP player) {
            this.player = player;
        }

        @Override
        public Side from() {
            return Side.CLIENT;
        }

        @Override
        public EntityPlayerMP asPlayer() {
            return this.player;
        }
    }

    public static class ContextSenderServer
    implements IContextSender {
        @Override
        public Side from() {
            return Side.SERVER;
        }

        @Override
        public EntityPlayerMP asPlayer() {
            return null;
        }
    }

    public static interface IContextSender {
        public Side from();

        public EntityPlayerMP asPlayer();
    }
}

