/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.handler;

import com.google.common.collect.Ordering;
import com.google.gson.GsonBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import me.ichun.mods.morph.common.morph.MorphVariant;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.GameData;

public class NBTHandler {
    public static HashMap<Class<? extends EntityLivingBase>, TagModifier> modModifiers = new HashMap();
    public static HashMap<Class<? extends EntityLivingBase>, TagModifier> nbtModifiers = new HashMap();

    public static void modifyNBT(Class<? extends EntityLivingBase> clz, NBTTagCompound tag) {
        ArrayList<TagModifier> modifiers = NBTHandler.getModifiers(clz);
        for (TagModifier modifier : modifiers) {
            modifier.modifyTag(tag);
        }
    }

    public static ArrayList<TagModifier> getModifiers(Class<? extends Entity> entClz) {
        ArrayList<TagModifier> modifiers = new ArrayList<TagModifier>();
        while (entClz != Entity.class) {
            if (modModifiers.containsKey(entClz)) {
                modifiers.add(0, modModifiers.get(entClz));
            }
            if (nbtModifiers.containsKey(entClz)) {
                modifiers.add(0, nbtModifiers.get(entClz));
            }
            entClz = entClz.getSuperclass();
        }
        return modifiers;
    }

    public static void handleModifier(TagModifier tagModifier, String key, String value) {
        if (value.contains(";") && !value.contains(":")) {
            key = value.substring(0, value.indexOf(";"));
            value = value.substring(value.indexOf(";") + 1, value.length());
        }
        Object obj = value;
        if (value.contains(":")) {
            TagModifier nestedTagModifier = new TagModifier();
            obj = nestedTagModifier;
            nestedTagModifier.parentKey = value.substring(0, value.indexOf(":"));
            NBTHandler.handleModifier(nestedTagModifier, nestedTagModifier.parentKey, value.substring(value.indexOf(":") + 1, value.length()));
        } else if (value.equalsIgnoreCase("null")) {
            obj = null;
        } else if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("true")) {
            obj = value.equalsIgnoreCase("true");
        } else if (value.endsWith("F")) {
            try {
                obj = Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 1)));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (value.endsWith("D")) {
            try {
                obj = Double.parseDouble(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (value.endsWith("B")) {
            try {
                obj = Byte.parseByte(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (value.endsWith("S")) {
            try {
                obj = Short.parseShort(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (value.endsWith("L")) {
            try {
                obj = Long.parseLong(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                obj = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        tagModifier.modifiers.put(key, obj);
    }

    public static void createMinecraftEntityTags(World world) {
        TreeMap list = new TreeMap((Comparator<String>)Ordering.natural());
        for (EntityEntry entry : GameData.getEntityRegistry().getValues()) {
            Class clz = entry.getEntityClass();
            if (!EntityLivingBase.class.isAssignableFrom(clz) || clz == EntityLivingBase.class || clz == EntityLiving.class || clz == EntityMob.class) continue;
            try {
                EntityLivingBase living = (EntityLivingBase)clz.getConstructor(World.class).newInstance(world);
                NBTTagCompound tag = new NBTTagCompound();
                if (!living.func_70039_c(new NBTTagCompound())) continue;
                living.func_70014_b(tag);
                TreeMap<String, String> tags = new TreeMap<String, String>((Comparator<String>)Ordering.natural());
                MorphVariant.clean(living, tag);
                tag.func_82580_o("HealF");
                tag.func_82580_o("Health");
                tag.func_82580_o("CanPickUpLoot");
                tag.func_82580_o("PersistenceRequired");
                tag.func_82580_o("NoAI");
                tag.func_82580_o("Age");
                for (Map.Entry obj1 : tag.field_74784_a.entrySet()) {
                    tags.put((String)obj1.getKey(), "null");
                }
                if (tags.isEmpty()) continue;
                list.put(clz.getName(), tags);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        System.out.println(new GsonBuilder().setPrettyPrinting().create().toJson(list));
    }

    public static class TagModifier {
        public String parentKey;
        public HashMap<String, Object> modifiers = new HashMap();

        public void modifyTag(NBTTagCompound tag) {
            for (Map.Entry<String, Object> e : this.modifiers.entrySet()) {
                Object obj = e.getValue();
                if (obj == null) {
                    tag.func_82580_o(e.getKey());
                    continue;
                }
                if (obj instanceof TagModifier) {
                    NBTTagCompound tagToModify = tag.func_74775_l(((TagModifier)obj).parentKey);
                    if (tagToModify.func_82582_d()) continue;
                    ((TagModifier)obj).modifyTag(tagToModify);
                    continue;
                }
                if (obj instanceof Boolean) {
                    tag.func_74757_a(e.getKey(), ((Boolean)obj).booleanValue());
                    continue;
                }
                if (obj instanceof String) {
                    if (obj.equals("nullAsString")) {
                        tag.func_74778_a(e.getKey(), "null");
                        continue;
                    }
                    tag.func_74778_a(e.getKey(), (String)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    tag.func_74776_a(e.getKey(), ((Float)obj).floatValue());
                    continue;
                }
                if (obj instanceof Double) {
                    tag.func_74780_a(e.getKey(), ((Double)obj).doubleValue());
                    continue;
                }
                if (obj instanceof Integer) {
                    tag.func_74768_a(e.getKey(), ((Integer)obj).intValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    tag.func_74774_a(e.getKey(), ((Byte)obj).byteValue());
                    continue;
                }
                if (obj instanceof Short) {
                    tag.func_74777_a(e.getKey(), ((Short)obj).shortValue());
                    continue;
                }
                if (!(obj instanceof Long)) continue;
                tag.func_74772_a(e.getKey(), ((Long)obj).longValue());
            }
        }
    }
}

