/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.BlockTFCritter;
import twilightforest.block.BlockTFGiantBlock;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.TFBlocks;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.client.particle.TFParticleType;
import twilightforest.compat.Baubles;
import twilightforest.compat.TFCompat;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.EntityTFCharmEffect;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ITFProjectile;
import twilightforest.item.ItemTFPhantomArmor;
import twilightforest.item.TFItems;
import twilightforest.network.PacketAreaProtection;
import twilightforest.network.PacketEnforceProgressionStatus;
import twilightforest.network.PacketSetSkylightEnabled;
import twilightforest.network.PacketUpdateShield;
import twilightforest.network.TFPacketHandler;
import twilightforest.potions.TFPotions;
import twilightforest.util.TFItemStackUtils;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;
import twilightforest.world.WorldProviderTwilightForest;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFEventListener {
    private static final ImmutableSet<String> SHIELD_DAMAGE_BLACKLIST = ImmutableSet.of((Object)"inWall", (Object)"cramming", (Object)"drown", (Object)"starve", (Object)"fall", (Object)"flyIntoWall", (Object[])new String[]{"outOfWorld", "fallingBlock"});
    private static final Map<UUID, InventoryPlayer> playerKeepsMap = new HashMap<UUID, InventoryPlayer>();
    private static final Map<UUID, NonNullList<ItemStack>> playerKeepsMapBaubles = new HashMap<UUID, NonNullList<ItemStack>>();
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";
    private static boolean globalParry = !Loader.isModLoaded((String)"parry");

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.crafting;
        EntityPlayer player = event.player;
        if (itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f) && itemStack.func_190916_E() == 64 && TFEventListener.doesCraftMatrixHaveGiantLog(event.craftMatrix)) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150344_f, 64));
        }
    }

    private static boolean doesCraftMatrixHaveGiantLog(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Item.func_150898_a((Block)TFBlocks.giant_log)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (shouldMakeGiantCobble && event.getDrops().size() > 0 && ((ItemStack)event.getDrops().get(0)).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150347_e)) {
            event.getDrops().remove(0);
            if (amountOfCobbleToReplace == 64) {
                event.getDrops().add(new ItemStack(TFBlocks.giant_cobblestone));
            }
            if (--amountOfCobbleToReplace <= 0) {
                shouldMakeGiantCobble = false;
            }
        }
    }

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        Item item;
        EntityPlayer player;
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof EntityPlayer && event.getSource().field_76373_n.equals("mob") && event.getSource().func_76346_g() != null) {
            player = (EntityPlayer)living;
            int fireLevel = TFEnchantment.getFieryAuraLevel(player.field_71071_by, event.getSource());
            if (fireLevel > 0 && player.func_70681_au().nextInt(25) < fireLevel) {
                event.getSource().func_76346_g().func_70015_d(fireLevel / 2);
            }
        }
        if (living instanceof EntityPlayer && event.getSource().field_76373_n.equals("mob") && event.getSource().func_76346_g() instanceof EntityLivingBase) {
            player = (EntityPlayer)living;
            int chillLevel = TFEnchantment.getChillAuraLevel(player.field_71071_by, event.getSource());
            if (chillLevel > 0) {
                ((EntityLivingBase)event.getSource().func_76346_g()).func_70690_d(new PotionEffect(TFPotions.frosty, chillLevel * 5 + 5, chillLevel));
            }
        }
        if (event.getSource().field_76373_n.equals("arrow") && event.getSource().func_76346_g() instanceof EntityPlayer && ((player = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() == TFItems.triple_bow || player.func_184592_cb().func_77973_b() == TFItems.triple_bow)) {
            living.field_70172_ad = 0;
        }
        if (event.getSource().field_76373_n.equals("arrow") && event.getSource().func_76346_g() instanceof EntityPlayer && ((player = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() == TFItems.ender_bow || player.func_184592_cb().func_77973_b() == TFItems.ender_bow)) {
            double sourceX = player.field_70165_t;
            double sourceY = player.field_70163_u;
            double sourceZ = player.field_70161_v;
            float sourceYaw = player.field_70177_z;
            float sourcePitch = player.field_70125_A;
            player.field_70177_z = living.field_70177_z;
            player.field_70125_A = living.field_70125_A;
            player.func_70634_a(living.field_70165_t, living.field_70163_u, living.field_70161_v);
            player.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            living.func_70080_a(sourceX, sourceY, sourceZ, sourceYaw, sourcePitch);
            living.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        if ((item = living.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b()) instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof BlockTFCritter) {
            BlockTFCritter poorBug = (BlockTFCritter)((ItemBlock)item).func_179223_d();
            living.func_184201_a(EntityEquipmentSlot.HEAD, poorBug.getSquishResult());
            living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, poorBug.func_185467_w().func_185845_c(), living.func_184176_by(), 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void charmOfLife(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        boolean charm1 = false;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(living, s -> s.func_77973_b() == TFItems.charm_of_life_2, 1);
        if (!charm2) {
            charm1 = TFItemStackUtils.consumeInventoryItem(living, s -> s.func_77973_b() == TFItems.charm_of_life_1, 1);
        }
        if (charm2 || charm1) {
            if (charm1) {
                living.func_70606_j(8.0f);
                living.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 0));
            }
            if (charm2) {
                living.func_70606_j((float)living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
                living.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 3));
                living.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 600, 0));
                living.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 600, 0));
            }
            EntityTFCharmEffect effect = new EntityTFCharmEffect(living.field_70170_p, living, charm1 ? TFItems.charm_of_life_1 : TFItems.charm_of_life_2);
            living.field_70170_p.func_72838_d((Entity)effect);
            EntityTFCharmEffect effect2 = new EntityTFCharmEffect(living.field_70170_p, living, charm1 ? TFItems.charm_of_life_1 : TFItems.charm_of_life_2);
            effect2.offset = (float)Math.PI;
            living.field_70170_p.func_72838_d((Entity)effect2);
            living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_191263_gW, living.func_184176_by(), 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void charmOfKeeping(LivingDeathEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (living.field_70170_p.field_72995_K) {
            return;
        }
        if (living instanceof EntityPlayer && !living.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            int i;
            EntityPlayer player = (EntityPlayer)living;
            TFEventListener.dropStoredItems(player);
            boolean tier3 = TFItemStackUtils.consumeInventoryItem((EntityLivingBase)player, s -> s.func_77973_b() == TFItems.charm_of_keeping_3, 1);
            boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem((EntityLivingBase)player, s -> s.func_77973_b() == TFItems.charm_of_keeping_2, 1);
            boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem((EntityLivingBase)player, s -> s.func_77973_b() == TFItems.charm_of_keeping_1, 1);
            InventoryPlayer keepInventory = new InventoryPlayer(null);
            UUID playerUUID = player.func_110124_au();
            if (tier1) {
                TFEventListener.keepAllArmor(player, keepInventory);
                TFEventListener.keepOffHand(player, keepInventory);
            }
            if (tier3) {
                for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                    keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
                keepInventory.func_70437_b(new ItemStack(TFItems.charm_of_keeping_3));
            } else if (tier2) {
                for (i = 0; i < 9; ++i) {
                    keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
                keepInventory.func_70437_b(new ItemStack(TFItems.charm_of_keeping_2));
            } else if (tier1) {
                i = player.field_71071_by.field_70461_c;
                if (InventoryPlayer.func_184435_e((int)i)) {
                    keepInventory.field_70462_a.set(i, (Object)((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77946_l());
                    player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                }
                keepInventory.func_70437_b(new ItemStack(TFItems.charm_of_keeping_1));
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_77973_b() != TFItems.tower_key) continue;
                keepInventory.field_70462_a.set(i, (Object)stack.func_77946_l());
                player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            }
            if (tier1 && TFCompat.BAUBLES.isActivated()) {
                NonNullList baubles = NonNullList.func_191197_a((int)Baubles.getSlotAmount(player), (Object)ItemStack.field_190927_a);
                Baubles.keepBaubles(player, (NonNullList<ItemStack>)baubles);
                playerKeepsMapBaubles.put(playerUUID, (NonNullList<ItemStack>)baubles);
            }
            for (int i2 = 0; i2 < player.field_71071_by.field_70460_b.size(); ++i2) {
                ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(i2);
                if (!(armor.func_77973_b() instanceof ItemTFPhantomArmor)) continue;
                keepInventory.field_70460_b.set(i2, (Object)armor.func_77946_l());
                player.field_71071_by.field_70460_b.set(i2, (Object)ItemStack.field_190927_a);
            }
            playerKeepsMap.put(playerUUID, keepInventory);
        }
    }

    private static void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            keepInventory.field_70460_b.set(i, (Object)((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77946_l());
            player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    private static void keepOffHand(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
            keepInventory.field_184439_c.set(i, (Object)((ItemStack)player.field_71071_by.field_184439_c.get(i)).func_77946_l());
            player.field_71071_by.field_184439_c.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            TFEventListener.updateCapabilities((EntityPlayerMP)event.player, (Entity)event.player);
        } else {
            TFEventListener.returnStoredItems(event.player);
        }
    }

    private static void returnStoredItems(EntityPlayer player) {
        NonNullList<ItemStack> baubles;
        InventoryPlayer keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            ItemStack existing;
            ItemStack kept;
            int i;
            TwilightForestMod.LOGGER.debug("Player {} respawned and received items held in storage", (Object)player.func_70005_c_());
            NonNullList displaced = NonNullList.func_191196_a();
            for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                kept = (ItemStack)keepInventory.field_70460_b.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_70460_b.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
                kept = (ItemStack)keepInventory.field_184439_c.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_184439_c.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                kept = (ItemStack)keepInventory.field_70462_a.get(i);
                if (kept.func_190926_b() || (existing = (ItemStack)player.field_71071_by.field_70462_a.set(i, (Object)kept)).func_190926_b()) continue;
                displaced.add((Object)existing);
            }
            for (ItemStack extra : displaced) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)extra);
            }
            if (!keepInventory.func_70445_o().func_190926_b()) {
                EntityTFCharmEffect effect = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                player.field_70170_p.func_72838_d((Entity)effect);
                EntityTFCharmEffect effect2 = new EntityTFCharmEffect(player.field_70170_p, (EntityLivingBase)player, keepInventory.func_70445_o().func_77973_b());
                effect2.offset = (float)Math.PI;
                player.field_70170_p.func_72838_d((Entity)effect2);
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187941_ho, player.func_184176_by(), 1.5f, 1.0f);
            }
        }
        if (TFCompat.BAUBLES.isActivated() && (baubles = playerKeepsMapBaubles.remove(player.func_110124_au())) != null) {
            TwilightForestMod.LOGGER.debug("Player {} respawned and received baubles held in storage", (Object)player.func_70005_c_());
            Baubles.respawnBaubles(player, baubles);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        TFEventListener.dropStoredItems(event.player);
    }

    private static void dropStoredItems(EntityPlayer player) {
        NonNullList<ItemStack> baubles;
        InventoryPlayer keepInventory = playerKeepsMap.remove(player.func_110124_au());
        if (keepInventory != null) {
            TwilightForestMod.LOGGER.warn("Dropping inventory items previously held in reserve for player {}", (Object)player.func_70005_c_());
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
        }
        if (TFCompat.BAUBLES.isActivated() && (baubles = playerKeepsMapBaubles.remove(player.func_110124_au())) != null) {
            TwilightForestMod.LOGGER.warn("Dropping baubles previously held in reserve for player {}", (Object)player.func_70005_c_());
            for (ItemStack itemStack : baubles) {
                if (itemStack.func_190926_b()) continue;
                player.func_146097_a(itemStack, true, false);
            }
        }
    }

    @SubscribeEvent
    public static boolean livingUpdate(LivingEvent.LivingUpdateEvent event) {
        IShieldCapability cap;
        if (event.getEntityLiving().hasCapability(CapabilityList.SHIELDS, null) && (cap = (IShieldCapability)event.getEntityLiving().getCapability(CapabilityList.SHIELDS, null)) != null) {
            cap.update();
        }
        if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().func_70093_af() && TFEventListener.isRidingUnfriendly(event.getEntityLiving())) {
            event.getEntityLiving().func_70095_a(false);
        }
        return true;
    }

    public static boolean isRidingUnfriendly(EntityLivingBase entity) {
        return entity.func_184218_aH() && entity.func_184187_bx() instanceof IHostileMount;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K && !event.getPlayer().field_71075_bZ.field_75098_d && TFEventListener.isAreaProtected(event.getWorld(), event.getPlayer(), event.getPos()) && TFEventListener.isBlockProtectedFromBreaking(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        } else if (!isBreakingWithGiantPick && event.getPlayer().func_184614_ca().func_77973_b() == TFItems.giant_pickaxe && event.getPlayer().func_184614_ca().func_77973_b().canHarvestBlock(event.getState(), event.getPlayer().func_184614_ca())) {
            BlockPos dPos;
            int dz;
            int dy;
            int dx;
            isBreakingWithGiantPick = true;
            BlockPos bPos = BlockTFGiantBlock.roundCoords(event.getPos());
            boolean allCobble = event.getState().func_177230_c().func_180660_a(event.getState(), event.getWorld().field_73012_v, 0) == Item.func_150898_a((Block)Blocks.field_150347_e);
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        dPos = bPos.func_177982_a(dx, dy, dz);
                        IBlockState stateThere = event.getWorld().func_180495_p(dPos);
                        Block blockThere = stateThere.func_177230_c();
                        allCobble &= blockThere.func_180660_a(stateThere, event.getWorld().field_73012_v, 0) == Item.func_150898_a((Block)Blocks.field_150347_e);
                    }
                }
            }
            if (allCobble && !event.getPlayer().field_71075_bZ.field_75098_d) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            for (dx = 0; dx < 4; ++dx) {
                for (dy = 0; dy < 4; ++dy) {
                    for (dz = 0; dz < 4; ++dz) {
                        dPos = bPos.func_177982_a(dx, dy, dz);
                        if (dPos.equals((Object)event.getPos()) || event.getState() != event.getWorld().func_180495_p(dPos) || !(event.getPlayer() instanceof EntityPlayerMP)) continue;
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.getPlayer();
                        playerMP.field_71134_c.func_180237_b(dPos);
                    }
                }
            }
            isBreakingWithGiantPick = false;
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
            World world = event.getEntityPlayer().field_70170_p;
            EntityPlayer player = event.getEntityPlayer();
            if (!world.field_72995_K && TFEventListener.isBlockProtectedFromInteraction(world, event.getPos()) && TFEventListener.isAreaProtected(world, player, event.getPos())) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    private static boolean isBlockProtectedFromInteraction(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == TFBlocks.tower_device || block == Blocks.field_150486_ae || block == Blocks.field_150447_bR || block == Blocks.field_150430_aB || block == Blocks.field_150471_bO || block == Blocks.field_150442_at;
    }

    private static boolean isBlockProtectedFromBreaking(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_177230_c().getRegistryName().func_110623_a().contains("grave");
    }

    private static boolean isAreaProtected(World world, EntityPlayer player, BlockPos pos) {
        TFFeature nearbyFeature;
        ChunkGeneratorTFBase chunkGenerator;
        if (world.func_82736_K().func_82766_b("tfEnforcedProgression") && TFWorld.getChunkGenerator(world) instanceof ChunkGeneratorTFBase && (chunkGenerator = (ChunkGeneratorTFBase)TFWorld.getChunkGenerator(world)) != null && chunkGenerator.isBlockInStructureBB(pos) && !(nearbyFeature = TFFeature.getFeatureAt(pos.func_177958_n(), pos.func_177952_p(), world)).doesPlayerHaveRequiredAdvancements(player) && chunkGenerator.isBlockProtected(pos)) {
            TFEventListener.sendAreaProtectionPacket(world, pos, chunkGenerator.getSBBAt(pos));
            nearbyFeature.trySpawnHintMonster(world, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(World world, BlockPos pos, StructureBoundingBox sbb) {
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)new PacketAreaProtection(sbb, pos), targetPoint);
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
        IShieldCapability cap;
        EntityLivingBase living = event.getEntityLiving();
        if (living instanceof IMob && event.getSource().func_76346_g() instanceof EntityPlayerMP && !((EntityPlayer)event.getSource().func_76346_g()).field_71075_bZ.field_75098_d && TFWorld.getChunkGenerator(living.field_70170_p) instanceof ChunkGeneratorTFBase && living.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression")) {
            TFFeature nearbyFeature;
            ChunkGeneratorTFBase chunkGenerator = (ChunkGeneratorTFBase)TFWorld.getChunkGenerator(living.func_130014_f_());
            BlockPos pos = new BlockPos((Entity)living);
            if (chunkGenerator != null && chunkGenerator.isBlockInStructureBB(pos) && chunkGenerator.isBlockProtected(pos) && !(nearbyFeature = TFFeature.getFeatureAt(pos.func_177958_n(), pos.func_177952_p(), living.field_70170_p)).doesPlayerHaveRequiredAdvancements((EntityPlayer)event.getSource().func_76346_g())) {
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
                for (int i = 0; i < 20; ++i) {
                    TwilightForestMod.proxy.spawnParticle(living.field_70170_p, TFParticleType.PROTECTION, living.field_70165_t, living.field_70163_u, living.field_70161_v, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!living.field_70170_p.field_72995_K && living.hasCapability(CapabilityList.SHIELDS, null) && !SHIELD_DAMAGE_BLACKLIST.contains((Object)event.getSource().field_76373_n) && (cap = (IShieldCapability)living.getCapability(CapabilityList.SHIELDS, null)) != null && cap.shieldsLeft() > 0) {
            cap.breakShield();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            TFEventListener.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression"));
            TFEventListener.updateCapabilities((EntityPlayerMP)event.player, (Entity)event.player);
            TFEventListener.banishNewbieToTwilightZone(event.player);
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            if (event.toDim == TFConfig.dimension.dimensionID) {
                TFEventListener.sendEnforcedProgressionStatus((EntityPlayerMP)event.player, event.player.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression"));
            }
            TFEventListener.updateCapabilities((EntityPlayerMP)event.player, (Entity)event.player);
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        TFEventListener.updateCapabilities((EntityPlayerMP)event.getEntityPlayer(), event.getTarget());
    }

    private static void updateCapabilities(EntityPlayerMP player, Entity entity) {
        IShieldCapability cap = (IShieldCapability)entity.getCapability(CapabilityList.SHIELDS, null);
        if (cap != null && cap.shieldsLeft() > 0) {
            TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketUpdateShield(entity, cap), player);
        }
    }

    private static void sendEnforcedProgressionStatus(EntityPlayerMP player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketEnforceProgressionStatus(isEnforced), player);
    }

    private static void sendSkylightEnabled(EntityPlayerMP player, boolean skylightEnabled) {
        TFPacketHandler.CHANNEL.sendTo((IMessage)new PacketSetSkylightEnabled(skylightEnabled), player);
    }

    @SubscribeEvent
    public static void onClientConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        INetHandlerPlayServer handler = (INetHandlerPlayServer)event.getHandler();
        if (handler instanceof NetHandlerPlayServer) {
            EntityPlayerMP player = ((NetHandlerPlayServer)handler).field_147369_b;
            TFEventListener.sendSkylightEnabled(player, WorldProviderTwilightForest.isSkylightEnabled(TFWorld.getDimensionData(player.field_70170_p)));
        }
    }

    @SubscribeEvent
    public static void onServerDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        WorldProviderTwilightForest.syncFromConfig();
    }

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && !event.getWorld().func_82736_K().func_82765_e("tfEnforcedProgression")) {
            TwilightForestMod.LOGGER.info("Loaded a world with the {} game rule not defined. Defining it.", (Object)"tfEnforcedProgression");
            event.getWorld().func_82736_K().func_180262_a("tfEnforcedProgression", String.valueOf(TFConfig.progressionRuleDefault), GameRules.ValueType.BOOLEAN_VALUE);
        }
    }

    @SubscribeEvent
    public static void gameRuleChanged(GameRuleChangeEvent event) {
        if (event.getRuleName().equals("tfEnforcedProgression")) {
            boolean isEnforced = event.getRules().func_82766_b("tfEnforcedProgression");
            TFPacketHandler.CHANNEL.sendToAll((IMessage)new PacketEnforceProgressionStatus(isEnforced));
        }
    }

    private static void banishNewbieToTwilightZone(EntityPlayer player) {
        NBTTagCompound tagCompound = player.getEntityData();
        NBTTagCompound playerData = tagCompound.func_74775_l("PlayerPersisted");
        boolean shouldBanishPlayer = TFConfig.dimension.newPlayersSpawnInTF && !playerData.func_74767_n(NBT_TAG_TWILIGHT);
        playerData.func_74757_a(NBT_TAG_TWILIGHT, true);
        tagCompound.func_74782_a("PlayerPersisted", (NBTBase)playerData);
        if (shouldBanishPlayer) {
            BlockTFPortal.attemptSendPlayer((Entity)player, true);
        }
    }

    @SubscribeEvent
    public static void onAdvancementGet(AdvancementEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof EntityPlayerMP) {
            TFAdvancements.ADVANCEMENT_UNLOCKED.trigger((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void armorChanged(LivingEquipmentChangeEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        if (!living.field_70170_p.field_72995_K && living instanceof EntityPlayerMP) {
            TFAdvancements.ARMOR_CHANGED.trigger((EntityPlayerMP)living, event.getFrom(), event.getTo());
        }
    }

    @SubscribeEvent
    public static void arrowParry(ProjectileImpactEvent.Arrow event) {
        final EntityArrow projectile = event.getArrow();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (TFConfig.shieldInteractions.parryNonTwilightAttacks || projectile instanceof ITFProjectile)) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= TFConfig.shieldInteractions.shieldParryTicksArrow) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.field_70250_c = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void fireballParry(ProjectileImpactEvent.Fireball event) {
        final EntityFireball projectile = event.getFireball();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (TFConfig.shieldInteractions.parryNonTwilightAttacks || projectile instanceof ITFProjectile)) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= TFConfig.shieldInteractions.shieldParryTicksFireball) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.field_70159_w = playerVec3.field_72450_a;
                projectile.field_70181_x = playerVec3.field_72448_b;
                projectile.field_70179_y = playerVec3.field_72449_c;
                projectile.field_70232_b = projectile.field_70159_w * 0.1;
                projectile.field_70233_c = projectile.field_70181_x * 0.1;
                projectile.field_70230_d = projectile.field_70179_y * 0.1;
                projectile.field_70235_a = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void throwableParry(ProjectileImpactEvent.Throwable event) {
        final EntityThrowable projectile = event.getThrowable();
        if (!projectile.func_130014_f_().field_72995_K && globalParry && (TFConfig.shieldInteractions.parryNonTwilightAttacks || projectile instanceof ITFProjectile)) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= TFConfig.shieldInteractions.shieldParryTicksThrowable) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.field_70192_c = entityBlocking;
                event.setCanceled(true);
            }
        }
    }
}

