/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.TFBlocks;
import twilightforest.world.ChunkGeneratorTFBase;

public class TFTeleporter
extends Teleporter {
    public static TFTeleporter getTeleporterForDim(MinecraftServer server, int dim) {
        WorldServer ws = server.func_71218_a(dim);
        for (Teleporter t : ws.customTeleporters) {
            if (!(t instanceof TFTeleporter)) continue;
            return (TFTeleporter)t;
        }
        TFTeleporter tp = new TFTeleporter(ws);
        ws.customTeleporters.add(tp);
        return tp;
    }

    private TFTeleporter(WorldServer dest) {
        super(dest);
    }

    public void func_180266_a(Entity entity, float facing) {
        if (!this.func_180620_b(entity, facing)) {
            this.moveToSafeCoords(entity);
            this.func_85188_a(entity);
            this.func_180620_b(entity, facing);
        }
    }

    private void moveToSafeCoords(Entity entity) {
        BlockPos pos = new BlockPos(entity);
        boolean checkProgression = this.field_85192_a.func_82736_K().func_82766_b("tfEnforcedProgression");
        if (!this.isSafeAround(pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
            BlockPos safeCoords = this.findSafeCoords(200, pos, entity, checkProgression);
            if (safeCoords != null) {
                entity.func_70012_b((double)safeCoords.func_177958_n(), entity.field_70163_u, (double)safeCoords.func_177952_p(), 90.0f, 0.0f);
                TwilightForestMod.LOGGER.debug("Safely rerouted!");
            } else {
                TwilightForestMod.LOGGER.debug("Did not find a safe spot at first try, trying again with longer range.");
                safeCoords = this.findSafeCoords(400, pos, entity, checkProgression);
                if (safeCoords != null) {
                    entity.func_70012_b((double)safeCoords.func_177958_n(), entity.field_70163_u, (double)safeCoords.func_177952_p(), 90.0f, 0.0f);
                    TwilightForestMod.LOGGER.debug("Safely rerouted to long range portal.  Return trip not guaranteed.");
                } else {
                    TwilightForestMod.LOGGER.debug("Did not find a safe spot.");
                }
            }
        }
    }

    @Nullable
    private BlockPos findSafeCoords(int range, BlockPos pos, Entity entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int i = 0; i < attempts; ++i) {
            BlockPos dPos = new BlockPos(pos.func_177958_n() + this.field_77187_a.nextInt(range) - this.field_77187_a.nextInt(range), 100, pos.func_177952_p() + this.field_77187_a.nextInt(range) - this.field_77187_a.nextInt(range));
            if (!this.isSafeAround(dPos, entity, checkProgression)) continue;
            return dPos;
        }
        return null;
    }

    public final boolean isSafeAround(BlockPos pos, Entity entity, boolean checkProgression) {
        if (!this.isSafe(pos, entity, checkProgression)) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            if (this.isSafe(pos.func_177967_a(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafe(BlockPos pos, Entity entity, boolean checkProgression) {
        return this.checkPos(pos) && (!checkProgression || this.checkBiome(pos, entity)) && this.checkStructure(pos);
    }

    private boolean checkPos(BlockPos pos) {
        return this.field_85192_a.func_175723_af().func_177746_a(pos);
    }

    private boolean checkStructure(BlockPos pos) {
        IChunkGenerator generator = this.field_85192_a.func_72863_F().field_186029_c;
        if (generator instanceof ChunkGeneratorTFBase) {
            if (!this.field_85192_a.func_175667_e(pos)) {
                generator.func_180514_a(null, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            }
            return !((ChunkGeneratorTFBase)generator).isBlockInFullStructure(pos.func_177958_n(), pos.func_177952_p());
        }
        return true;
    }

    private boolean checkBiome(BlockPos pos, Entity entity) {
        Biome biome = this.field_85192_a.func_180494_b(pos);
        if (biome instanceof TFBiomeBase && entity instanceof EntityPlayerMP) {
            TFBiomeBase tfBiome = (TFBiomeBase)biome;
            EntityPlayerMP player = (EntityPlayerMP)entity;
            return tfBiome.doesPlayerHaveRequiredAchievement((EntityPlayer)player);
        }
        return true;
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        int i = 200;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entity.field_70165_t);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        boolean flag = true;
        BlockPos blockpos = BlockPos.field_177992_a;
        long l = ChunkPos.func_77272_a((int)j, (int)k);
        if (this.field_85191_c.containsKey(l)) {
            Teleporter.PortalPosition portalPosition = (Teleporter.PortalPosition)this.field_85191_c.get(l);
            d0 = 0.0;
            blockpos = portalPosition;
            portalPosition.field_85087_d = this.field_85192_a.func_82737_E();
            flag = false;
        } else {
            BlockPos blockpos3 = new BlockPos(entity);
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    if (!this.field_85192_a.func_175723_af().func_177746_a(blockpos3.func_177982_a(i1, 0, j1))) continue;
                    ChunkPos chunkPos = new ChunkPos(blockpos3.func_177982_a(i1, 0, j1));
                    if (!this.field_85192_a.func_190526_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) continue;
                    Chunk chunk = this.field_85192_a.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
                    BlockPos blockpos1 = blockpos3.func_177982_a(i1, this.getScanHeight(blockpos3) - blockpos3.func_177956_o(), j1);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (!(d0 >= 0.0 && blockpos1.func_177951_i((Vec3i)blockpos3) >= d0 || chunk.func_177435_g(blockpos1).func_177230_c() != TFBlocks.twilight_portal)) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (chunk.func_177435_g(blockpos2).func_177230_c() == TFBlocks.twilight_portal) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double d1 = blockpos1.func_177951_i((Vec3i)blockpos3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                                i = MathHelper.func_76123_f((float)MathHelper.func_76133_a((double)d1));
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                    if (this.field_85192_a.func_184164_w().func_152621_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) continue;
                    this.field_85192_a.func_72863_F().func_189549_a(chunk);
                }
            }
        }
        if (d0 >= 0.0) {
            if (flag) {
                this.field_85191_c.put(l, (Object)new Teleporter.PortalPosition((Teleporter)this, blockpos, this.field_85192_a.func_82737_E()));
            }
            BlockPos[] portalBorder = this.getBoundaryPositions(blockpos).toArray(new BlockPos[0]);
            BlockPos borderPos = portalBorder[this.field_77187_a.nextInt(portalBorder.length)];
            double portalX = (double)borderPos.func_177958_n() + 0.5;
            double portalY = (double)borderPos.func_177956_o() + 1.0;
            double portalZ = (double)borderPos.func_177952_p() + 0.5;
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(portalX, portalY, portalZ, entity.field_70177_z, entity.field_70125_A);
            } else {
                entity.func_70012_b(portalX, portalY, portalZ, entity.field_70177_z, entity.field_70125_A);
            }
            return true;
        }
        return false;
    }

    private int getScanHeight(BlockPos pos) {
        return this.getScanHeight(pos.func_177958_n(), pos.func_177952_p());
    }

    private int getScanHeight(int x, int z) {
        int worldHeight = this.field_85192_a.func_72940_L() - 1;
        int chunkHeight = this.field_85192_a.func_72964_e(x >> 4, z >> 4).func_76625_h() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private Set<BlockPos> getBoundaryPositions(BlockPos start) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(start);
        this.checkAdjacent(start, checked, result);
        return result;
    }

    private void checkAdjacent(BlockPos pos, Set<BlockPos> checked, Set<BlockPos> result) {
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!checked.add(offset)) continue;
            if (this.isBlockPortal((World)this.field_85192_a, offset)) {
                this.checkAdjacent(offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private boolean isBlockPortal(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == TFBlocks.twilight_portal;
    }

    public boolean func_85188_a(Entity entity) {
        this.loadSurroundingArea(entity);
        BlockPos spot = this.findPortalCoords(entity, this::isIdealPortal);
        String name = entity.func_70005_c_();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            this.cachePortalCoords(entity, this.makePortalAt((World)this.field_85192_a, spot));
            return true;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = this.findPortalCoords(entity, this::isOkayPortal);
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            this.cachePortalCoords(entity, this.makePortalAt((World)this.field_85192_a, spot));
            return true;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one for {}", (Object)name);
        double yFactor = this.getYFactor();
        this.cachePortalCoords(entity, this.makePortalAt((World)this.field_85192_a, new BlockPos(entity.field_70165_t, entity.field_70163_u * yFactor - 1.0, entity.field_70161_v)));
        return false;
    }

    private void loadSurroundingArea(Entity entity) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t) >> 4;
        int z = MathHelper.func_76128_c((double)entity.field_70161_v) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                this.field_85192_a.func_72964_e(x + dx, z + dz);
            }
        }
    }

    private double getYFactor() {
        return this.field_85192_a.field_73011_w.getDimension() == TFConfig.originDimension ? 2.0 : 0.5;
    }

    @Nullable
    private BlockPos findPortalCoords(Entity entity, Predicate<BlockPos> predicate) {
        double yFactor = this.getYFactor();
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - entity.field_70165_t;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - entity.field_70161_v;
                for (int ry = this.getScanHeight(rx, rz); ry >= 0; --ry) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)pos.func_181079_c(rx, ry, rz))) continue;
                    while (ry > 0 && this.field_85192_a.func_175623_d((BlockPos)pos.func_181079_c(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - entity.field_70163_u * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((BlockPos)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.func_185334_h();
                }
            }
        }
        return spot;
    }

    private boolean isIdealPortal(BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.func_177982_a(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = this.field_85192_a.func_180495_p(tPos).func_185904_a();
                    if ((potentialY != 0 || material == Material.field_151577_b) && (potentialY < 1 || material.func_76222_j())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isOkayPortal(BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.func_177982_a(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = this.field_85192_a.func_180495_p(tPos).func_185904_a();
                    if ((potentialY != 0 || material.func_76220_a() || material.func_76224_d()) && (potentialY < 1 || material.func_76222_j())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void cachePortalCoords(Entity entity, BlockPos pos) {
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        this.field_85191_c.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)new Teleporter.PortalPosition((Teleporter)this, pos, this.field_85192_a.func_82737_E()));
    }

    private BlockPos makePortalAt(World world, BlockPos pos) {
        if (pos.func_177956_o() < 30) {
            pos = new BlockPos(pos.func_177958_n(), 30, pos.func_177952_p());
        } else if (pos.func_177956_o() > 118) {
            pos = new BlockPos(pos.func_177958_n(), 118, pos.func_177952_p());
        }
        IBlockState grass = Blocks.field_150349_c.func_176223_P();
        world.func_175656_a(pos.func_177976_e().func_177978_c(), grass);
        world.func_175656_a(pos.func_177978_c(), grass);
        world.func_175656_a(pos.func_177974_f().func_177978_c(), grass);
        world.func_175656_a(pos.func_177965_g(2).func_177978_c(), grass);
        world.func_175656_a(pos.func_177976_e(), grass);
        world.func_175656_a(pos.func_177965_g(2), grass);
        world.func_175656_a(pos.func_177976_e().func_177968_d(), grass);
        world.func_175656_a(pos.func_177965_g(2).func_177968_d(), grass);
        world.func_175656_a(pos.func_177976_e().func_177970_e(2), grass);
        world.func_175656_a(pos.func_177970_e(2), grass);
        world.func_175656_a(pos.func_177974_f().func_177970_e(2), grass);
        world.func_175656_a(pos.func_177965_g(2).func_177970_e(2), grass);
        IBlockState dirt = Blocks.field_150346_d.func_176223_P();
        world.func_175656_a(pos.func_177977_b(), dirt);
        world.func_175656_a(pos.func_177974_f().func_177977_b(), dirt);
        world.func_175656_a(pos.func_177968_d().func_177977_b(), dirt);
        world.func_175656_a(pos.func_177974_f().func_177968_d().func_177977_b(), dirt);
        IBlockState portal = TFBlocks.twilight_portal.func_176223_P().func_177226_a(BlockTFPortal.DISALLOW_RETURN, (Comparable)Boolean.valueOf(!TFConfig.shouldReturnPortalBeUsable));
        world.func_180501_a(pos, portal, 2);
        world.func_180501_a(pos.func_177974_f(), portal, 2);
        world.func_180501_a(pos.func_177968_d(), portal, 2);
        world.func_180501_a(pos.func_177974_f().func_177968_d(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.func_175698_g(pos.func_177982_a(dx, dy, dz));
                }
            }
        }
        world.func_180501_a(pos.func_177976_e().func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177974_f().func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177968_d().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177968_d().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177974_f().func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        return pos;
    }

    private IBlockState randNatureBlock(Random random) {
        Block[] blocks = new Block[]{Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N};
        return blocks[random.nextInt(blocks.length)].func_176223_P();
    }
}

