/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenMinable;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.features.GenDruidHut;
import twilightforest.world.feature.TFGenCanopyMushroom;
import twilightforest.world.feature.TFGenCanopyTree;
import twilightforest.world.feature.TFGenFallenHollowLog;
import twilightforest.world.feature.TFGenFallenSmallLog;
import twilightforest.world.feature.TFGenFoundation;
import twilightforest.world.feature.TFGenGroveRuins;
import twilightforest.world.feature.TFGenHollowStump;
import twilightforest.world.feature.TFGenHollowTree;
import twilightforest.world.feature.TFGenMangroveTree;
import twilightforest.world.feature.TFGenMonolith;
import twilightforest.world.feature.TFGenMyceliumBlob;
import twilightforest.world.feature.TFGenOutsideStalagmite;
import twilightforest.world.feature.TFGenPlantRoots;
import twilightforest.world.feature.TFGenStoneCircle;
import twilightforest.world.feature.TFGenTorchBerries;
import twilightforest.world.feature.TFGenWell;
import twilightforest.world.feature.TFGenWoodRoots;
import twilightforest.world.feature.TFGenerator;
import twilightforest.world.feature.TFTreeGenerator;

public class TFBiomeDecorator
extends BiomeDecorator {
    TFGenCanopyTree canopyTreeGen = new TFGenCanopyTree();
    TFTreeGenerator alternateCanopyGen = new TFGenCanopyMushroom();
    private TFGenHollowTree hollowTreeGen = new TFGenHollowTree();
    private TFGenMyceliumBlob myceliumBlobGen = new TFGenMyceliumBlob(5);
    private WorldGenLakes extraLakeGen = new WorldGenLakes((Block)Blocks.field_150355_j);
    private WorldGenLakes extraLavaPoolGen = new WorldGenLakes((Block)Blocks.field_150353_l);
    private TFGenMangroveTree mangroveTreeGen = new TFGenMangroveTree();
    private TFGenPlantRoots plantRootGen = new TFGenPlantRoots();
    private TFGenWoodRoots woodRootGen = new TFGenWoodRoots();
    private WorldGenLiquids caveWaterGen = new WorldGenLiquids((Block)Blocks.field_150358_i);
    private TFGenTorchBerries torchBerryGen = new TFGenTorchBerries();
    public float canopyPerChunk;
    public boolean hasCanopy;
    public float alternateCanopyChance;
    public int myceliumPerChunk;
    public int mangrovesPerChunk;
    public int lakesPerChunk;
    public float lavaPoolChance;
    private static final List<RuinEntry> ruinList = new ArrayList<RuinEntry>();

    public TFBiomeDecorator() {
        this.canopyPerChunk = TFConfig.performance.canopyCoverage;
        this.hasCanopy = true;
        this.alternateCanopyChance = 0.0f;
        this.myceliumPerChunk = 0;
        this.mangrovesPerChunk = 0;
        this.lakesPerChunk = 0;
        this.lavaPoolChance = 0.0f;
    }

    private static void addRuin(Supplier<TFGenerator> generator, int weight) {
        if (weight > 0) {
            ruinList.add(new RuinEntry(generator.get(), weight));
        }
    }

    public void func_180292_a(World world, Random rand, Biome biome, BlockPos pos) {
        TFFeature nearFeature = TFFeature.getNearestFeature(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, world);
        if (!nearFeature.areChunkDecorationsEnabled) {
            this.decorateUnderground(world, rand, pos);
            this.decorateOnlyOres(world, rand, pos);
        } else {
            super.func_180292_a(world, rand, biome, pos);
        }
    }

    protected void func_150513_a(Biome biome, World world, Random randomGenerator) {
        int rx;
        int i;
        int rz;
        int rx2;
        if (randomGenerator.nextInt(6) == 0) {
            rx2 = this.field_180294_c.func_177958_n() + randomGenerator.nextInt(14) + 8;
            rz = this.field_180294_c.func_177952_p() + randomGenerator.nextInt(14) + 8;
            TFGenerator rf = this.randomFeature(randomGenerator);
            if (rf != null) {
                rf.func_180709_b(world, randomGenerator, new BlockPos(rx2, world.func_189649_b(rx2, rz), rz));
            }
        }
        if (this.hasCanopy) {
            this.canopyPerChunk = TFConfig.performance.canopyCoverage;
            int nc = (int)this.canopyPerChunk + (randomGenerator.nextFloat() < this.canopyPerChunk - (float)((int)this.canopyPerChunk) ? 1 : 0);
            for (int i2 = 0; i2 < nc; ++i2) {
                int rx3 = this.field_180294_c.func_177958_n() + randomGenerator.nextInt(16) + 8;
                int rz2 = this.field_180294_c.func_177952_p() + randomGenerator.nextInt(16) + 8;
                BlockPos genPos = world.func_175645_m(new BlockPos(rx3, 0, rz2));
                if (this.alternateCanopyChance > 0.0f && randomGenerator.nextFloat() <= this.alternateCanopyChance) {
                    this.alternateCanopyGen.func_180709_b(world, randomGenerator, genPos);
                    continue;
                }
                this.canopyTreeGen.func_180709_b(world, randomGenerator, genPos);
            }
        }
        for (i = 0; i < this.mangrovesPerChunk; ++i) {
            rx = this.field_180294_c.func_177958_n() + randomGenerator.nextInt(16) + 8;
            int rz3 = this.field_180294_c.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.mangroveTreeGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz3)));
        }
        for (i = 0; i < this.lakesPerChunk; ++i) {
            rx = this.field_180294_c.func_177958_n() + randomGenerator.nextInt(16) + 8;
            int rz4 = this.field_180294_c.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.extraLakeGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz4)));
        }
        if (randomGenerator.nextFloat() <= this.lavaPoolChance) {
            rx2 = this.field_180294_c.func_177958_n() + randomGenerator.nextInt(16) + 8;
            rz = this.field_180294_c.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.extraLavaPoolGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx2, 0, rz)));
        }
        for (i = 0; i < this.myceliumPerChunk; ++i) {
            rx = this.field_180294_c.func_177958_n() + randomGenerator.nextInt(16) + 8;
            int rz5 = this.field_180294_c.func_177952_p() + randomGenerator.nextInt(16) + 8;
            this.myceliumBlobGen.func_180709_b(world, randomGenerator, world.func_175645_m(new BlockPos(rx, 0, rz5)));
        }
        super.func_150513_a(biome, world, randomGenerator);
        this.decorateUnderground(world, randomGenerator, this.field_180294_c);
    }

    protected void decorateUnderground(World world, Random rand, BlockPos pos) {
        int rz;
        int ry;
        int rx;
        int i;
        for (i = 0; i < 12; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            ry = 64;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            this.plantRootGen.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        for (i = 0; i < 20; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            ry = rand.nextInt(64);
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            this.woodRootGen.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        if (this.field_76808_K) {
            for (i = 0; i < 50; ++i) {
                rx = pos.func_177958_n() + rand.nextInt(16) + 8;
                ry = rand.nextInt(24) + 4;
                rz = pos.func_177952_p() + rand.nextInt(16) + 8;
                this.caveWaterGen.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
            }
        }
        for (i = 0; i < 3; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            ry = 64;
            rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            this.torchBerryGen.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
    }

    public void decorateOnlyOres(World world, Random rand, BlockPos pos) {
        this.field_180294_c = pos;
        if (this.field_180293_d == null) {
            this.field_180293_d = ChunkGeneratorSettings.Factory.func_177865_a((String)world.func_72912_H().func_82571_y()).func_177864_b();
            this.field_180294_c = pos;
            this.field_76823_i = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), this.field_180293_d.field_177789_I);
            this.field_76820_j = new WorldGenMinable(Blocks.field_150351_n.func_176223_P(), this.field_180293_d.field_177785_M);
            this.field_180296_j = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), this.field_180293_d.field_177796_Q);
            this.field_180297_k = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), this.field_180293_d.field_177792_U);
            this.field_180295_l = new WorldGenMinable(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), this.field_180293_d.field_177800_Y);
            this.field_76821_k = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), this.field_180293_d.field_177844_ac);
            this.field_76818_l = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), this.field_180293_d.field_177848_ag);
            this.field_76819_m = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), this.field_180293_d.field_177828_ak);
            this.field_180299_p = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), this.field_180293_d.field_177836_ao);
            this.field_180298_q = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), this.field_180293_d.field_177814_as);
            this.field_76831_p = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), this.field_180293_d.field_177822_aw);
        }
        this.func_76797_b(world, rand);
    }

    @Nullable
    public TFGenerator randomFeature(Random rand) {
        return ruinList.isEmpty() ? null : ((RuinEntry)WeightedRandom.func_76271_a((Random)rand, TFBiomeDecorator.ruinList)).generator;
    }

    public void setTreesPerChunk(int treesPerChunk) {
        this.field_76832_z = treesPerChunk;
    }

    public void setBigMushroomsPerChunk(int bigMushroomsPerChunk) {
        this.field_76807_J = bigMushroomsPerChunk;
    }

    public void setClayPerChunk(int clayPerChunk) {
        this.field_76806_I = clayPerChunk;
    }

    public void setDeadBushPerChunk(int deadBushPerChunk) {
        this.field_76804_C = deadBushPerChunk;
    }

    public void setMushroomsPerChunk(int mushroomsPerChunk) {
        this.field_76798_D = mushroomsPerChunk;
    }

    public void setFlowersPerChunk(int flowersPerChunk) {
        this.field_76802_A = flowersPerChunk;
    }

    public void setReedsPerChunk(int reedsPerChunk) {
        this.field_76799_E = reedsPerChunk;
    }

    public void setWaterlilyPerChunk(int waterlilyPerChunk) {
        this.field_76833_y = waterlilyPerChunk;
    }

    public void setGrassPerChunk(int grassPerChunk) {
        this.field_76803_B = grassPerChunk;
    }

    static {
        TFBiomeDecorator.addRuin(TFGenStoneCircle::new, TFConfig.dimension.worldGenWeights.stoneCircleWeight);
        TFBiomeDecorator.addRuin(TFGenWell::new, TFConfig.dimension.worldGenWeights.wellWeight);
        TFBiomeDecorator.addRuin(TFGenOutsideStalagmite::new, TFConfig.dimension.worldGenWeights.stalagmiteWeight);
        TFBiomeDecorator.addRuin(TFGenFoundation::new, TFConfig.dimension.worldGenWeights.foundationWeight);
        TFBiomeDecorator.addRuin(TFGenMonolith::new, TFConfig.dimension.worldGenWeights.monolithWeight);
        TFBiomeDecorator.addRuin(TFGenGroveRuins::new, TFConfig.dimension.worldGenWeights.groveRuinsWeight);
        TFBiomeDecorator.addRuin(TFGenHollowStump::new, TFConfig.dimension.worldGenWeights.hollowStumpWeight);
        TFBiomeDecorator.addRuin(TFGenFallenHollowLog::new, TFConfig.dimension.worldGenWeights.fallenHollowLogWeight);
        TFBiomeDecorator.addRuin(TFGenFallenSmallLog::new, TFConfig.dimension.worldGenWeights.fallenSmallLogWeight);
        TFBiomeDecorator.addRuin(GenDruidHut::new, TFConfig.dimension.worldGenWeights.druidHutWeight);
    }

    private static class RuinEntry
    extends WeightedRandom.Item {
        public final TFGenerator generator;

        RuinEntry(TFGenerator generator, int weight) {
            super(weight);
            this.generator = generator;
        }
    }
}

