/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.TFBlocks;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.item.TFItems;
import twilightforest.network.PacketAnnihilateBlock;
import twilightforest.network.TFPacketHandler;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;

public class BlockTFCastleDoor
extends Block
implements ModelRegisterCallback {
    public static final IProperty<Boolean> ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final IProperty<Integer> LOCK_INDEX = PropertyInteger.func_177719_a((String)"lock_index", (int)0, (int)3);
    private final boolean isVanished;
    private static final AxisAlignedBB REAPPEARING_BB = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);

    public BlockTFCastleDoor(boolean isVanished) {
        super(isVanished ? Material.field_151592_s : Material.field_151576_e, isVanished ? MapColor.field_151660_b : MapColor.field_151679_y);
        this.func_149711_c(100.0f);
        this.func_149752_b(35.0f);
        this.isVanished = isVanished;
        this.field_149786_r = isVanished ? 0 : 255;
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, LOCK_INDEX});
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b(LOCK_INDEX);
        return meta |= (Boolean)state.func_177229_b(ACTIVE) != false ? 8 : 0;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ACTIVE, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a(LOCK_INDEX, (Comparable)Integer.valueOf(meta & 3));
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return !this.isVanished;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return !this.isVanished;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return this.isVanished ? BlockFaceShape.UNDEFINED : super.func_193383_a(worldIn, state, pos, face);
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isVanished ? field_185506_k : super.func_180646_a(state, world, pos);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isVanished ? REAPPEARING_BB : super.func_185496_a(state, world, pos);
    }

    public boolean func_176205_b(IBlockAccess blockAccess, BlockPos pos) {
        return this.isVanished;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.onActivation(world, pos, state);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!(block instanceof BlockTFCastleDoor) && world.func_175640_z(pos)) {
            this.onActivation(world, pos, state);
        }
    }

    private boolean onActivation(World world, BlockPos pos, IBlockState state) {
        if (this.isVanished || ((Boolean)state.func_177229_b(ACTIVE)).booleanValue()) {
            return false;
        }
        if (BlockTFCastleDoor.isBlockLocked(world, pos)) {
            world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 1.0f, 0.3f);
        } else {
            BlockTFCastleDoor.changeToActiveBlock(world, pos, state);
        }
        return true;
    }

    private static void changeToActiveBlock(World world, BlockPos pos, IBlockState originState) {
        BlockTFCastleDoor.changeActiveState(world, pos, true, originState);
        BlockTFCastleDoor.playVanishSound(world, pos);
        world.func_175684_a(pos, originState.func_177230_c(), 2 + world.field_73012_v.nextInt(5));
    }

    private static void changeActiveState(World world, BlockPos pos, boolean active, IBlockState originState) {
        if (originState.func_177230_c() instanceof BlockTFCastleDoor) {
            world.func_180501_a(pos, originState.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            world.func_175704_b(pos, pos);
            world.func_175722_b(pos, originState.func_177230_c(), false);
        }
    }

    private static boolean isBlockLocked(World world, BlockPos pos) {
        if (!world.field_72995_K && TFWorld.getChunkGenerator(world) instanceof ChunkGeneratorTFBase) {
            ChunkGeneratorTFBase generator = (ChunkGeneratorTFBase)TFWorld.getChunkGenerator(world);
            return generator.isStructureLocked(pos, (Integer)world.func_180495_p(pos).func_177229_b(LOCK_INDEX));
        }
        return false;
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isVanished) {
            if (((Boolean)state.func_177229_b(ACTIVE)).booleanValue()) {
                world.func_175656_a(pos, TFBlocks.castle_door.func_176223_P().func_177226_a(LOCK_INDEX, state.func_177229_b(LOCK_INDEX)));
                BlockTFCastleDoor.playVanishSound(world, pos);
            } else {
                BlockTFCastleDoor.changeToActiveBlock(world, pos, state);
            }
        } else if (((Boolean)state.func_177229_b(ACTIVE)).booleanValue()) {
            world.func_175656_a(pos, BlockTFCastleDoor.getOtherBlock(this).func_176223_P().func_177226_a(LOCK_INDEX, state.func_177229_b(LOCK_INDEX)));
            world.func_175684_a(pos, BlockTFCastleDoor.getOtherBlock(this), 80);
            BlockTFCastleDoor.playReappearSound(world, pos);
            this.sendAnnihilateBlockPacket(world, pos);
            for (EnumFacing e : EnumFacing.field_82609_l) {
                BlockTFCastleDoor.checkAndActivateCastleDoor(world, pos.func_177972_a(e));
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return TFItems.castle_door;
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b(LOCK_INDEX);
    }

    private void sendAnnihilateBlockPacket(World world, BlockPos pos) {
        PacketAnnihilateBlock message = new PacketAnnihilateBlock(pos);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)message, targetPoint);
    }

    private static void playVanishSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.125f, world.field_73012_v.nextFloat() * 0.25f + 1.75f);
    }

    private static void playReappearSound(World world, BlockPos pos) {
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.125f, world.field_73012_v.nextFloat() * 0.25f + 1.25f);
    }

    private static Block getOtherBlock(Block block) {
        return block == TFBlocks.castle_door ? TFBlocks.castle_door_vanished : TFBlocks.castle_door;
    }

    public static void checkAndActivateCastleDoor(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == TFBlocks.castle_door && !((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && !BlockTFCastleDoor.isBlockLocked(world, pos)) {
            BlockTFCastleDoor.changeToActiveBlock(world, pos, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b(ACTIVE)).booleanValue()) {
            // empty if block
        }
        for (int i = 0; i < 1; ++i) {
        }
    }

    private void sparkle(World worldIn, BlockPos pos, Random rand) {
        Random random = rand;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + 0.0625 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - 0.0625;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + 0.0625 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - 0.0625;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + 0.0625 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - 0.0625;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isVanished ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !(blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof BlockTFCastleDoor) && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        if (this == TFBlocks.castle_door) {
            for (int i = 0; i < LOCK_INDEX.func_177700_c().size(); ++i) {
                list.add((Object)new ItemStack((Block)this, 1, i));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        if (!this.isVanished) {
            ModelUtils.registerToStateSingleVariant(this, LOCK_INDEX);
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(TFItems.castle_door, 1, this.func_180651_a(state));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(TFItems.castle_door, 1, this.func_180651_a(state));
    }
}

