/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.item.TFItems;

public abstract class BlockTFCritter
extends Block {
    private final float WIDTH = this.getWidth();
    private final AxisAlignedBB DOWN_BB = new AxisAlignedBB((double)(0.5f - this.WIDTH), (double)(1.0f - this.WIDTH * 2.0f), (double)0.2f, (double)(0.5f + this.WIDTH), 1.0, (double)0.8f);
    private final AxisAlignedBB UP_BB = new AxisAlignedBB((double)(0.5f - this.WIDTH), 0.0, (double)0.2f, (double)(0.5f + this.WIDTH), (double)(this.WIDTH * 2.0f), (double)0.8f);
    private final AxisAlignedBB NORTH_BB = new AxisAlignedBB((double)(0.5f - this.WIDTH), (double)0.2f, (double)(1.0f - this.WIDTH * 2.0f), (double)(0.5f + this.WIDTH), (double)0.8f, 1.0);
    private final AxisAlignedBB SOUTH_BB = new AxisAlignedBB((double)(0.5f - this.WIDTH), (double)0.2f, 0.0, (double)(0.5f + this.WIDTH), (double)0.8f, (double)(this.WIDTH * 2.0f));
    private final AxisAlignedBB WEST_BB = new AxisAlignedBB((double)(1.0f - this.WIDTH * 2.0f), (double)0.2f, (double)(0.5f - this.WIDTH), 1.0, (double)0.8f, (double)(0.5f + this.WIDTH));
    private final AxisAlignedBB EAST_BB = new AxisAlignedBB(0.0, (double)0.2f, (double)(0.5f - this.WIDTH), (double)(this.WIDTH * 2.0f), (double)0.8f, (double)(0.5f + this.WIDTH));

    protected BlockTFCritter() {
        super(Material.field_151594_q);
        this.func_149711_c(0.0f);
        this.func_149647_a(TFItems.creativeTab);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP));
    }

    public float getWidth() {
        return 0.15f;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176745_a();
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)) {
            case DOWN: {
                return this.DOWN_BB;
            }
            default: {
                return this.UP_BB;
            }
            case NORTH: {
                return this.NORTH_BB;
            }
            case SOUTH: {
                return this.SOUTH_BB;
            }
            case WEST: {
                return this.WEST_BB;
            }
            case EAST: 
        }
        return this.EAST_BB;
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing e : EnumFacing.field_82609_l) {
            if (!this.canPlaceAt(world, pos.func_177972_a(e))) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing sideHit, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P();
        if (this.canPlaceAt(world, pos.func_177972_a(sideHit.func_176734_d()))) {
            state = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)sideHit);
        }
        return state;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.checkAndDrop(world, pos, state);
    }

    protected boolean checkAndDrop(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        if (!this.canPlaceAt(world, pos.func_177972_a(facing.func_176734_d()))) {
            world.func_175655_b(pos, true);
            return false;
        }
        return true;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockID, BlockPos fromPos) {
        this.checkAndDrop(world, pos, state);
    }

    protected boolean canPlaceAt(World world, BlockPos pos) {
        return world.func_175677_d(pos, true) || world.func_180495_p(pos).func_185904_a() == Material.field_151584_j || world.func_180495_p(pos).func_185904_a() == Material.field_151570_A;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public abstract ItemStack getSquishResult();
}

