/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.BlockTFTowerTranslucent;
import twilightforest.block.TFBlocks;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.enums.TowerTranslucentVariant;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TileEntityTFAntibuilder;
import twilightforest.tileentity.TileEntityTFCReactorActive;
import twilightforest.tileentity.TileEntityTFGhastTrapActive;
import twilightforest.tileentity.TileEntityTFGhastTrapInactive;
import twilightforest.tileentity.TileEntityTFTowerBuilder;

public class BlockTFTowerDevice
extends Block
implements ModelRegisterCallback {
    public static final IProperty<TowerDeviceVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", TowerDeviceVariant.class);

    public BlockTFTowerDevice() {
        super(Material.field_151575_d, MapColor.field_151658_d);
        this.func_149711_c(10.0f);
        this.func_149752_b(35.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.values()[meta]));
    }

    public int func_149738_a(World world) {
        return 15;
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.REAPPEARING_INACTIVE.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.VANISH_INACTIVE.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.VANISH_LOCKED.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.VANISH_UNLOCKED.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.BUILDER_INACTIVE.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.ANTIBUILDER.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.GHASTTRAP_INACTIVE.ordinal()));
        list.add((Object)new ItemStack((Block)this, 1, TowerDeviceVariant.REACTOR_INACTIVE.ordinal()));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_INACTIVE) {
            if (BlockTFTowerDevice.areBlocksLocked((IBlockAccess)world, pos)) {
                world.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.VANISH_ACTIVE);
            }
            return true;
        }
        if (variant == TowerDeviceVariant.REAPPEARING_INACTIVE) {
            if (BlockTFTowerDevice.areBlocksLocked((IBlockAccess)world, pos)) {
                world.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 1.0f, 0.3f);
            } else {
                BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.REAPPEARING_ACTIVE);
            }
            return true;
        }
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        switch ((TowerDeviceVariant)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))) {
            case VANISH_INACTIVE: {
                return 6000.0f;
            }
            case VANISH_LOCKED: {
                return 6000000.0f;
            }
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case VANISH_INACTIVE: 
            case VANISH_LOCKED: 
            case REAPPEARING_ACTIVE: 
            case VANISH_ACTIVE: 
            case VANISH_UNLOCKED: {
                return -1.0f;
            }
        }
        return super.func_176195_g(state, world, pos);
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case VANISH_INACTIVE: {
                return !BlockTFTowerDevice.areBlocksLocked(world, pos);
            }
            case VANISH_LOCKED: {
                return false;
            }
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    private static boolean areBlocksLocked(IBlockAccess world, BlockPos pos) {
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(pos);
        return BlockTFTowerDevice.areBlocksLocked(world, pos, checked);
    }

    private static boolean areBlocksLocked(IBlockAccess world, BlockPos pos, Set<BlockPos> checked) {
        for (EnumFacing facing : EnumFacing.values()) {
            IBlockState state;
            BlockPos offset = pos.func_177972_a(facing);
            if (!checked.add(offset) || (state = world.func_180495_p(offset)).func_177230_c() != TFBlocks.tower_device) continue;
            if (state.func_177229_b(VARIANT) == TowerDeviceVariant.VANISH_LOCKED) {
                return true;
            }
            if (!BlockTFTowerDevice.areBlocksLocked(world, offset, checked)) continue;
            return true;
        }
        return false;
    }

    public static void unlockBlock(World world, BlockPos pos) {
        IBlockState thereState = world.func_180495_p(pos);
        if (thereState.func_177230_c() == TFBlocks.tower_device || thereState.func_177229_b(VARIANT) == TowerDeviceVariant.VANISH_LOCKED) {
            BlockTFTowerDevice.changeToBlockState(world, pos, thereState.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_UNLOCKED)));
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    private static void changeToBlockState(World world, BlockPos pos, IBlockState state) {
        Block thereBlock = world.func_180495_p(pos).func_177230_c();
        if (thereBlock == TFBlocks.tower_device || thereBlock == TFBlocks.tower_translucent) {
            world.func_180501_a(pos, state, 3);
            world.func_175704_b(pos, pos);
            world.func_175722_b(pos, thereBlock, false);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        if (state.func_177229_b(VARIANT) == TowerDeviceVariant.BUILDER_INACTIVE && world.func_175640_z(pos)) {
            BlockTFTowerDevice.changeToBlockState(world, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_INACTIVE && world.func_175640_z(pos) && !BlockTFTowerDevice.areBlocksLocked((IBlockAccess)world, pos)) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.VANISH_ACTIVE);
        }
        if (variant == TowerDeviceVariant.REAPPEARING_INACTIVE && world.func_175640_z(pos) && !BlockTFTowerDevice.areBlocksLocked((IBlockAccess)world, pos)) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.REAPPEARING_ACTIVE);
        }
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE && world.func_175640_z(pos)) {
            BlockTFTowerDevice.changeToBlockState(world, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_175684_a(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && !world.func_175640_z(pos)) {
            BlockTFTowerDevice.changeToBlockState(world, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
            world.func_184133_a(null, pos, SoundEvents.field_187883_gR, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_175684_a(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_TIMEOUT && !world.func_175640_z(pos)) {
            BlockTFTowerDevice.changeToBlockState(world, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
        }
        if (variant == TowerDeviceVariant.GHASTTRAP_INACTIVE && this.isInactiveTrapCharged(world, pos) && world.func_175640_z(pos)) {
            for (EntityPlayerMP player : world.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB(pos).func_186662_g(6.0))) {
                TFAdvancements.ACTIVATED_GHAST_TRAP.trigger(player);
            }
            BlockTFTowerDevice.changeToBlockState(world, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.GHASTTRAP_ACTIVE)));
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            world.func_175684_a(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.REACTOR_INACTIVE && this.isReactorReady(world, pos)) {
            BlockTFTowerDevice.changeToBlockState(world, pos, state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REACTOR_ACTIVE)));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        if (world.field_72995_K) {
            return;
        }
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_ACTIVE || variant == TowerDeviceVariant.REAPPEARING_ACTIVE) {
            if (variant == TowerDeviceVariant.VANISH_ACTIVE) {
                world.func_175698_g(pos);
            } else {
                world.func_175656_a(pos, TFBlocks.tower_translucent.func_176223_P().func_177226_a(BlockTFTowerTranslucent.VARIANT, (Comparable)((Object)TowerTranslucentVariant.REAPPEARING_INACTIVE)));
                world.func_175684_a(pos, TFBlocks.tower_translucent, 80);
            }
            world.func_175722_b(pos, (Block)this, false);
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.3f, 0.5f);
            for (EnumFacing e : EnumFacing.field_82609_l) {
                BlockTFTowerDevice.checkAndActivateVanishBlock(world, pos.func_177972_a(e));
            }
        }
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && world.func_175640_z(pos)) {
            this.letsBuild(world, pos);
        }
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE || variant == TowerDeviceVariant.BUILDER_TIMEOUT) {
            for (EnumFacing e : EnumFacing.field_82609_l) {
                BlockTFTowerDevice.checkAndActivateVanishBlock(world, pos.func_177972_a(e));
            }
        }
    }

    private void letsBuild(World world, BlockPos pos) {
        TileEntityTFTowerBuilder tileEntity = (TileEntityTFTowerBuilder)world.func_175625_s(pos);
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    private boolean isInactiveTrapCharged(World world, BlockPos pos) {
        TileEntityTFGhastTrapInactive tileEntity = (TileEntityTFGhastTrapInactive)world.func_175625_s(pos);
        return tileEntity != null && tileEntity.isCharged();
    }

    private boolean isReactorReady(World world, BlockPos pos) {
        return Arrays.stream(EnumFacing.field_82609_l).allMatch(e -> world.func_180495_p(pos.func_177972_a(e)).func_177230_c() == Blocks.field_150451_bX);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.func_177229_b(VARIANT));
        if (variant == TowerDeviceVariant.VANISH_ACTIVE || variant == TowerDeviceVariant.REAPPEARING_ACTIVE || variant == TowerDeviceVariant.BUILDER_ACTIVE) {
            this.sparkle(world, pos);
        }
    }

    public void sparkle(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.func_177958_n() + random.nextFloat();
            double d2 = (float)pos.func_177956_o() + random.nextFloat();
            double d3 = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                d2 = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !worldIn.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                d3 = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !worldIn.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                d1 = (double)pos.func_177958_n() - d0;
            }
            if (!(d1 < (double)pos.func_177958_n() || d1 > (double)(pos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(pos.func_177956_o() + 1) || d3 < (double)pos.func_177952_p()) && !(d3 > (double)(pos.func_177952_p() + 1))) continue;
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static void checkAndActivateVanishBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block != TFBlocks.tower_device || state.func_177229_b(VARIANT) != TowerDeviceVariant.VANISH_INACTIVE && state.func_177229_b(VARIANT) != TowerDeviceVariant.VANISH_UNLOCKED || BlockTFTowerDevice.areBlocksLocked((IBlockAccess)world, pos))) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.VANISH_ACTIVE);
        } else if (block == TFBlocks.tower_device && state.func_177229_b(VARIANT) == TowerDeviceVariant.REAPPEARING_INACTIVE && !BlockTFTowerDevice.areBlocksLocked((IBlockAccess)world, pos)) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerDeviceVariant.REAPPEARING_ACTIVE);
        } else if (block == TFBlocks.tower_translucent && state.func_177229_b(BlockTFTowerTranslucent.VARIANT) == TowerTranslucentVariant.BUILT_INACTIVE) {
            BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TowerTranslucentVariant.BUILT_ACTIVE);
        }
    }

    public static void changeToActiveVanishBlock(World world, BlockPos pos, TowerDeviceVariant variant) {
        BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TFBlocks.tower_device.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant)));
    }

    public static void changeToActiveVanishBlock(World world, BlockPos pos, TowerTranslucentVariant variant) {
        BlockTFTowerDevice.changeToActiveVanishBlock(world, pos, TFBlocks.tower_translucent.func_176223_P().func_177226_a(BlockTFTowerTranslucent.VARIANT, (Comparable)((Object)variant)));
    }

    private static void changeToActiveVanishBlock(World world, BlockPos pos, IBlockState state) {
        BlockTFTowerDevice.changeToBlockState(world, pos, state);
        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.3f, 0.6f);
        world.func_175684_a(pos, state.func_177230_c(), BlockTFTowerDevice.getTickRateFor(state, world.field_73012_v));
    }

    private static int getTickRateFor(IBlockState state, Random rand) {
        if (state.func_177230_c() == TFBlocks.tower_device && (state.func_177229_b(VARIANT) == TowerDeviceVariant.VANISH_ACTIVE || state.func_177229_b(VARIANT) == TowerDeviceVariant.REAPPEARING_ACTIVE)) {
            return 2 + rand.nextInt(5);
        }
        if (state.func_177230_c() == TFBlocks.tower_translucent && state.func_177229_b(BlockTFTowerTranslucent.VARIANT) == TowerTranslucentVariant.BUILT_ACTIVE) {
            return 10;
        }
        return 15;
    }

    public int func_149750_m(IBlockState state) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_ACTIVE: 
            case VANISH_ACTIVE: 
            case BUILDER_ACTIVE: {
                return 4;
            }
            case ANTIBUILDER: {
                return 10;
            }
            case GHASTTRAP_ACTIVE: 
            case REACTOR_ACTIVE: {
                return 15;
            }
        }
        return 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case BUILDER_ACTIVE: 
            case ANTIBUILDER: 
            case GHASTTRAP_ACTIVE: 
            case REACTOR_ACTIVE: 
            case GHASTTRAP_INACTIVE: {
                return true;
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case BUILDER_ACTIVE: {
                return new TileEntityTFTowerBuilder();
            }
            case ANTIBUILDER: {
                return new TileEntityTFAntibuilder();
            }
            case GHASTTRAP_INACTIVE: {
                return new TileEntityTFGhastTrapInactive();
            }
            case GHASTTRAP_ACTIVE: {
                return new TileEntityTFGhastTrapActive();
            }
            case REACTOR_ACTIVE: {
                return new TileEntityTFCReactorActive();
            }
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case ANTIBUILDER: {
                return Items.field_190931_a;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    @Deprecated
    protected boolean func_149700_E() {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        switch ((TowerDeviceVariant)((Object)state.func_177229_b(VARIANT))) {
            case REAPPEARING_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE));
                break;
            }
            case BUILDER_ACTIVE: 
            case BUILDER_TIMEOUT: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE));
                break;
            }
            case VANISH_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_INACTIVE));
                break;
            }
            case GHASTTRAP_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.GHASTTRAP_INACTIVE));
                break;
            }
            case REACTOR_ACTIVE: {
                state = state.func_177226_a(VARIANT, (Comparable)((Object)TowerDeviceVariant.REACTOR_INACTIVE));
                break;
            }
        }
        return this.func_176201_c(state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelUtils.registerToStateSingleVariant(this, VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

