/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.block.BlockTF;
import twilightforest.block.BlockTFAuroraBrick;
import twilightforest.block.BlockTFAuroraPillar;
import twilightforest.block.BlockTFAuroraSlab;
import twilightforest.block.BlockTFAuroralizedGlass;
import twilightforest.block.BlockTFBossSpawner;
import twilightforest.block.BlockTFBurntThorns;
import twilightforest.block.BlockTFButtonWood;
import twilightforest.block.BlockTFCastleBlock;
import twilightforest.block.BlockTFCastleDoor;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.BlockTFCastlePillar;
import twilightforest.block.BlockTFCastleStairs;
import twilightforest.block.BlockTFCastleUnlock;
import twilightforest.block.BlockTFCicada;
import twilightforest.block.BlockTFCinderFurnace;
import twilightforest.block.BlockTFCinderLog;
import twilightforest.block.BlockTFCompressed;
import twilightforest.block.BlockTFDarkLeaves;
import twilightforest.block.BlockTFDeadrock;
import twilightforest.block.BlockTFDiagonal;
import twilightforest.block.BlockTFDoor;
import twilightforest.block.BlockTFExperiment115;
import twilightforest.block.BlockTFFence;
import twilightforest.block.BlockTFFenceGate;
import twilightforest.block.BlockTFFireJet;
import twilightforest.block.BlockTFFirefly;
import twilightforest.block.BlockTFFireflyJar;
import twilightforest.block.BlockTFFluffyCloud;
import twilightforest.block.BlockTFFluid;
import twilightforest.block.BlockTFForceField;
import twilightforest.block.BlockTFGiantCobble;
import twilightforest.block.BlockTFGiantLeaves;
import twilightforest.block.BlockTFGiantLog;
import twilightforest.block.BlockTFGiantObsidian;
import twilightforest.block.BlockTFHedge;
import twilightforest.block.BlockTFHorizontal;
import twilightforest.block.BlockTFHugeGloomBlock;
import twilightforest.block.BlockTFHugeLilyPad;
import twilightforest.block.BlockTFHugeStalk;
import twilightforest.block.BlockTFHugeWaterLily;
import twilightforest.block.BlockTFKnightmetalBlock;
import twilightforest.block.BlockTFLadderBars;
import twilightforest.block.BlockTFLapisBlock;
import twilightforest.block.BlockTFLeaves;
import twilightforest.block.BlockTFLeaves3;
import twilightforest.block.BlockTFLog;
import twilightforest.block.BlockTFMagicLeaves;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.BlockTFMagicLogSpecial;
import twilightforest.block.BlockTFMazestone;
import twilightforest.block.BlockTFMergedPillar;
import twilightforest.block.BlockTFMiniatureStructure;
import twilightforest.block.BlockTFMoonworm;
import twilightforest.block.BlockTFNagastone;
import twilightforest.block.BlockTFNagastoneEtched;
import twilightforest.block.BlockTFNagastonePillar;
import twilightforest.block.BlockTFNagastoneStairs;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.BlockTFPortal;
import twilightforest.block.BlockTFPressurePlate;
import twilightforest.block.BlockTFRipeTorchCluster;
import twilightforest.block.BlockTFRoots;
import twilightforest.block.BlockTFSapling;
import twilightforest.block.BlockTFShield;
import twilightforest.block.BlockTFSlab;
import twilightforest.block.BlockTFSlider;
import twilightforest.block.BlockTFSpiralBrick;
import twilightforest.block.BlockTFStairs;
import twilightforest.block.BlockTFThornRose;
import twilightforest.block.BlockTFThorns;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.BlockTFTowerTranslucent;
import twilightforest.block.BlockTFTowerWood;
import twilightforest.block.BlockTFTrapDoor;
import twilightforest.block.BlockTFTrollRoot;
import twilightforest.block.BlockTFTrollSteinn;
import twilightforest.block.BlockTFTrophy;
import twilightforest.block.BlockTFTrophyPedestal;
import twilightforest.block.BlockTFUberousSoil;
import twilightforest.block.BlockTFUncraftingTable;
import twilightforest.block.BlockTFUnderBrick;
import twilightforest.block.BlockTFUnripeTorchCluster;
import twilightforest.block.BlockTFWispyCloud;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.enums.CastleBrickVariant;
import twilightforest.enums.MagicWoodVariant;
import twilightforest.enums.WoodVariant;
import twilightforest.item.TFItems;
import twilightforest.util.IMapColorSupplier;

@Mod.EventBusSubscriber(modid="twilightforest")
public final class RegisterBlockEvent {
    public static final Fluid moltenFiery;
    public static final Fluid moltenKnightmetal;
    public static final Fluid essenceFiery;
    public static final ResourceLocation moltenFieryStill;
    public static final ResourceLocation moltenFieryFlow;
    public static final ResourceLocation moltenKnightmetalStill;
    public static final ResourceLocation moltenKnightmetalFlow;
    public static final ResourceLocation essenceFieryStill;
    public static final ResourceLocation essenceFieryFlow;

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        BlockRegistryHelper blocks = new BlockRegistryHelper((IForgeRegistry<Block>)event.getRegistry());
        blocks.register("twilight_log", "Log", new BlockTFLog());
        blocks.register("root", "Roots", new BlockTFRoots());
        blocks.register("twilight_leaves", "Leaves", new BlockTFLeaves());
        blocks.register("firefly", "Firefly", new BlockTFFirefly());
        blocks.register("cicada", "Cicada", new BlockTFCicada());
        blocks.register("twilight_portal", "Portal", new BlockTFPortal());
        blocks.register("maze_stone", "Mazestone", new BlockTFMazestone());
        blocks.register("hedge", "Hedge", new BlockTFHedge());
        blocks.register("boss_spawner", "BossSpawner", new BlockTFBossSpawner().func_149722_s());
        blocks.register("firefly_jar", "FireflyJar", new BlockTFFireflyJar());
        blocks.register("twilight_plant", "Plant", new BlockTFPlant());
        blocks.register("uncrafting_table", "UncraftingTable", new BlockTFUncraftingTable());
        blocks.register("fire_jet", "FireJet", new BlockTFFireJet());
        blocks.register("naga_stone", "Nagastone", new BlockTFNagastone());
        blocks.register("twilight_sapling", "Sapling", new BlockTFSapling());
        blocks.register("moonworm", "Moonworm", new BlockTFMoonworm());
        blocks.register("magic_log", "MagicLog", new BlockTFMagicLog());
        blocks.register("magic_leaves", "MagicLeaves", new BlockTFMagicLeaves());
        blocks.register("magic_log_core", "MagicLogSpecial", new BlockTFMagicLogSpecial());
        blocks.register("tower_wood", "TowerStone", new BlockTFTowerWood());
        blocks.register("tower_device", "TowerDevice", new BlockTFTowerDevice());
        blocks.register("tower_translucent", "TowerTranslucent", new BlockTFTowerTranslucent());
        blocks.register("trophy", "Trophy", new BlockTFTrophy());
        blocks.register("stronghold_shield", "Shield", new BlockTFShield());
        blocks.register("trophy_pedestal", "TrophyPedestal", new BlockTFTrophyPedestal());
        blocks.register("aurora_block", "AuroraBrick", new BlockTFAuroraBrick());
        blocks.register("underbrick", "UnderBrick", new BlockTFUnderBrick());
        blocks.register("thorns", "Thorns", new BlockTFThorns());
        blocks.register("burnt_thorns", "BurntThorns", new BlockTFBurntThorns());
        blocks.register("thorn_rose", "ThornRose", new BlockTFThornRose());
        blocks.register("twilight_leaves_3", "Leaves3", new BlockTFLeaves3());
        blocks.register("deadrock", "Deadrock", new BlockTFDeadrock());
        blocks.register("dark_leaves", "DarkLeaves", new BlockTFDarkLeaves());
        blocks.register("aurora_pillar", "AuroraPillar", new BlockTFAuroraPillar());
        blocks.register("aurora_slab", "AuroraSlab", new BlockTFAuroraSlab(false));
        blocks.register("double_aurora_slab", "AuroraDoubleSlab", new BlockTFAuroraSlab(true));
        blocks.register("trollsteinn", "TrollSteinn", new BlockTFTrollSteinn());
        blocks.register("wispy_cloud", "WispyCloud", new BlockTFWispyCloud());
        blocks.register("fluffy_cloud", "FluffyCloud", new BlockTFFluffyCloud());
        blocks.register("giant_cobblestone", "GiantCobble", new BlockTFGiantCobble());
        blocks.register("giant_log", "GiantLog", new BlockTFGiantLog());
        blocks.register("giant_leaves", "GiantLeaves", new BlockTFGiantLeaves());
        blocks.register("giant_obsidian", "GiantObsidian", new BlockTFGiantObsidian());
        blocks.register("uberous_soil", "UberousSoil", new BlockTFUberousSoil());
        blocks.register("huge_stalk", "HugeStalk", new BlockTFHugeStalk());
        blocks.register("huge_mushgloom", "HugeGloomBlock", new BlockTFHugeGloomBlock());
        blocks.register("trollvidr", "TrollVidr", new BlockTFTrollRoot());
        blocks.register("unripe_trollber", "UnripeTrollBer", new BlockTFUnripeTorchCluster());
        blocks.register("trollber", "TrollBer", new BlockTFRipeTorchCluster());
        blocks.register("knightmetal_block", "KnightmetalBlock", new BlockTFKnightmetalBlock());
        blocks.register("huge_lilypad", "HugeLilyPad", new BlockTFHugeLilyPad());
        blocks.register("huge_waterlily", "HugeWaterLily", new BlockTFHugeWaterLily());
        blocks.register("slider", "Slider", new BlockTFSlider());
        BlockTFCastleBlock castleBrick = new BlockTFCastleBlock();
        IBlockState castleState = castleBrick.func_176223_P();
        blocks.register("castle_brick", "CastleBrick", castleBrick);
        blocks.register("castle_stairs_brick", "CastleStairsBrick", new BlockTFStairs(castleState));
        blocks.register("castle_stairs_worn", "CastleStairsWorn", new BlockTFStairs(castleState.func_177226_a(BlockTFCastleBlock.VARIANT, (Comparable)((Object)CastleBrickVariant.WORN))));
        blocks.register("castle_stairs_cracked", "CastleStairsCracked", new BlockTFStairs(castleState.func_177226_a(BlockTFCastleBlock.VARIANT, (Comparable)((Object)CastleBrickVariant.CRACKED))));
        blocks.register("castle_stairs_mossy", "CastleStairsMossy", new BlockTFStairs(castleState.func_177226_a(BlockTFCastleBlock.VARIANT, (Comparable)((Object)CastleBrickVariant.MOSSY))));
        BlockTFCastlePillar castlePillar = new BlockTFCastlePillar();
        blocks.register("castle_pillar", "CastlePillar", castlePillar);
        blocks.register("castle_stairs", "CastleStairs", new BlockTFCastleStairs(castlePillar.func_176223_P()));
        blocks.register("castle_rune_brick", "CastleMagic", new BlockTFCastleMagic());
        blocks.register("force_field", "ForceField", new BlockTFForceField());
        blocks.register("cinder_furnace", "CinderFurnaceIdle", new BlockTFCinderFurnace(false));
        blocks.register("cinder_furnace_lit", "CinderFurnaceLit", new BlockTFCinderFurnace(true));
        blocks.register("cinder_log", "CinderLog", new BlockTFCinderLog());
        blocks.register("castle_door", "CastleDoor", new BlockTFCastleDoor(false));
        blocks.register("castle_door_vanished", "CastleDoorVanished", new BlockTFCastleDoor(true));
        blocks.register("castle_unlock", "CastleUnlock", new BlockTFCastleUnlock());
        blocks.register("experiment_115", "experiment115", new BlockTFExperiment115().func_149711_c(0.5f));
        blocks.register("miniature_structure", "MiniatureStructure", new BlockTFMiniatureStructure().func_149711_c(0.75f));
        blocks.register("block_storage", "BlockOfStorage", new BlockTFCompressed());
        blocks.register("lapis_block", "BlockOfLapisTF", new BlockTFLapisBlock());
        blocks.register("spiral_bricks", "SpiralBricks", new BlockTFSpiralBrick());
        Block etchedNagastone = new BlockTFNagastoneEtched().func_149711_c(1.5f).func_149752_b(10.0f);
        blocks.register("etched_nagastone", "EtchedNagastone", etchedNagastone);
        blocks.register("nagastone_stairs", "NagastoneStairs", new BlockTFNagastoneStairs(etchedNagastone.func_176223_P()).func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("nagastone_pillar", "NagastonePillar", new BlockTFNagastonePillar().func_149711_c(1.5f).func_149752_b(10.0f));
        Block etchedNagastoneMossy = new BlockTFNagastoneEtched().func_149711_c(1.5f).func_149752_b(10.0f);
        blocks.register("etched_nagastone_mossy", "EtchedNagastoneMossy", etchedNagastoneMossy);
        blocks.register("nagastone_stairs_mossy", "NagastoneStairsMossy", new BlockTFNagastoneStairs(etchedNagastoneMossy.func_176223_P()).func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("nagastone_pillar_mossy", "NagastonePillarMossy", new BlockTFNagastonePillar().func_149711_c(1.5f).func_149752_b(10.0f));
        Block etchedNagastoneWeathered = new BlockTFNagastoneEtched().func_149711_c(1.5f).func_149752_b(10.0f);
        blocks.register("etched_nagastone_weathered", "EtchedNagastoneWeathered", etchedNagastoneWeathered);
        blocks.register("nagastone_stairs_weathered", "NagastoneStairsWeathered", new BlockTFNagastoneStairs(etchedNagastoneWeathered.func_176223_P()).func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("nagastone_pillar_weathered", "NagastonePillarWeathered", new BlockTFNagastonePillar().func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("auroralized_glass", "AuroralizedGlass", new BlockTFAuroralizedGlass());
        blocks.register("iron_ladder", "IronLadder", new BlockTFLadderBars().func_149672_a(SoundType.field_185852_e).func_149711_c(5.0f).func_149752_b(10.0f));
        RegisterBlockEvent.registerWoodVariants((BlockRegistryHelper)blocks, BlockTFLog.VARIANT, (Enum[])WoodVariant.values());
        RegisterBlockEvent.registerWoodVariants((BlockRegistryHelper)blocks, BlockTFMagicLog.VARIANT, (Enum[])MagicWoodVariant.values());
        blocks.register("terrorcotta_circle", "TerrorCottaCircle", new BlockTFHorizontal(Material.field_151576_e, MapColor.field_151658_d).func_149672_a(SoundType.field_185851_d).func_149711_c(1.7f));
        blocks.register("terrorcotta_diagonal", "TerrorCottaDiagonal", new BlockTFDiagonal(Material.field_151576_e, MapColor.field_151658_d).func_149672_a(SoundType.field_185851_d).func_149711_c(1.7f));
        blocks.register("stone_twist", "StonePillar", new BlockRotatedPillar(Material.field_151576_e){}.func_149711_c(1.5f).func_149752_b(10.0f));
        blocks.register("stone_twist_thin", "StonePillarThin", new BlockTFMergedPillar(Material.field_151576_e, 12.0, 16.0).func_149711_c(1.5f).func_149752_b(10.0f));
        RegisterBlockEvent.registerFluidBlock(blocks, moltenFiery);
        RegisterBlockEvent.registerFluidBlock(blocks, moltenKnightmetal);
        RegisterBlockEvent.registerFluidBlock("fiery_essence", blocks, essenceFiery);
    }

    private static <T extends Enum<T> & IMapColorSupplier> void registerWoodVariants(BlockRegistryHelper blocks, IProperty<T> key, T[] types) {
        for (Object woodType : types) {
            String woodNameCapitalized;
            String woodName = ((IStringSerializable)woodType).func_176610_l();
            if ("oak".equals(woodName)) {
                woodName = "twilight_oak";
                woodNameCapitalized = "TwilightOak";
            } else {
                woodNameCapitalized = woodName.substring(0, 1).toUpperCase() + woodName.substring(1);
            }
            String inventory = "inventory";
            final IProperty[] noProperty = new IProperty[]{};
            final PropertyEnum restrictedKey = PropertyEnum.func_177708_a((String)"variant", (Class)key.func_177699_b(), input -> input == woodType);
            Block planks = blocks.register(woodName + "_planks", woodNameCapitalized + "Planks", new BlockTF(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor()){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", noProperty);
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(2.0f).func_149752_b(5.0f);
            blocks.register(woodName + "_stairs", woodNameCapitalized + "Stairs", new BlockTFStairs(planks.func_176223_P()){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", noProperty);
                }
            });
            final Block singleSlab = blocks.register(woodName + "_slab", woodNameCapitalized + "Slab", new BlockTFSlab<T>(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor(), (Enum)woodType){

                @Override
                public boolean func_176552_j() {
                    return false;
                }

                @Override
                protected Block getSingle() {
                    return this;
                }

                @Override
                public IProperty<T> func_176551_l() {
                    return restrictedKey;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", new IProperty[]{restrictedKey});
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(2.0f).func_149752_b(5.0f);
            blocks.register(woodName + "_doubleslab", woodNameCapitalized + "Slab", new BlockTFSlab<T>(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor(), (Enum)woodType){

                @Override
                public boolean func_176552_j() {
                    return true;
                }

                @Override
                protected Block getSingle() {
                    return singleSlab;
                }

                @Override
                public IProperty<T> func_176551_l() {
                    return restrictedKey;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", new IProperty[]{restrictedKey});
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(2.0f).func_149752_b(5.0f);
            blocks.register(woodName + "_button", woodNameCapitalized + "Button", new BlockTFButtonWood(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", noProperty);
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(0.5f);
            blocks.register(woodName + "_door", woodNameCapitalized + "Door", new BlockTFDoor(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor(), new ResourceLocation("twilightforest", woodName + "_door")){
                {
                    this.func_149672_a(SoundType.field_185848_a);
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", new IProperty[]{BlockTFDoor.field_176522_N});
                }
            }).func_149711_c(3.0f);
            blocks.register(woodName + "_trapdoor", woodNameCapitalized + "TrapDoor", new BlockTFTrapDoor(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor()){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", noProperty);
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(3.0f);
            blocks.register(woodName + "_fence", woodNameCapitalized + "Fence", new BlockTFFence(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor()){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", noProperty);
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(2.0f).func_149752_b(5.0f);
            blocks.register(woodName + "_gate", woodNameCapitalized + "Gate", new BlockTFFenceGate(((IMapColorSupplier)woodType).supplyPlankColor()){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", new IProperty[]{BlockFenceGate.field_176465_b});
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(2.0f).func_149752_b(5.0f);
            blocks.register(woodName + "_plate", woodNameCapitalized + "Plate", new BlockTFPressurePlate(Material.field_151575_d, ((IMapColorSupplier)woodType).supplyMapColor(), BlockPressurePlate.Sensitivity.EVERYTHING){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void registerModel() {
                    ModelUtils.registerIncludingItemModels((Block)this, "inventory", noProperty);
                }
            }).func_149672_a(SoundType.field_185848_a).func_149711_c(0.5f);
        }
    }

    public static List<ModelRegisterCallback> getBlockModels() {
        return ImmutableList.copyOf((Collection)BlockRegistryHelper.blockModels);
    }

    private static Fluid registerFluid(Fluid fluid) {
        fluid.setUnlocalizedName(fluid.getName());
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        return fluid;
    }

    private static void registerFluidBlock(BlockRegistryHelper blocks, Fluid fluid) {
        RegisterBlockEvent.registerFluidBlock("molten_" + fluid.getName(), blocks, fluid);
    }

    private static void registerFluidBlock(String registryName, BlockRegistryHelper blocks, Fluid fluid) {
        Block block = new BlockTFFluid(fluid, Material.field_151587_i).func_149663_c("twilightforest." + fluid.getName()).func_149715_a(1.0f);
        blocks.register(registryName, block);
    }

    static {
        moltenFieryStill = new ResourceLocation("twilightforest", "blocks/molten_fiery_still");
        moltenFieryFlow = new ResourceLocation("twilightforest", "blocks/molten_fiery_flow");
        moltenKnightmetalStill = new ResourceLocation("twilightforest", "blocks/molten_knightmetal_still");
        moltenKnightmetalFlow = new ResourceLocation("twilightforest", "blocks/molten_knightmetal_flow");
        essenceFieryStill = new ResourceLocation("twilightforest", "blocks/fluid_fiery_still");
        essenceFieryFlow = new ResourceLocation("twilightforest", "blocks/fluid_fiery_flow");
        moltenFiery = RegisterBlockEvent.registerFluid(new Fluid("fierymetal", moltenFieryStill, moltenFieryFlow).setTemperature(1000).setLuminosity(15));
        moltenKnightmetal = RegisterBlockEvent.registerFluid(new Fluid("knightmetal", moltenKnightmetalStill, moltenKnightmetalFlow).setTemperature(1000).setLuminosity(15));
        essenceFiery = RegisterBlockEvent.registerFluid(new Fluid("fiery_essence", essenceFieryStill, essenceFieryFlow).setTemperature(1000));
    }

    private static class BlockRegistryHelper {
        private final IForgeRegistry<Block> registry;
        private static List<ModelRegisterCallback> blockModels = new ArrayList<ModelRegisterCallback>();

        BlockRegistryHelper(IForgeRegistry<Block> registry) {
            this.registry = registry;
        }

        <T extends Block> T register(String registryName, String translationKey, T block) {
            block.func_149663_c("twilightforest." + translationKey);
            this.register(registryName, block);
            return block;
        }

        <T extends Block> T register(String registryName, T block) {
            block.setRegistryName("twilightforest", registryName);
            if (block instanceof ModelRegisterCallback) {
                blockModels.add((ModelRegisterCallback)block);
            }
            block.func_149647_a((CreativeTabs)TFItems.creativeTab);
            this.registry.register(block);
            return block;
        }
    }
}

