/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFConfig;
import twilightforest.TFEventListener;
import twilightforest.block.RegisterBlockEvent;
import twilightforest.block.TFBlocks;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.RenderEffect;
import twilightforest.client.texture.GradientMappedTexture;
import twilightforest.client.texture.GradientNode;
import twilightforest.client.texture.MoltenFieryTexture;
import twilightforest.compat.TFCompat;
import twilightforest.compat.ie.IEShaderRegister;
import twilightforest.item.ItemTFBowBase;
import twilightforest.world.WorldProviderTwilightForest;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="twilightforest", value={Side.CLIENT})
public class TFClientEvents {
    public static final GradientNode[] KNIGHTMETAL_GRADIENT_MAP = new GradientNode[]{new GradientNode(0.0f, -13422030), new GradientNode(0.1f, -9800866), new GradientNode(0.15f, -8352654), new GradientNode(0.3f, -6048879), new GradientNode(0.6f, -3877202), new GradientNode(1.0f, -1573683)};
    public static final GradientNode[] FIERY_ESSENCE_GRADIENT_MAP = new GradientNode[]{new GradientNode(0.2f, -12773609), new GradientNode(0.8f, -10745077)};
    public static final GradientNode[] EASY_GRAYSCALING_MAP = new GradientNode[]{new GradientNode(0.0f, -8355712), new GradientNode(0.5f, -5592406), new GradientNode(1.0f, -1)};
    private static final boolean shouldUpdateFOV = ((ModContainer)Loader.instance().getIndexedModList().get("forge")).getProcessedVersion().compareTo((Object)new DefaultArtifactVersion("14.23.5.2813")) < 0;
    public static int time = 0;
    private static int rotationTickerI = 0;
    private static int sineTickerI = 0;
    public static float rotationTicker = 0.0f;
    public static float sineTicker = 0.0f;
    public static final float PI = (float)Math.PI;
    private static final int SINE_TICKER_BOUND = 627;

    @SubscribeEvent
    public static void texStitch(TextureStitchEvent.Pre evt) {
        TextureMap map = evt.getMap();
        map.func_174942_a(new ResourceLocation("twilightforest", "particles/snow_0"));
        map.func_174942_a(new ResourceLocation("twilightforest", "particles/snow_1"));
        map.func_174942_a(new ResourceLocation("twilightforest", "particles/snow_2"));
        map.func_174942_a(new ResourceLocation("twilightforest", "particles/snow_3"));
        map.func_174942_a(new ResourceLocation("twilightforest", "particles/annihilate_particle"));
        map.func_174942_a(new ResourceLocation("twilightforest", "particles/firefly"));
        map.setTextureEntry((TextureAtlasSprite)new MoltenFieryTexture(new ResourceLocation("minecraft", "blocks/lava_still"), RegisterBlockEvent.moltenFieryStill));
        map.setTextureEntry((TextureAtlasSprite)new MoltenFieryTexture(new ResourceLocation("minecraft", "blocks/lava_flow"), RegisterBlockEvent.moltenFieryFlow));
        map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("minecraft", "blocks/lava_still"), RegisterBlockEvent.moltenKnightmetalStill, true, KNIGHTMETAL_GRADIENT_MAP));
        map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("minecraft", "blocks/lava_flow"), RegisterBlockEvent.moltenKnightmetalFlow, true, KNIGHTMETAL_GRADIENT_MAP));
        map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("minecraft", "blocks/water_still"), RegisterBlockEvent.essenceFieryStill, true, FIERY_ESSENCE_GRADIENT_MAP));
        map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("minecraft", "blocks/water_flow"), RegisterBlockEvent.essenceFieryFlow, true, FIERY_ESSENCE_GRADIENT_MAP));
        if (TFCompat.IMMERSIVEENGINEERING.isActivated()) {
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "revolvers/shaders/revolver_grip"), IEShaderRegister.PROCESSED_REVOLVER_GRIP_LAYER, true, EASY_GRAYSCALING_MAP));
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "revolvers/shaders/revolver_0"), IEShaderRegister.PROCESSED_REVOLVER_LAYER, true, EASY_GRAYSCALING_MAP));
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "items/shaders/chemthrower_0"), IEShaderRegister.PROCESSED_CHEMTHROW_LAYER, true, EASY_GRAYSCALING_MAP));
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "items/shaders/drill_diesel_0"), IEShaderRegister.PROCESSED_DRILL_LAYER, true, EASY_GRAYSCALING_MAP));
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "items/shaders/railgun_0"), IEShaderRegister.PROCESSED_RAILGUN_LAYER, true, EASY_GRAYSCALING_MAP));
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "items/shaders/shield_0"), IEShaderRegister.PROCESSED_SHIELD_LAYER, true, EASY_GRAYSCALING_MAP));
            map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation("immersiveengineering", "blocks/shaders/balloon_0"), IEShaderRegister.PROCESSED_BALLOON_LAYER, true, EASY_GRAYSCALING_MAP));
            String[] types = new String[]{"1_0", "1_2", "1_4", "1_5", "1_6"};
            for (IEShaderRegister.CaseType caseType : IEShaderRegister.CaseType.everythingButMinecart()) {
                for (String type : types) {
                    map.setTextureEntry((TextureAtlasSprite)new GradientMappedTexture(new ResourceLocation(IEShaderRegister.ModType.IMMERSIVEENGINEERING.provideTex(caseType, type)), new ResourceLocation(IEShaderRegister.ModType.TWILIGHTFOREST.provideTex(caseType, type)), true, EASY_GRAYSCALING_MAP));
                }
            }
        }
    }

    @SubscribeEvent
    public static boolean preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTHMOUNT && TFEventListener.isRidingUnfriendly((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void renderLivingPost(RenderLivingEvent.Post<EntityLivingBase> event) {
        for (RenderEffect effect : RenderEffect.VALUES) {
            if (!effect.shouldRender(event.getEntity(), false)) continue;
            effect.render(event.getEntity(), (RenderLivingBase<? extends EntityLivingBase>)event.getRenderer(), event.getX(), event.getY(), event.getZ(), event.getPartialRenderTick(), false);
        }
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderWorldLastEvent event) {
        Render renderer;
        if (!TFConfig.firstPersonEffects) {
            return;
        }
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (settings.field_74320_O != 0 || settings.field_74319_N) {
            return;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity instanceof EntityLivingBase && (renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity)) instanceof RenderLivingBase) {
            for (RenderEffect effect : RenderEffect.VALUES) {
                if (!effect.shouldRender((EntityLivingBase)entity, true)) continue;
                effect.render((EntityLivingBase)entity, (RenderLivingBase<? extends EntityLivingBase>)((RenderLivingBase)renderer), 0.0, 0.0, 0.0, event.getPartialTicks(), true);
            }
        }
    }

    @SubscribeEvent
    public static void fovUpdate(FOVUpdateEvent event) {
        if (!shouldUpdateFOV) {
            return;
        }
        EntityPlayer player = event.getEntity();
        if (player.func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemTFBowBase) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            event.setNewfov(event.getNewfov() * (1.0f - f1 * 0.15f));
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.func_71410_x();
            boolean fancyGraphics = minecraft.field_71474_y.field_74347_j;
            TFBlocks.twilight_leaves.func_150122_b(fancyGraphics);
            TFBlocks.twilight_leaves_3.func_150122_b(fancyGraphics);
            TFBlocks.magic_leaves.func_150122_b(fancyGraphics);
            if (minecraft.field_71441_e != null && minecraft.field_71441_e.field_73011_w instanceof WorldProviderTwilightForest && minecraft.field_71456_v != null) {
                minecraft.field_71456_v.field_73843_a = 0.0f;
            }
            if (minecraft.field_71439_g != null && TFEventListener.isRidingUnfriendly((EntityLivingBase)minecraft.field_71439_g) && minecraft.field_71456_v != null) {
                minecraft.field_71456_v.func_110326_a("", false);
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++time;
        float partial = Minecraft.func_71410_x().func_184121_ak();
        rotationTickerI = rotationTickerI >= 359 ? 0 : rotationTickerI + 1;
        sineTickerI = sineTickerI >= 627 ? 0 : sineTickerI + 1;
        rotationTicker = (float)rotationTickerI + partial;
        sineTicker += partial;
        BugModelAnimationHelper.animate();
    }
}

