/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.BlockTFMazestone;
import twilightforest.block.BlockTFTowerWood;
import twilightforest.block.BlockTFUnderBrick;
import twilightforest.block.TFBlocks;
import twilightforest.enums.MazestoneVariant;
import twilightforest.enums.TowerWoodVariant;
import twilightforest.enums.UnderBrickVariant;
import twilightforest.item.ItemTF;
import twilightforest.util.WorldUtil;

public class ItemTFCrumbleHorn
extends ItemTF {
    private static final int CHANCE_HARVEST = 20;
    private static final int CHANCE_CRUMBLE = 5;
    private final List<Pair<Predicate<IBlockState>, UnaryOperator<IBlockState>>> crumbleTransforms = new ArrayList<Pair<Predicate<IBlockState>, UnaryOperator<IBlockState>>>();
    private final List<Predicate<IBlockState>> harvestedStates = new ArrayList<Predicate<IBlockState>>();

    ItemTFCrumbleHorn(EnumRarity rarity) {
        super(rarity);
        this.field_77777_bU = 1;
        this.func_77656_e(1024);
        this.addCrumbleTransforms();
    }

    private void addCrumbleTransforms() {
        this.addCrumble(() -> Blocks.field_150348_b, () -> Blocks.field_150347_e.func_176223_P());
        this.addCrumble((IBlockState state) -> state.func_177230_c() == Blocks.field_150417_aV && state.func_177229_b((IProperty)BlockStoneBrick.field_176249_a) == BlockStoneBrick.EnumType.DEFAULT, state -> state.func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED));
        this.addCrumble((IBlockState state) -> state.func_177230_c() == TFBlocks.maze_stone && state.func_177229_b(BlockTFMazestone.VARIANT) == MazestoneVariant.BRICK, state -> state.func_177226_a(BlockTFMazestone.VARIANT, (Comparable)((Object)MazestoneVariant.CRACKED)));
        this.addCrumble((IBlockState state) -> state.func_177230_c() == TFBlocks.underbrick && state.func_177229_b(BlockTFUnderBrick.VARIANT) == UnderBrickVariant.NORMAL, state -> state.func_177226_a(BlockTFUnderBrick.VARIANT, (Comparable)((Object)UnderBrickVariant.CRACKED)));
        this.addCrumble((IBlockState state) -> state.func_177230_c() == TFBlocks.tower_wood && state.func_177229_b(BlockTFTowerWood.VARIANT) == TowerWoodVariant.PLAIN, state -> state.func_177226_a(BlockTFTowerWood.VARIANT, (Comparable)((Object)TowerWoodVariant.CRACKED)));
        this.addCrumble(() -> Blocks.field_150347_e, () -> Blocks.field_150351_n.func_176223_P());
        this.addCrumble(() -> Blocks.field_150322_A, () -> Blocks.field_150354_m.func_176223_P());
        this.addCrumble(() -> Blocks.field_180395_cM, () -> Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND));
        this.addCrumble(() -> Blocks.field_150349_c, () -> Blocks.field_150346_d.func_176223_P());
        this.addCrumble(() -> Blocks.field_150391_bh, () -> Blocks.field_150346_d.func_176223_P());
        this.addHarvest(() -> Blocks.field_150351_n);
        this.addHarvest(() -> Blocks.field_150346_d);
        this.addHarvest(() -> Blocks.field_150354_m);
        this.addHarvest(() -> Blocks.field_150435_aG);
    }

    private void addCrumble(Supplier<Block> block, Supplier<IBlockState> result) {
        this.addCrumble((IBlockState state) -> state.func_177230_c() == block.get(), state -> (IBlockState)result.get());
    }

    private void addCrumble(Predicate<IBlockState> test, UnaryOperator<IBlockState> transform) {
        this.crumbleTransforms.add((Pair<Predicate<IBlockState>, UnaryOperator<IBlockState>>)Pair.of(test, transform));
    }

    private void addHarvest(Supplier<Block> block) {
        this.addHarvest((IBlockState state) -> state.func_177230_c() == block.get());
    }

    private void addHarvest(Predicate<IBlockState> test) {
        this.harvestedStates.add(test);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        player.func_184185_a(SoundEvents.field_187757_eG, 1.0f, 0.8f);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        if (count > 10 && count % 5 == 0 && !living.field_70170_p.field_72995_K) {
            int crumbled = this.doCrumble(stack, living.field_70170_p, living);
            if (crumbled > 0) {
                stack.func_77972_a(crumbled, living);
            }
            living.field_70170_p.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187757_eG, living.func_184176_by(), 1.0f, 0.8f);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b();
    }

    private int doCrumble(ItemStack stack, World world, EntityLivingBase living) {
        double range = 3.0;
        double radius = 2.0;
        Vec3d srcVec = new Vec3d(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v);
        Vec3d lookVec = living.func_70040_Z().func_186678_a(3.0);
        Vec3d destVec = srcVec.func_178787_e(lookVec);
        AxisAlignedBB crumbleBox = new AxisAlignedBB(destVec.field_72450_a - 2.0, destVec.field_72448_b - 2.0, destVec.field_72449_c - 2.0, destVec.field_72450_a + 2.0, destVec.field_72448_b + 2.0, destVec.field_72449_c + 2.0);
        return this.crumbleBlocksInAABB(stack, world, living, crumbleBox);
    }

    private int crumbleBlocksInAABB(ItemStack stack, World world, EntityLivingBase living, AxisAlignedBB box) {
        int crumbled = 0;
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            if (!this.crumbleBlock(stack, world, living, pos)) continue;
            ++crumbled;
        }
        return crumbled;
    }

    private boolean crumbleBlock(ItemStack stack, World world, EntityLivingBase living, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        for (Pair<Predicate<IBlockState>, UnaryOperator<IBlockState>> pair : this.crumbleTransforms) {
            if (!((Predicate)pair.getLeft()).test(state) || world.field_73012_v.nextInt(5) != 0) continue;
            world.func_180501_a(pos, (IBlockState)((UnaryOperator)pair.getRight()).apply(state), 3);
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            this.postTrigger(living, stack, world, pos);
            return true;
        }
        for (Predicate predicate : this.harvestedStates) {
            if (!predicate.test(state) || world.field_73012_v.nextInt(20) != 0) continue;
            if (living instanceof EntityPlayer) {
                if (!block.canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)living)) continue;
                world.func_175698_g(pos);
                block.func_180657_a(world, (EntityPlayer)living, pos, state, world.func_175625_s(pos), ItemStack.field_190927_a);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                this.postTrigger(living, stack, world, pos);
                return true;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)living)) continue;
            world.func_175655_b(pos, true);
            this.postTrigger(living, stack, world, pos);
            return true;
        }
        return false;
    }

    private void postTrigger(EntityLivingBase living, ItemStack stack, World world, BlockPos pos) {
        if (living instanceof EntityPlayerMP) {
            TFAdvancements.ITEM_USE_TRIGGER.trigger((EntityPlayerMP)living, stack, world, pos);
        }
    }
}

