/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.biomes.TFBiomes;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;
import twilightforest.network.PacketMagicMap;
import twilightforest.network.TFPacketHandler;

public class ItemTFMagicMap
extends ItemMap
implements ModelRegisterCallback {
    public static final String STR_ID = "magicmap";
    private static final Map<ResourceLocation, MapColorBrightness> BIOME_COLORS = new HashMap<ResourceLocation, MapColorBrightness>();

    public static ItemStack setupNewMap(World world, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(TFItems.magic_map, 1, world.func_72841_b(STR_ID));
        String s = "magicmap_" + itemstack.func_77960_j();
        TFMagicMapData mapdata = new TFMagicMapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        mapdata.func_176054_a(worldX, worldZ, mapdata.field_76197_d);
        mapdata.field_76200_c = world.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static TFMagicMapData loadMapData(int mapId, World worldIn) {
        String s = "magicmap_" + mapId;
        return (TFMagicMapData)worldIn.func_72943_a(TFMagicMapData.class, s);
    }

    public TFMagicMapData getMapData(ItemStack stack, World worldIn) {
        String s = "magicmap_" + stack.func_77960_j();
        TFMagicMapData mapdata = (TFMagicMapData)worldIn.func_72943_a(TFMagicMapData.class, s);
        if (mapdata == null && !worldIn.field_72995_K) {
            stack.func_77964_b(worldIn.func_72841_b(STR_ID));
            s = "magicmap_" + stack.func_77960_j();
            mapdata = new TFMagicMapData(s);
            mapdata.field_76197_d = (byte)3;
            mapdata.func_176054_a(worldIn.func_72912_H().func_76079_c(), worldIn.func_72912_H().func_76074_e(), mapdata.field_76197_d);
            mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
            mapdata.func_76185_a();
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public void func_77872_a(World world, Entity viewer, MapData data) {
        if (world.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerX = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            Biome[] biomes = world.func_72959_q().func_76937_a((Biome[])null, startX, startZ, 128 * biomesPerPixel, 128 * biomesPerPixel);
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    Biome biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    Biome overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    Biome downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    if (overBiome == TFBiomes.stream || downBiome == TFBiomes.stream) {
                        biome = TFBiomes.stream;
                    }
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(world, biome);
                    MapColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.field_76198_e[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.field_76290_q * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.field_76198_e[xPixel + zPixel * 128] = ourPixel;
                        data.func_176053_a(xPixel, zPixel);
                    }
                    if (!TFFeature.isInFeatureChunk(world, worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel)) continue;
                    byte mapX = (byte)((float)(worldX - centerX) / (float)blocksPerPixel * 2.0f);
                    byte mapZ = (byte)((float)(worldZ - centerZ) / (float)blocksPerPixel * 2.0f);
                    TFFeature feature = TFFeature.getFeatureAt(worldX, worldZ, world);
                    TFMagicMapData tfData = (TFMagicMapData)data;
                    tfData.tfDecorations.add(new TFMagicMapData.TFMapDecoration(feature.ordinal(), mapX, mapZ, 8));
                }
            }
        }
    }

    private MapColorBrightness getMapColorPerBiome(World world, Biome biome) {
        MapColorBrightness color;
        if (BIOME_COLORS.isEmpty()) {
            ItemTFMagicMap.setupBiomeColors();
        }
        if ((color = BIOME_COLORS.get(biome.getRegistryName())) != null) {
            return color;
        }
        return new MapColorBrightness(biome.field_76752_A.func_185909_g((IBlockAccess)world, BlockPos.field_177992_a));
    }

    private static void setupBiomeColors() {
        ItemTFMagicMap.putBiomeColor(TFBiomes.twilightForest, new MapColorBrightness(MapColor.field_151669_i, 1));
        ItemTFMagicMap.putBiomeColor(TFBiomes.denseTwilightForest, new MapColorBrightness(MapColor.field_151669_i, 0));
        ItemTFMagicMap.putBiomeColor(TFBiomes.tfLake, new MapColorBrightness(MapColor.field_151662_n, 3));
        ItemTFMagicMap.putBiomeColor(TFBiomes.stream, new MapColorBrightness(MapColor.field_151662_n, 1));
        ItemTFMagicMap.putBiomeColor(TFBiomes.tfSwamp, new MapColorBrightness(MapColor.field_151648_G, 3));
        ItemTFMagicMap.putBiomeColor(TFBiomes.fireSwamp, new MapColorBrightness(MapColor.field_151655_K, 1));
        ItemTFMagicMap.putBiomeColor(TFBiomes.clearing, new MapColorBrightness(MapColor.field_151661_c, 2));
        ItemTFMagicMap.putBiomeColor(TFBiomes.oakSavanna, new MapColorBrightness(MapColor.field_151661_c, 0));
        ItemTFMagicMap.putBiomeColor(TFBiomes.highlands, new MapColorBrightness(MapColor.field_151664_l, 0));
        ItemTFMagicMap.putBiomeColor(TFBiomes.thornlands, new MapColorBrightness(MapColor.field_151663_o, 3));
        ItemTFMagicMap.putBiomeColor(TFBiomes.highlandsCenter, new MapColorBrightness(MapColor.field_151680_x, 2));
        ItemTFMagicMap.putBiomeColor(TFBiomes.fireflyForest, new MapColorBrightness(MapColor.field_151653_I, 1));
        ItemTFMagicMap.putBiomeColor(TFBiomes.darkForest, new MapColorBrightness(MapColor.field_151651_C, 3));
        ItemTFMagicMap.putBiomeColor(TFBiomes.darkForestCenter, new MapColorBrightness(MapColor.field_151676_q, 3));
        ItemTFMagicMap.putBiomeColor(TFBiomes.snowy_forest, new MapColorBrightness(MapColor.field_151666_j, 1));
        ItemTFMagicMap.putBiomeColor(TFBiomes.glacier, new MapColorBrightness(MapColor.field_151657_g, 1));
        ItemTFMagicMap.putBiomeColor(TFBiomes.mushrooms, new MapColorBrightness(MapColor.field_151676_q, 0));
        ItemTFMagicMap.putBiomeColor(TFBiomes.deepMushrooms, new MapColorBrightness(MapColor.field_151671_v, 0));
        ItemTFMagicMap.putBiomeColor(TFBiomes.enchantedForest, new MapColorBrightness(MapColor.field_151672_u, 2));
    }

    private static void putBiomeColor(Biome biome, MapColorBrightness color) {
        BIOME_COLORS.put(biome.getRegistryName(), color);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World world, EntityPlayer player) {
        Packet p = super.func_150911_c(stack, world, player);
        if (p instanceof SPacketMaps) {
            TFMagicMapData mapdata = this.getMapData(stack, world);
            return TFPacketHandler.CHANNEL.getPacketFrom((IMessage)new PacketMagicMap(stack.func_77952_i(), mapdata, (SPacketMaps)p));
        }
        return p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    private static class MapColorBrightness {
        public MapColor color;
        public int brightness;

        public MapColorBrightness(MapColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(MapColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

