/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFCastleDoor;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.BlockTFForceField;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBellTower21;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBossGazebo;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBridge;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDungeonSteps;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleEntranceTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation48;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleLargeTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleMazeTower13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleMural;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleRoof48Crenellated;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleStairTower;
import twilightforest.structures.finalcastle.StructureTFDecoratorCastle;
import twilightforest.util.RotationUtil;

public class ComponentTFFinalCastleMain
extends StructureTFComponentOld {
    public ComponentTFFinalCastleMain() {
    }

    public ComponentTFFinalCastleMain(TFFeature feature, World world, Random rand, int i, int x, int y, int z) {
        super(feature, i);
        this.func_186164_a(EnumFacing.SOUTH);
        this.spawnListIndex = 1;
        x = x + 127 >> 8 << 8;
        z = z + 127 >> 8 << 8;
        this.field_74887_e = StructureTFComponentOld.getComponentToAddBoundingBox(x, y, z, -24, 120, -24, 48, 40, 48, EnumFacing.SOUTH);
        BlockPos cc = TFFeature.getNearestCenterXYZ(x >> 4, z >> 4, world);
        int cx = x >> 8 << 8;
        int cz = z >> 8 << 8;
        TwilightForestMod.LOGGER.info("Making castle at " + x + ", " + z + ". center is " + cc.func_177958_n() + ", " + cc.func_177952_p());
        TwilightForestMod.LOGGER.info("Natural center at " + cx + ", " + cz);
        if (this.deco == null) {
            this.deco = new StructureTFDecoratorCastle();
        }
    }

    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        ComponentTFFinalCastleFoundation48 foundation = new ComponentTFFinalCastleFoundation48(this.getFeatureType(), rand, 4, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        ComponentTFFinalCastleRoof48Crenellated roof = new ComponentTFFinalCastleRoof48Crenellated(this.getFeatureType(), rand, 4, this);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
        ComponentTFFinalCastleBossGazebo gazebo = new ComponentTFFinalCastleBossGazebo(this.getFeatureType(), rand, 5, this);
        list.add(gazebo);
        gazebo.func_74861_a(this, list, rand);
        ComponentTFFinalCastleStairTower tower0 = new ComponentTFFinalCastleStairTower(this.getFeatureType(), rand, 3, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c, EnumFacing.NORTH);
        list.add(tower0);
        tower0.func_74861_a(this, list, rand);
        ComponentTFFinalCastleLargeTower tower1 = new ComponentTFFinalCastleLargeTower(this.getFeatureType(), rand, 3, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c, EnumFacing.EAST);
        list.add(tower1);
        tower1.func_74861_a(this, list, rand);
        ComponentTFFinalCastleStairTower tower2 = new ComponentTFFinalCastleStairTower(this.getFeatureType(), rand, 3, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f, EnumFacing.WEST);
        list.add(tower2);
        tower2.func_74861_a(this, list, rand);
        ComponentTFFinalCastleStairTower tower3 = new ComponentTFFinalCastleStairTower(this.getFeatureType(), rand, 3, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f, EnumFacing.SOUTH);
        list.add(tower3);
        tower3.func_74861_a(this, list, rand);
        BlockPos dest = new BlockPos(this.field_74887_e.field_78897_a - 4, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c - 24);
        this.buildTowerMaze(list, rand, 48, 0, 24, 60, EnumFacing.SOUTH, BlockTFCastleMagic.VALID_COLORS.get(0), dest);
        dest = new BlockPos(this.field_74887_e.field_78893_d + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 24);
        this.buildTowerMaze(list, rand, 0, 30, 24, 60, EnumFacing.NORTH, BlockTFCastleMagic.VALID_COLORS.get(1), dest);
        ComponentTFFinalCastleDungeonSteps steps0 = new ComponentTFFinalCastleDungeonSteps(rand, 5, this.field_74887_e.field_78897_a + 18, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c + 18, EnumFacing.SOUTH);
        list.add(steps0);
        steps0.func_74861_a(this, list, rand);
        ComponentTFFinalCastleDungeonSteps steps1 = steps0.buildMoreStepsTowards(parent, list, rand, Rotation.COUNTERCLOCKWISE_90);
        ComponentTFFinalCastleDungeonSteps steps2 = steps1.buildMoreStepsTowards(parent, list, rand, Rotation.COUNTERCLOCKWISE_90);
        ComponentTFFinalCastleDungeonSteps steps3 = steps2.buildMoreStepsTowards(parent, list, rand, Rotation.COUNTERCLOCKWISE_90);
        steps3.buildLevelUnder(parent, list, rand, 1);
        BlockPos mc = this.offsetTowerCCoords(48, 23, 25, 1, EnumFacing.SOUTH);
        ComponentTFFinalCastleMural mural0 = new ComponentTFFinalCastleMural(this.getFeatureType(), rand, 7, mc.func_177958_n(), mc.func_177956_o(), mc.func_177952_p(), 35, 30, EnumFacing.SOUTH);
        list.add(mural0);
        mural0.func_74861_a(this, list, rand);
        BlockPos mc1 = this.offsetTowerCCoords(48, 33, 24, -1, EnumFacing.SOUTH);
        ComponentTFFinalCastleMural mural1 = new ComponentTFFinalCastleMural(this.getFeatureType(), rand, 7, mc1.func_177958_n(), mc1.func_177956_o(), mc.func_177952_p(), 19, 12, EnumFacing.NORTH);
        list.add(mural1);
        mural1.func_74861_a(this, list, rand);
    }

    private void buildTowerMaze(List<StructureComponent> list, Random rand, int x, int y, int z, int howFar, EnumFacing direction, EnumDyeColor type, BlockPos dest) {
        boolean complete = false;
        for (int iterations = 0; !complete && iterations < 15; ++iterations) {
            LinkedList<StructureComponent> before = new LinkedList<StructureComponent>(list);
            BlockPos tc = this.offsetTowerCCoords(x, y, z, howFar, direction);
            ComponentTFFinalCastleMazeTower13 sTower = new ComponentTFFinalCastleMazeTower13(this.getFeatureType(), rand, 3, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), type, direction);
            BlockPos bc = this.offsetTowerCCoords(x, y, z, 1, direction);
            ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, direction);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            list.add(sTower);
            sTower.buildTowards(this, list, rand, dest);
            TwilightForestMod.LOGGER.info("Working towards {},{},{}", (Object)dest.func_177958_n(), (Object)dest.func_177956_o(), (Object)dest.func_177952_p());
            if (this.isMazeComplete(list, type)) {
                TwilightForestMod.LOGGER.info("Tower maze color " + type + " complete!");
                complete = true;
                continue;
            }
            TwilightForestMod.LOGGER.info("Tower maze color " + type + " INCOMPLETE, retrying!");
            list.clear();
            list.addAll(before);
        }
    }

    private boolean isMazeComplete(List<StructureComponent> list, EnumDyeColor type) {
        int componentsCounted = 0;
        for (StructureComponent structurecomponent : list) {
            ++componentsCounted;
            StructureBoundingBox boundingBox = structurecomponent.func_74874_b();
            int x = boundingBox.field_78893_d - boundingBox.field_78897_a / 2 + boundingBox.field_78897_a;
            int y = boundingBox.field_78894_e - boundingBox.field_78895_b / 2 + boundingBox.field_78895_b;
            int z = boundingBox.field_78892_f - boundingBox.field_78896_c / 2 + boundingBox.field_78896_c;
            TwilightForestMod.LOGGER.info("Component {} at {},{},{}", (Object)structurecomponent.getClass().getSimpleName(), (Object)x, (Object)y, (Object)z);
            if (componentsCounted >= 60) {
                TwilightForestMod.LOGGER.warn("Maze of color {} is getting a bit excessive.", (Object)type);
            }
            if (type == BlockTFCastleMagic.VALID_COLORS.get(0) && structurecomponent instanceof ComponentTFFinalCastleEntranceTower) {
                return true;
            }
            if (type != BlockTFCastleMagic.VALID_COLORS.get(1) || !(structurecomponent instanceof ComponentTFFinalCastleBellTower21)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int howFar, EnumFacing direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        switch (direction) {
            case SOUTH: {
                dx += howFar;
                break;
            }
            case WEST: {
                dz += howFar;
                break;
            }
            case NORTH: {
                dx -= howFar;
                break;
            }
            case EAST: {
                dz -= howFar;
                break;
            }
        }
        return new BlockPos(dx, dy, dz);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        this.func_74882_a(world, sbb, 0, 0, 0, 48, 40, 48, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 13, 30, 1, 47, 30, 12, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 13, 31, 12, 36, 31, 12, this.deco.fenceState, this.deco.fenceState, false);
        this.func_74882_a(world, sbb, 13, 30, 36, 47, 30, 47, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 13, 31, 36, 36, 31, 36, this.deco.fenceState, this.deco.fenceState, false);
        this.func_74882_a(world, sbb, 1, 30, 1, 12, 30, 47, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 12, 31, 12, 12, 31, 36, this.deco.fenceState, this.deco.fenceState, false);
        this.func_74882_a(world, sbb, 38, 25, 13, 47, 25, 35, false, rand, this.deco.randomBlocks);
        for (int i = 0; i < 5; ++i) {
            int y = 30 - i;
            this.makeMezzTopStairs(world, sbb, y, 10 + i, EnumFacing.SOUTH);
            this.makeMezzTopStairs(world, sbb, y, 38 - i, EnumFacing.NORTH);
            y = 25 - i;
            int x = 37 - i;
            IBlockState stairState = ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.WEST, this.field_186169_c, false);
            this.func_175804_a(world, sbb, x, y, 14, x, y, 22, stairState, stairState, false);
            this.func_175804_a(world, sbb, x, y - 1, 14, x, y - 1, 22, this.deco.blockState, this.deco.blockState, false);
            this.func_175804_a(world, sbb, x, y, 26, x, y, 34, stairState, stairState, false);
            this.func_175804_a(world, sbb, x, y - 1, 26, x, y - 1, 34, this.deco.blockState, this.deco.blockState, false);
        }
        for (int x = 11; x < 47; x += 12) {
            for (int z = 11; z < 47; z += 12) {
                this.func_175804_a(world, sbb, x, 1, z, x + 2, 40, z + 2, this.deco.pillarState, this.deco.blockState, false);
                this.makePillarBase(world, sbb, x, z, 1, false);
                this.makePillarBase(world, sbb, x, z, 19, true);
                this.makePillarBase(world, sbb, x, z, 21, false);
                this.makePillarBase(world, sbb, x, z, 39, true);
            }
        }
        for (Rotation rotation : RotationUtil.ROTATIONS) {
            for (int z = 11; z < 47; z += 12) {
                if (z == 23 && (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180)) continue;
                this.fillBlocksRotated(world, sbb, 1, 1, z, 1, 40, z + 2, this.deco.pillarState, rotation);
                this.makeHalfPillarBase(world, sbb, rotation, 1, z, false);
                this.makeHalfPillarBase(world, sbb, rotation, 19, z, true);
                this.makeHalfPillarBase(world, sbb, rotation, 21, z, false);
                this.makeHalfPillarBase(world, sbb, rotation, 39, z, true);
            }
        }
        this.func_74882_a(world, sbb, 1, 20, 1, 47, 20, 47, false, rand, this.deco.randomBlocks);
        IBlockState fieldBlock = TFBlocks.force_field.func_176223_P().func_177226_a(BlockTFForceField.COLOR, (Comparable)EnumDyeColor.PINK);
        this.func_175804_a(world, sbb, 12, 1, 12, 24, 10, 12, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 12, 1, 12, 12, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 24, 1, 12, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 12, 1, 24, 24, 10, 24, fieldBlock, fieldBlock, false);
        this.func_175804_a(world, sbb, 12, 10, 12, 24, 10, 24, fieldBlock, fieldBlock, false);
        IBlockState castleDoor = TFBlocks.castle_door.func_176223_P();
        this.func_175804_a(world, sbb, 17, 1, 12, 19, 4, 12, castleDoor.func_177226_a(BlockTFCastleDoor.LOCK_INDEX, (Comparable)Integer.valueOf(2)), AIR, false);
        this.func_175804_a(world, sbb, 17, 1, 24, 19, 4, 24, castleDoor.func_177226_a(BlockTFCastleDoor.LOCK_INDEX, (Comparable)Integer.valueOf(2)), AIR, false);
        this.makeSmallTowerStairs(world, sbb, Rotation.NONE);
        this.makeSmallTowerStairs(world, sbb, Rotation.CLOCKWISE_90);
        this.makeSmallTowerStairs(world, sbb, Rotation.COUNTERCLOCKWISE_90);
        this.makeLargeTowerStairs(world, sbb, Rotation.CLOCKWISE_180);
        this.func_175804_a(world, sbb, 48, 1, 23, 48, 4, 25, castleDoor.func_177226_a(BlockTFCastleDoor.LOCK_INDEX, (Comparable)Integer.valueOf(0)), AIR, false);
        this.func_175804_a(world, sbb, 0, 31, 23, 0, 34, 25, castleDoor.func_177226_a(BlockTFCastleDoor.LOCK_INDEX, (Comparable)Integer.valueOf(1)), AIR, false);
        return true;
    }

    private void makeSmallTowerStairs(World world, StructureBoundingBox sbb, Rotation rotation) {
        for (int y = 1; y < 4; ++y) {
            int z = 40 + y;
            this.fillBlocksRotated(world, sbb, 1, 1, z, 4, y, z, this.deco.blockState, rotation);
            this.fillBlocksRotated(world, sbb, 2, y, z, 3, y, z, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), rotation);
        }
    }

    private void makeLargeTowerStairs(World world, StructureBoundingBox sbb, Rotation rotation) {
        IBlockState stairState = ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false);
        for (int y = 1; y < 4; ++y) {
            int z = 38 + y;
            this.fillBlocksRotated(world, sbb, 2, 1, z, 6, y, z, this.deco.blockState, rotation);
            this.fillBlocksRotated(world, sbb, 3, y, z, 5, y, z, stairState, rotation);
        }
    }

    private void makeMezzTopStairs(World world, StructureBoundingBox sbb, int y, int z, EnumFacing stairMeta) {
        IBlockState stairState = ComponentTFFinalCastleMain.getStairState(this.deco.stairState, stairMeta, this.field_186169_c, false);
        this.func_175804_a(world, sbb, 38, y, z, 46, y, z, stairState, stairState, false);
        this.func_175804_a(world, sbb, 38, y - 1, z, 46, y - 1, z, this.deco.blockState, this.deco.blockState, false);
        this.func_74878_a(world, sbb, 38, y + 1, z, 46, y + 3, z);
    }

    private void makeHalfPillarBase(World world, StructureBoundingBox sbb, Rotation rotation, int y, int z, boolean isFlipped) {
        this.fillBlocksRotated(world, sbb, 2, y, z - 1, 2, y, z + 3, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, isFlipped), rotation);
        this.setBlockStateRotated(world, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, isFlipped), 1, y, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, isFlipped), 1, y, z + 3, rotation, sbb);
    }

    private void makePillarBase(World world, StructureBoundingBox sbb, int x, int z, int y, boolean isFlipped) {
        this.func_175804_a(world, sbb, x + 0, y, z + 3, x + 3, y, z + 3, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.SOUTH, this.field_186169_c, isFlipped), AIR, false);
        this.func_175804_a(world, sbb, x - 1, y, z - 1, x + 2, y, z - 1, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.NORTH, this.field_186169_c, isFlipped), AIR, false);
        this.func_175804_a(world, sbb, x + 3, y, z - 1, x + 3, y, z + 2, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.EAST, this.field_186169_c, isFlipped), AIR, false);
        this.func_175804_a(world, sbb, x - 1, y, z + 0, x - 1, y, z + 3, ComponentTFFinalCastleMain.getStairState(this.deco.stairState, EnumFacing.WEST, this.field_186169_c, isFlipped), AIR, false);
    }
}

