/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.start;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.structures.start.StructureStartTFAbstract;

public abstract class StructureStartTFFeatureAbstract
extends StructureStartTFAbstract {
    private static int NUM_LOCKS = 4;
    public boolean isConquered;
    public byte[] lockBytes = new byte[NUM_LOCKS];
    @Deprecated
    private TFFeature feature;

    public StructureStartTFFeatureAbstract() {
    }

    public StructureStartTFFeatureAbstract(World world, TFFeature feature, Random rand, int chunkX, int chunkZ) {
        super(world, feature, rand, chunkX, chunkZ);
        this.isConquered = false;
        this.feature = feature;
    }

    public void func_143022_a(NBTTagCompound compound) {
        super.func_143022_a(compound);
        compound.func_74757_a("Conquered", this.isConquered);
        compound.func_74773_a("Locks", this.lockBytes);
        compound.func_74768_a("FeatureID", this.feature.ordinal());
    }

    public void func_143017_b(NBTTagCompound compound) {
        super.func_143017_b(compound);
        this.isConquered = compound.func_74767_n("Conquered");
        this.lockBytes = compound.func_74770_j("Locks");
        this.feature = TFFeature.values()[compound.func_74762_e("FeatureID")];
    }

    public boolean isLocked(int lockIndex) {
        if (lockIndex < this.lockBytes.length) {
            TwilightForestMod.LOGGER.info("Checking locks for lockIndex " + lockIndex);
            for (int i = 0; i < this.lockBytes.length; ++i) {
                TwilightForestMod.LOGGER.info("Lock " + i + " = " + this.lockBytes[i]);
            }
            return this.lockBytes[lockIndex] != 0;
        }
        TwilightForestMod.LOGGER.warn("Current lock index, " + lockIndex + " is beyond array bounds " + this.lockBytes.length);
        return false;
    }

    public boolean func_75069_d() {
        return this.feature.isStructureEnabled;
    }
}

