/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import twilightforest.compat.Baubles;
import twilightforest.compat.TFCompat;

public class TFItemStackUtils {
    public static boolean consumeInventoryItem(EntityLivingBase living, Predicate<ItemStack> matcher, int count) {
        boolean consumedSome = false;
        IItemHandler inv = (IItemHandler)living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < inv.getSlots() && count > 0; ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!matcher.test(stack)) continue;
            int consume = Math.min(count, stack.func_190916_E());
            stack.func_190918_g(consume);
            count -= consume;
            consumedSome = true;
        }
        if (TFCompat.BAUBLES.isActivated() && living instanceof EntityPlayer) {
            consumedSome |= Baubles.consumeInventoryItem((EntityPlayer)living, matcher, count);
        }
        return consumedSome;
    }

    public static NonNullList<ItemStack> splitToSize(ItemStack stack) {
        NonNullList result = NonNullList.func_191196_a();
        int size = stack.func_77976_d();
        while (!stack.func_190926_b()) {
            result.add((Object)stack.func_77979_a(size));
        }
        return result;
    }

    public static boolean hasToolMaterial(ItemStack stack, Item.ToolMaterial material) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemTool && material.toString().equals(((ItemTool)item).func_77861_e())) {
            return true;
        }
        if (item instanceof ItemSword && material.toString().equals(((ItemSword)item).func_150932_j())) {
            return true;
        }
        return item instanceof ItemHoe && material.toString().equals(((ItemHoe)item).func_77842_f());
    }

    public static void clearInfoTag(ItemStack stack, String key) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            nbt.func_82580_o(key);
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
    }
}

