/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.start.StructureStartTFFeatureAbstract;
import twilightforest.util.StructureBoundingBoxUtils;

public class MapGenTFMajorFeature
extends MapGenStructure {
    private final TFFeature FEATURE;

    public MapGenTFMajorFeature() {
        this.FEATURE = TFFeature.NOTHING;
    }

    public MapGenTFMajorFeature(TFFeature feature) {
        this.FEATURE = feature;
    }

    public TFFeature getFeature() {
        return this.FEATURE != null ? this.FEATURE : TFFeature.NOTHING;
    }

    public String func_143025_a() {
        return this.getFeature().name.toLowerCase();
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenTFMajorFeature.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)20, (int)11, (int)10387313, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        return this.FEATURE.isStructureEnabled && TFFeature.getFeatureDirectlyAt(chunkX, chunkZ, this.field_75039_c) == this.FEATURE;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        this.field_75038_b.setSeed(this.field_75039_c.func_72905_C());
        long rand1 = this.field_75038_b.nextLong();
        long rand2 = this.field_75038_b.nextLong();
        long chunkXr1 = (long)chunkX * rand1;
        long chunkZr2 = (long)chunkZ * rand2;
        this.field_75038_b.setSeed(chunkXr1 ^ chunkZr2 ^ this.field_75039_c.func_72905_C());
        this.field_75038_b.nextInt();
        TwilightForestMod.LOGGER.info((Object)((Object)this.FEATURE) + " @ chunk {} {}", (Object)chunkX, (Object)chunkZ);
        return this.getFeature().provideStructureStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public int getSpawnListIndexAt(BlockPos pos) {
        int highestFoundIndex = -1;
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(pos.func_177958_n(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177952_p())) continue;
            for (StructureComponent component : start.func_186161_c()) {
                if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                if (component instanceof StructureTFComponent) {
                    StructureTFComponent tfComponent = (StructureTFComponent)component;
                    if (tfComponent.spawnListIndex <= highestFoundIndex) continue;
                    highestFoundIndex = tfComponent.spawnListIndex;
                    continue;
                }
                return 0;
            }
        }
        return highestFoundIndex;
    }

    @Nullable
    public StructureBoundingBox getSBBAt(BlockPos pos) {
        StructureBoundingBox boxFound = null;
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(pos.func_177958_n(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177952_p())) continue;
            for (StructureComponent component : start.func_186161_c()) {
                if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                boxFound = component.func_74874_b();
            }
        }
        return boxFound;
    }

    public TFFeature getFeatureAt(BlockPos pos) {
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(pos.func_177958_n(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177952_p())) continue;
            for (StructureComponent component : start.func_186161_c()) {
                if (!component.func_74874_b().func_175898_b((Vec3i)pos) || !(component instanceof StructureTFComponent)) continue;
                return ((StructureTFComponent)component).getFeatureType();
            }
        }
        return TFFeature.NOTHING;
    }

    public boolean isBlockProtectedAt(BlockPos pos) {
        boolean blockProtected = false;
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(pos.func_177958_n(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177952_p())) continue;
            for (StructureComponent component : start.func_186161_c()) {
                if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                if (component instanceof StructureTFComponent) {
                    StructureTFComponent tfComp = (StructureTFComponent)component;
                    blockProtected = tfComp.isComponentProtected();
                    continue;
                }
                blockProtected = true;
            }
        }
        return blockProtected;
    }

    public void setStructureConquered(int mapX, int mapY, int mapZ, boolean flag) {
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(mapX, mapZ, mapX, mapZ) || !(start instanceof StructureStartTFFeatureAbstract)) continue;
            StructureStartTFFeatureAbstract featureStart = (StructureStartTFFeatureAbstract)start;
            featureStart.isConquered = flag;
            this.field_143029_e.func_143043_a(featureStart.func_143021_a(start.func_143019_e(), start.func_143018_f()), start.func_143019_e(), start.func_143018_f());
            this.field_143029_e.func_76186_a(true);
            if (!flag) continue;
            for (EntityPlayerMP player : this.getPlayersInsideStructure(start)) {
                TFAdvancements.STRUCTURE_CLEARED.trigger(player, this.FEATURE.name);
            }
        }
    }

    private List<EntityPlayerMP> getPlayersInsideStructure(StructureStart start) {
        return this.field_75039_c.func_175661_b(EntityPlayerMP.class, Predicates.and((Predicate)EntitySelectors.field_94557_a, p -> p.func_174813_aQ().func_72326_a(StructureBoundingBoxUtils.toAABB(start.func_75071_a()))));
    }

    public boolean isStructureConquered(BlockPos pos) {
        boolean conquered = false;
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(pos.func_177958_n(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177952_p()) || !(start instanceof StructureStartTFFeatureAbstract)) continue;
            conquered = ((StructureStartTFFeatureAbstract)start).isConquered;
        }
        return conquered;
    }

    public boolean isStructureLocked(BlockPos pos, int lockIndex) {
        boolean locked = false;
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(pos.func_177958_n(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177952_p()) || !(start instanceof StructureStartTFFeatureAbstract)) continue;
            locked = ((StructureStartTFFeatureAbstract)start).isLocked(lockIndex);
        }
        return locked;
    }

    public boolean isBlockInFullStructure(int mapX, int mapZ) {
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(mapX, mapZ, mapX, mapZ)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockNearFullStructure(int mapX, int mapZ, int range) {
        StructureBoundingBox rangeBB = new StructureBoundingBox(mapX - range, mapZ - range, mapX + range, mapZ + range);
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78884_a(rangeBB)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public StructureBoundingBox getFullSBBAt(int mapX, int mapZ) {
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78885_a(mapX, mapZ, mapX, mapZ)) continue;
            return start.func_75071_a();
        }
        return null;
    }

    @Nullable
    public StructureBoundingBox getFullSBBNear(int mapX, int mapZ, int range) {
        StructureBoundingBox rangeBB = new StructureBoundingBox(mapX - range, mapZ - range, mapX + range, mapZ + range);
        for (StructureStart start : this.field_75053_d.values()) {
            if (!start.func_75069_d() || !start.func_75071_a().func_78884_a(rangeBB)) continue;
            return start.func_75071_a();
        }
        return null;
    }
}

