/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomes;
import twilightforest.client.TFClientProxy;
import twilightforest.client.renderer.TFSkyRenderer;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.world.ChunkGeneratorTwilightForest;
import twilightforest.world.ChunkGeneratorTwilightVoid;
import twilightforest.world.TFBiomeProvider;
import twilightforest.world.TFWorld;

public class WorldProviderTwilightForest
extends WorldProviderSurface {
    private static final String SEED_KEY = "CustomSeed";
    private static final String SKYLIGHT_KEY = "HasSkylight";
    private static volatile boolean skylightEnabled = true;
    private long seed;

    public static void syncFromConfig() {
        skylightEnabled = TFConfig.performance.enableSkylight;
    }

    public static void setSkylightEnabled(boolean enabled) {
        skylightEnabled = enabled;
    }

    public static boolean isSkylightEnabled(NBTTagCompound data) {
        return data.func_150297_b(SKYLIGHT_KEY, 1) ? data.func_74767_n(SKYLIGHT_KEY) : skylightEnabled;
    }

    public WorldProviderTwilightForest() {
        this.setDimension(TFConfig.dimension.dimensionID);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return TFClientProxy.TFMUSICTYPE;
    }

    public float[] func_76560_a(float celestialAngle, float f1) {
        return null;
    }

    public Vec3d func_76562_b(float f, float f1) {
        float bright = MathHelper.func_76134_b((float)1.5707965f) * 2.0f + 0.5f;
        if (bright < 0.0f) {
            bright = 0.0f;
        }
        if (bright > 1.0f) {
            bright = 1.0f;
        }
        float red = 0.7529412f;
        float green = 1.0f;
        float blue = 0.8470588f;
        return new Vec3d((double)(red *= bright * 0.94f + 0.06f), (double)(green *= bright * 0.94f + 0.06f), (double)(blue *= bright * 0.91f + 0.09f));
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.225f;
    }

    public void func_76572_b() {
        NBTTagCompound data = TFWorld.getDimensionData(this.field_76579_a);
        this.seed = data.func_150297_b(SEED_KEY, 4) ? data.func_74763_f(SEED_KEY) : this.loadSeed();
        this.field_191067_f = WorldProviderTwilightForest.isSkylightEnabled(data);
        this.field_76578_c = new TFBiomeProvider(this.field_76579_a);
    }

    protected void func_76556_a() {
        float f = this.field_191067_f ? 0.0f : 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    public IChunkGenerator func_186060_c() {
        return TFConfig.dimension.skylightForest ? new ChunkGeneratorTwilightVoid(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r()) : new ChunkGeneratorTwilightForest(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public int func_76557_i() {
        return 30;
    }

    public boolean func_76567_e() {
        return this.field_76579_a.func_72912_H().func_76070_v();
    }

    public DimensionType func_186058_p() {
        return TwilightForestMod.dimType;
    }

    public boolean isDaytime() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d(0.125, 0.1328125, 0.2890625);
    }

    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, float[] colors) {
        float r = 0.2509804f;
        float g = 0.33333334f;
        float b = 0.28235295f;
        if (!this.field_191067_f) {
            colors[0] = 0.2509804f + blockLight * 0.7490196f;
            colors[1] = 0.33333334f + blockLight * 0.6666666f;
            colors[2] = 0.28235295f + blockLight * 0.7176471f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        return 1.0f;
    }

    public double getHorizon() {
        return TFWorld.SEALEVEL;
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        Biome biome = super.getBiomeForCoords(pos);
        if (biome == null) {
            biome = TFBiomes.twilightForest;
        }
        return biome;
    }

    public long getSeed() {
        return this.seed == 0L ? super.getSeed() : this.seed;
    }

    private long loadSeed() {
        String seed = TFConfig.dimension.twilightForestSeed;
        if (seed != null && !seed.isEmpty()) {
            try {
                return Long.parseLong(seed);
            }
            catch (NumberFormatException e) {
                return seed.hashCode();
            }
        }
        return 0L;
    }

    public void func_186057_q() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a(SEED_KEY, this.seed);
        TFWorld.setDimensionData(this.field_76579_a, data);
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new TFSkyRenderer());
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.setWeatherRenderer(new TFWeatherRenderer());
        }
        return super.getWeatherRenderer();
    }

    public float func_76571_f() {
        return TFConfig.dimension.skylightForest ? -1.0f : 161.0f;
    }
}

