/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.expequiv.exp.thaumcraft;

import com.zeitheron.expequiv.api.CountedIngredient;
import com.zeitheron.expequiv.api.FakeItem;
import com.zeitheron.expequiv.api.IEMC;
import com.zeitheron.expequiv.api.IEMCConverter;
import com.zeitheron.expequiv.exp.thaumcraft.ExpansionThaumcraft;
import com.zeitheron.hammercore.cfg.file1132.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IThaumcraftRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.items.ItemsTC;

class MagicalEMCConverter
implements IEMCConverter {
    ExpansionThaumcraft tc;

    public MagicalEMCConverter(ExpansionThaumcraft tc) {
        this.tc = tc;
    }

    @Override
    public void register(IEMC emc, Configuration cfg) {
        for (IThaumcraftRecipe recipe : ThaumcraftApi.getCraftingRecipes().values()) {
            if (recipe instanceof IArcaneRecipe) {
                this.mapRecipe(emc, (IArcaneRecipe)recipe);
            }
            if (recipe instanceof CrucibleRecipe) {
                this.mapRecipe(emc, (CrucibleRecipe)recipe);
            }
            if (!(recipe instanceof InfusionRecipe)) continue;
            this.mapRecipe(emc, (InfusionRecipe)recipe);
        }
    }

    private void mapRecipe(IEMC emc, IArcaneRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output.func_190926_b()) {
            return;
        }
        ArrayList<CountedIngredient> im = new ArrayList<CountedIngredient>();
        int pearls = 0;
        ItemStack primPearl = new ItemStack(ItemsTC.primordialPearl);
        for (Ingredient i : recipe.func_192400_c()) {
            if (i.apply(primPearl)) {
                ++pearls;
                continue;
            }
            im.add(FakeItem.create(emc, 1, i));
        }
        FakeItem primordialPearl = new FakeItem();
        emc.register(primordialPearl, this.tc.getPrimordialPearlCost() / (long)ItemsTC.primordialPearl.getMaxDamage(primPearl));
        im.add(CountedIngredient.create(primordialPearl, pearls));
        AspectList vis = recipe.getCrystals();
        for (Aspect a : vis.getAspects()) {
            FakeItem aspect = new FakeItem();
            emc.register(aspect, (long)this.tc.getAspectCost(a) + this.tc.getVisCrystalCost());
            im.add(CountedIngredient.create(aspect, vis.getAmount(a)));
        }
        emc.map(output, im);
    }

    private void mapRecipe(IEMC emc, CrucibleRecipe recipe) {
        ItemStack output = recipe.getRecipeOutput();
        if (output.func_190926_b()) {
            return;
        }
        ArrayList<CountedIngredient> im = new ArrayList<CountedIngredient>();
        int pearls = 0;
        ItemStack primPearl = new ItemStack(ItemsTC.primordialPearl);
        Ingredient i = recipe.getCatalyst();
        if (i.apply(primPearl)) {
            ++pearls;
        } else {
            im.add(FakeItem.create(emc, 1, i));
        }
        FakeItem primordialPearl = new FakeItem();
        emc.register(primordialPearl, this.tc.getPrimordialPearlCost() / (long)ItemsTC.primordialPearl.getMaxDamage(primPearl));
        im.add(CountedIngredient.create(primordialPearl, pearls));
        AspectList vis = recipe.getAspects();
        for (Aspect a : vis.getAspects()) {
            FakeItem aspect = new FakeItem();
            emc.register(aspect, (long)this.tc.getAspectCost(a));
            im.add(CountedIngredient.create(aspect, vis.getAmount(a)));
        }
        emc.map(output, im);
    }

    private void mapRecipe(IEMC emc, InfusionRecipe recipe) {
        ItemStack output = ItemStack.field_190927_a;
        Object o = recipe.getRecipeOutput();
        if (o instanceof ItemStack) {
            output = (ItemStack)o;
        }
        if (o instanceof Item) {
            output = new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            output = new ItemStack((Block)o);
        }
        if (output.func_190926_b()) {
            return;
        }
        ArrayList<CountedIngredient> im = new ArrayList<CountedIngredient>();
        int pearls = 0;
        ItemStack primPearl = new ItemStack(ItemsTC.primordialPearl);
        ArrayList<Ingredient> items = new ArrayList<Ingredient>();
        items.add(recipe.sourceInput);
        items.addAll((Collection<Ingredient>)recipe.getComponents());
        for (Ingredient i : items) {
            if (i.apply(primPearl)) {
                ++pearls;
                continue;
            }
            im.add(FakeItem.create(emc, 1, i));
        }
        FakeItem primordialPearl = new FakeItem();
        emc.register(primordialPearl, this.tc.getPrimordialPearlCost() / (long)ItemsTC.primordialPearl.getMaxDamage(primPearl));
        im.add(CountedIngredient.create(primordialPearl, pearls));
        AspectList vis = recipe.getAspects();
        for (Aspect a : vis.getAspects()) {
            FakeItem aspect = new FakeItem();
            emc.register(aspect, (long)this.tc.getAspectCost(a));
            im.add(CountedIngredient.create(aspect, vis.getAmount(a)));
        }
        FakeItem instability = new FakeItem();
        emc.register(instability, (long)(this.tc.instabilityMod * recipe.instability));
        im.add(CountedIngredient.create(instability, pearls));
        emc.map(output, im);
    }
}

