/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.extremeautocrafter;

import gnu.trove.TIntCollection;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import wanion.avaritiaddons.Config;
import wanion.lib.common.MetaItem;
import wanion.lib.common.control.ControlController;
import wanion.lib.common.control.IControl;
import wanion.lib.common.control.IControlInventory;
import wanion.lib.common.control.energy.EnergyControl;
import wanion.lib.common.control.redstone.RedstoneControl;

public final class TileEntityExtremeAutoCrafter
extends TileEntity
implements IControlInventory,
ITickable {
    public final int full = this.func_70302_i_() - 2;
    public final int half = this.full / 2;
    public final int powerConsumption;
    public final RedstoneControl redstoneControl;
    public final EnergyControl energyControl;
    private final ExtremeCraftingMatrix extremeCraftingMatrix;
    private final ControlController controlController;
    private NonNullList<ItemStack> itemStacks;
    private IExtremeRecipe cachedRecipe;
    private TIntIntMap patternMap;
    private IItemHandler itemHandler;

    public TileEntityExtremeAutoCrafter() {
        this.powerConsumption = this.half * Config.INSTANCE.powerMultiplier;
        this.extremeCraftingMatrix = new ExtremeCraftingMatrix((int)Math.sqrt(this.half));
        this.controlController = new ControlController((IInventory)this);
        this.itemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.cachedRecipe = null;
        this.patternMap = null;
        this.itemHandler = new ItemHandlerExtremeAutoCrafter(this);
        this.redstoneControl = new RedstoneControl((TileEntity)this);
        this.controlController.add((Object)this.redstoneControl);
        this.energyControl = new EnergyControl(this.powerConsumption * Config.INSTANCE.capacityMultiplier, this.powerConsumption);
        this.controlController.add((Object)this.energyControl);
    }

    public final void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        Collection allControls = this.controlController.getInstances();
        if (!allControls.stream().allMatch(IControl::canOperate)) {
            return;
        }
        if (this.cachedRecipe == null) {
            if (this.patternMap != null) {
                this.patternMap = null;
            }
            return;
        }
        ItemStack recipeStack = (ItemStack)this.itemStacks.get(this.func_70302_i_() - 1);
        ItemStack outputStack = (ItemStack)this.itemStacks.get(this.func_70302_i_() - 2);
        if (recipeStack.func_190926_b() || !outputStack.func_190926_b() && outputStack.func_190916_E() == outputStack.func_77976_d()) {
            return;
        }
        if (this.patternMap == null) {
            this.patternMap = MetaItem.getKeySizeMap((int)this.half, (int)this.full, this.itemStacks);
        }
        if (outputStack.func_190926_b() && this.notMatches(MetaItem.getSmartKeySizeMap((int)0, (int)this.half, this.itemStacks), this.patternMap)) {
            return;
        }
        if (!outputStack.func_190926_b() && outputStack.func_190916_E() + recipeStack.func_190916_E() > outputStack.func_77976_d() || this.notMatches(MetaItem.getSmartKeySizeMap((int)0, (int)this.half, this.itemStacks), this.patternMap)) {
            return;
        }
        allControls.forEach(IControl::operate);
        this.cleanInput();
        if (outputStack.func_190926_b()) {
            this.itemStacks.set(this.func_70302_i_() - 2, (Object)recipeStack.func_77946_l());
        } else {
            outputStack.func_190920_e(outputStack.func_190916_E() + recipeStack.func_190916_E());
        }
        this.func_70296_d();
    }

    private boolean notMatches(@Nonnull TIntIntMap inputMap, @Nonnull TIntIntMap patternMap) {
        if (inputMap.size() >= patternMap.size() && inputMap.keySet().containsAll((TIntCollection)patternMap.keySet())) {
            for (int key : patternMap.keys()) {
                if (inputMap.get(key) >= patternMap.get(key)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void cleanInput() {
        TIntIntHashMap patternMap = new TIntIntHashMap(this.patternMap);
        for (int i = 0; i < this.half && !patternMap.isEmpty(); ++i) {
            ItemStack itemStack = (ItemStack)this.itemStacks.get(i);
            int key = MetaItem.get((ItemStack)itemStack);
            if (!patternMap.containsKey(key)) continue;
            int total = patternMap.get(key);
            int dif = MathHelper.func_76125_a((int)total, (int)1, (int)itemStack.func_190916_E());
            if (itemStack.func_77973_b() == Items.field_151131_as || itemStack.func_77973_b() == Items.field_151129_at || itemStack.func_77973_b() instanceof UniversalBucket) {
                this.func_70299_a(i, new ItemStack(Items.field_151133_ar));
            } else if (!itemStack.func_77973_b().hasContainerItem(itemStack)) {
                itemStack.func_190920_e(itemStack.func_190916_E() - dif);
            }
            if (dif - total == 0) {
                patternMap.remove(key);
            } else {
                patternMap.put(key, total - dif);
            }
            if (itemStack.func_190916_E() != 0) continue;
            this.itemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public int func_70302_i_() {
        return 164;
    }

    public String func_70005_c_() {
        return "container.extreme_auto_crafter.name";
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.itemStacks) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.itemStacks.get(slot);
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int howMuch) {
        ItemStack slotStack = (ItemStack)this.itemStacks.get(slot);
        if (slotStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack newStack = slotStack.func_77946_l();
        newStack.func_190920_e(howMuch);
        slotStack.func_190920_e(slotStack.func_190916_E() - howMuch);
        if (slotStack.func_190926_b()) {
            this.itemStacks.set(slot, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        return newStack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack itemStack = (ItemStack)this.itemStacks.get(index);
        this.itemStacks.set(index, (Object)ItemStack.field_190927_a);
        return itemStack;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack itemStack) {
        this.itemStacks.set(slot, (Object)itemStack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemStack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    final void recipeShapeChanged() {
        IExtremeRecipe matchedRecipe = null;
        for (IExtremeRecipe extremeRecipe : AvaritiaRecipeManager.EXTREME_RECIPES.values()) {
            if (!extremeRecipe.matches((InventoryCrafting)this.extremeCraftingMatrix, this.field_145850_b)) continue;
            matchedRecipe = extremeRecipe;
            break;
        }
        this.itemStacks.set(this.func_70302_i_() - 1, (Object)((this.cachedRecipe = matchedRecipe) != null ? this.cachedRecipe.getRecipeOutput().func_77946_l() : ItemStack.field_190927_a));
        this.patternMap = null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public final void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.readCustomNBT(nbtTagCompound);
        this.recipeShapeChanged();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        this.writeCustomNBT(nbtTagCompound);
        return nbtTagCompound;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemHandler : (capability == CapabilityEnergy.ENERGY ? this.energyControl : super.getCapability(capability, facing)));
    }

    NBTTagCompound writeCustomNBT(NBTTagCompound nbtTagCompound) {
        this.controlController.getInstances().forEach(control -> control.writeToNBT(nbtTagCompound));
        NBTTagList nbtTagList = new NBTTagList();
        int max = this.func_70302_i_() - 1;
        for (int i = 0; i < max; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            NBTTagCompound slotCompound = new NBTTagCompound();
            slotCompound.func_74777_a("Slot", (short)i);
            nbtTagList.func_74742_a((NBTBase)itemStack.func_77955_b(slotCompound));
        }
        nbtTagCompound.func_74782_a("Contents", (NBTBase)nbtTagList);
        return nbtTagCompound;
    }

    void readCustomNBT(NBTTagCompound nbtTagCompound) {
        this.controlController.getInstances().forEach(control -> control.readFromNBT(nbtTagCompound));
        NBTTagList nbtTagList = nbtTagCompound.func_150295_c("Contents", 10);
        for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
            NBTTagCompound slotCompound = nbtTagList.func_150305_b(i);
            short slot = slotCompound.func_74765_d("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(slotCompound));
        }
    }

    @Nonnull
    public ControlController getControlController() {
        return this.controlController;
    }

    private static class ItemHandlerExtremeAutoCrafter
    extends InvWrapper {
        private final TileEntityExtremeAutoCrafter tileEntityAutoBiggerCraftingTable;

        private ItemHandlerExtremeAutoCrafter(@Nonnull TileEntityExtremeAutoCrafter tileEntityAutoBiggerCraftingTable) {
            super((IInventory)tileEntityAutoBiggerCraftingTable);
            this.tileEntityAutoBiggerCraftingTable = tileEntityAutoBiggerCraftingTable;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot >= this.tileEntityAutoBiggerCraftingTable.half ? stack : super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack slotStack;
            boolean full = slot == this.tileEntityAutoBiggerCraftingTable.full;
            ItemStack itemStack = slotStack = simulate ? this.getStackInSlot(slot).func_77946_l() : this.getStackInSlot(slot);
            if (full || slotStack.func_77973_b() == Items.field_151133_ar) {
                if (slotStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                ItemStack newStack = slotStack.func_77946_l();
                int newStackSize = MathHelper.func_76125_a((int)amount, (int)1, (int)newStack.func_190916_E());
                newStack.func_190920_e(newStackSize);
                slotStack.func_190920_e(slotStack.func_190916_E() - newStackSize);
                if (!simulate && slotStack.func_190926_b()) {
                    this.setStackInSlot(slot, ItemStack.field_190927_a);
                    this.getInv().func_70296_d();
                }
                return newStack;
            }
            return ItemStack.field_190927_a;
        }
    }

    private final class ExtremeCraftingMatrix
    extends InventoryCrafting {
        final int square;

        private ExtremeCraftingMatrix(int squareRoot) {
            super(new Container(){

                public boolean func_75145_c(@Nonnull EntityPlayer entityPlayer) {
                    return false;
                }
            }, squareRoot, squareRoot);
            this.square = squareRoot * squareRoot;
        }

        @Nonnull
        public ItemStack func_70301_a(int slot) {
            return (ItemStack)TileEntityExtremeAutoCrafter.this.itemStacks.get(this.square + slot);
        }
    }
}

