/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePlatform;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.api.entity.living.player.Player;

public interface ForgePermissionsProvider {
    public boolean hasPermission(EntityPlayerMP var1, String var2);

    public void registerPermission(ICommand var1, String var2);

    public static class SpongePermissionsProvider
    implements ForgePermissionsProvider {
        @Override
        public boolean hasPermission(EntityPlayerMP player, String permission) {
            return ((Player)player).hasPermission(permission);
        }

        @Override
        public void registerPermission(ICommand command, String permission) {
        }
    }

    public static class VanillaPermissionsProvider
    implements ForgePermissionsProvider {
        private ForgePlatform platform;

        public VanillaPermissionsProvider(ForgePlatform platform) {
            this.platform = platform;
        }

        @Override
        public boolean hasPermission(EntityPlayerMP player, String permission) {
            ForgeConfiguration configuration = this.platform.getConfiguration();
            return configuration.cheatMode || FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH()) || configuration.creativeEnable && player.field_71134_c.func_73081_b() == GameType.CREATIVE;
        }

        @Override
        public void registerPermission(ICommand command, String permission) {
        }
    }
}

